/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph;

import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.IPlotCommit;
import org.eclipse.emf.emfstore.internal.client.ui.views.historybrowserview.graph.PlotLane;
import org.eclipse.swt.graphics.Color;

public abstract class AbstractPlotRenderer {
    private static final int LANE_WIDTH = 14;
    private static final int LINE_WIDTH = 2;
    private static final int LEFT_PAD = 2;

    protected void paintCommit(IPlotCommit commit, int h) {
        int textx;
        int dotSize = this.computeDotSize(h);
        PlotLane myLane = commit.getLane();
        int myLaneX = this.laneC(myLane);
        Color myColor = this.laneColor(myLane, true);
        int maxCenter = 0;
        PlotLane[] plotLaneArray = commit.getPassingLanes();
        int n = plotLaneArray.length;
        int n2 = 0;
        while (n2 < n) {
            PlotLane passingLane = plotLaneArray[n2];
            int cx = this.laneC(passingLane);
            Color c = this.laneColor(passingLane, commit.isRealCommit());
            this.drawLine(c, cx, 0, cx, h, 2);
            maxCenter = Math.max(maxCenter, cx);
            ++n2;
        }
        int nParent = commit.getParentCount();
        int i = 0;
        while (i < nParent) {
            IPlotCommit p = commit.getParent(i);
            PlotLane pLane = p.getLane();
            if (pLane != null) {
                Color pColor = this.laneColor(pLane, true);
                int cx = this.laneC(pLane);
                if (commit.isRealCommit()) {
                    if (Math.abs(myLaneX - cx) > 14) {
                        int ix;
                        if (myLaneX < cx) {
                            ix = cx - 7;
                            this.drawLine(pColor, myLaneX, h / 2, ix, h / 2, 2);
                            this.drawLine(pColor, ix, h / 2, cx, h, 2);
                        } else {
                            ix = cx + 7;
                            this.drawLine(pColor, myLaneX, h / 2, ix, h / 2, 2);
                            this.drawLine(pColor, ix, h / 2, cx, h, 2);
                        }
                    } else {
                        this.drawLine(pColor, myLaneX, h / 2, cx, h, 2);
                    }
                } else {
                    this.drawLine(this.laneColor(pLane, false), cx, 0, cx, h, 2);
                }
                maxCenter = Math.max(maxCenter, cx);
            }
            ++i;
        }
        int dotX = myLaneX - dotSize / 2 - 1;
        int dotY = (h - dotSize) / 2;
        if (commit.isRealCommit() && !commit.isLocalHistoryOnly() && commit.getChildCount() > 0) {
            this.drawLine(myColor, myLaneX, 0, myLaneX, dotY, 2);
        }
        if (commit.isRealCommit() && !commit.isLocalHistoryOnly()) {
            this.drawCommitDot(dotX, dotY, dotSize, dotSize);
            textx = Math.max(maxCenter + 7, dotX + dotSize) + 8;
        } else {
            textx = -dotSize / 2;
        }
        if (commit.isRealCommit()) {
            textx += this.drawLabel(textx + dotSize, h / 2, commit);
        }
    }

    protected abstract int drawLabel(int var1, int var2, IPlotCommit var3);

    private int computeDotSize(int h) {
        int d = (int)((float)Math.min(h, 14) * 0.5f);
        d += d & 1;
        return d;
    }

    protected abstract Color laneColor(PlotLane var1, boolean var2);

    protected abstract void drawLine(Color var1, int var2, int var3, int var4, int var5, int var6);

    protected abstract void drawCommitDot(int var1, int var2, int var3, int var4);

    protected abstract void drawBoundaryDot(int var1, int var2, int var3, int var4);

    protected abstract void drawText(String var1, int var2, int var3);

    private int laneX(PlotLane myLane) {
        int p = myLane != null ? myLane.getPosition() : 0;
        return 2 + 14 * p;
    }

    private int laneC(PlotLane myLane) {
        return this.laneX(myLane) + 7;
    }
}

