/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent;

import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMLHelper;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.XMLHelperImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLLoadImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.emfstore.internal.common.model.util.ModelUtil;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.AbstractOperationEmitter;
import org.eclipse.emf.emfstore.internal.server.model.versioning.impl.persistent.Direction;
import org.eclipse.emf.emfstore.internal.server.model.versioning.operations.AbstractOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationEmitter
extends AbstractOperationEmitter {
    public OperationEmitter(Direction direction, File file) {
        super(direction, file);
    }

    public Optional<AbstractOperation> tryEmit() throws IOException {
        final PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream(pos);
        new Thread(new Runnable(){

            public void run() {
                if (OperationEmitter.this.getDirection() == Direction.Forward) {
                    OperationEmitter.this.readForward(pos);
                } else {
                    OperationEmitter.this.readBackward(pos);
                }
            }
        }).start();
        try {
            EObject deserializedObject = this.deserialize(pis);
            if (AbstractOperation.class.isInstance(deserializedObject)) {
                Optional optional = Optional.of((Object)((AbstractOperation)AbstractOperation.class.cast(deserializedObject)));
                return optional;
            }
            Optional optional = Optional.absent();
            return optional;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            pis.close();
        }
    }

    private EObject deserialize(PipedInputStream pis) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"virtualResource.xmi"));
        ((XMLResourceImpl)resource).setIntrinsicIDToEObjectMap((Map)Maps.newLinkedHashMap());
        XMLLoadImpl xmlLoadImpl = new XMLLoadImpl((XMLHelper)new XMLHelperImpl());
        xmlLoadImpl.load((XMLResource)resource, (InputStream)pis, ModelUtil.getResourceLoadOptions());
        return (EObject)resource.getContents().get(0);
    }
}

