/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.jdt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.jdt.JdtPropertyGetter;
import org.eclipse.epsilon.emc.jdt.JdtUtil;
import org.eclipse.epsilon.emc.jdt.ReflectiveASTVisitor;
import org.eclipse.epsilon.emc.jdt.SearchableTypeCollection;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.TypeDeclaration;

public class JdtModel
extends CachedModel<Object> {
    protected List<String> supportedTypes = Arrays.asList("JavaProject", "Package");
    protected ReflectiveASTVisitor visitor = null;
    protected boolean resolveBindings = false;
    protected List<IJavaProject> projects = new ArrayList<IJavaProject>();
    protected JdtPropertyGetter propertyGetter;
    public static final String PROPERTY_PROJECTS = "projects";
    public static final String PROPERTY_RESOLVE_BINDINGS = "resolveBindings";

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        throw new UnsupportedOperationException();
    }

    public String getTypeNameOf(Object instance) {
        return instance.getClass().getSimpleName();
    }

    public Object getElementById(String id) {
        throw new UnsupportedOperationException();
    }

    public String getElementId(Object instance) {
        throw new UnsupportedOperationException();
    }

    public void setElementId(Object instance, String newId) {
        throw new UnsupportedOperationException();
    }

    public boolean owns(Object instance) {
        return instance instanceof IJavaElement || instance instanceof ASTNode;
    }

    public boolean isInstantiable(String type) {
        return false;
    }

    public Collection<Object> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        if (TypeDeclaration.class.getSimpleName().equals(type)) {
            return this.getAllOfTypeFromModel(type);
        }
        return super.getAllOfType(type);
    }

    public Collection<Object> getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        if (TypeDeclaration.class.getSimpleName().equals(type)) {
            return this.getAllOfKindFromModel(type);
        }
        return super.getAllOfType(type);
    }

    public boolean hasType(String type) {
        try {
            return this.supportedTypes.contains(type) || Class.forName("org.eclipse.jdt.core.dom." + type) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public boolean store(String location) {
        throw new UnsupportedOperationException();
    }

    public boolean store() {
        throw new UnsupportedOperationException();
    }

    protected Collection<Object> allContentsFromModel() {
        return Collections.emptyList();
    }

    protected Collection<Object> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        try {
            if (TypeDeclaration.class.getSimpleName().equals(type)) {
                return new SearchableTypeCollection(this.projects.toArray(new IJavaProject[0]), this.visitor);
            }
            return this.visitor.getAllOfType(type);
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    protected Collection<Object> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        return this.getAllOfTypeFromModel(kind);
    }

    protected Object createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        throw new UnsupportedOperationException();
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        String[] projectNames = properties.getProperty(PROPERTY_PROJECTS, "").split(",");
        try {
            this.projects = JdtUtil.getIJavaProjects(JdtUtil.getIProjects(projectNames));
        }
        catch (CoreException e) {
            throw new EolModelLoadingException((Exception)((Object)e), (IModel)this);
        }
        this.resolveBindings = Boolean.parseBoolean(properties.getProperty(PROPERTY_RESOLVE_BINDINGS));
        this.visitor = new ReflectiveASTVisitor(this.projects, this.resolveBindings);
        this.loadModel();
    }

    protected void loadModel() throws EolModelLoadingException {
    }

    protected void disposeModel() {
        this.propertyGetter = null;
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        throw new UnsupportedOperationException();
    }

    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    public boolean isOfKind(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        return this.getAllTypeNamesOf(instance).contains(metaClass);
    }

    public boolean isOfType(Object instance, String metaClass) throws EolModelElementTypeNotFoundException {
        return instance.getClass().getSimpleName().equals(metaClass);
    }

    protected Collection<String> getAllTypeNamesOf(Object instance) {
        Class<?> c = instance.getClass();
        ArrayList<String> allTypeNames = new ArrayList<String>();
        while (c != null && c != Object.class) {
            allTypeNames.add(c.getSimpleName());
            c = c.getSuperclass();
        }
        return allTypeNames;
    }

    public IPropertyGetter getPropertyGetter() {
        if (this.propertyGetter == null) {
            this.propertyGetter = new JdtPropertyGetter(this.resolveBindings);
        }
        return this.propertyGetter;
    }
}

