/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.jdt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;

public class ReflectiveASTVisitor
extends ASTVisitor {
    protected List<Object> all = null;
    protected String type = null;
    protected boolean ofTypeOnly = false;
    protected Collection<IJavaProject> projects = null;
    protected boolean resolveBindings = false;
    protected ASTParser parser = null;

    public ReflectiveASTVisitor(Collection<IJavaProject> projects, boolean ifBindings) {
        this.projects = projects;
        this.resolveBindings = ifBindings;
    }

    protected ASTParser getASTParser() {
        if (this.parser == null) {
            this.parser = ASTParser.newParser((int)8);
            this.parser.setKind(8);
            this.parser.setResolveBindings(this.resolveBindings);
        }
        return this.parser;
    }

    private Collection<Object> getAll(String type) throws JavaModelException {
        this.all = new ArrayList<Object>();
        this.type = type;
        for (IJavaProject project : this.projects) {
            IPackageFragment[] iPackageFragmentArray = project.getPackageFragments();
            int n = iPackageFragmentArray.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragment packageFragment = iPackageFragmentArray[n2];
                if (packageFragment.getKind() == 1) {
                    ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
                    int n3 = iCompilationUnitArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ICompilationUnit compilationUnit = iCompilationUnitArray[n4];
                        ASTParser parser = this.getASTParser();
                        parser.setSource(compilationUnit);
                        parser.createAST(null).accept((ASTVisitor)this);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        return this.all;
    }

    public Collection<Object> getAllOfKind(String type) throws JavaModelException {
        this.ofTypeOnly = false;
        return this.getAll(type);
    }

    public Collection<Object> getAllOfType(String type) throws JavaModelException {
        this.ofTypeOnly = true;
        return this.getAll(type);
    }

    public void preVisit(ASTNode node) {
        if (node.getClass().getSimpleName().equals(this.type)) {
            this.all.add(node);
        } else if (!this.ofTypeOnly) {
            Class<?> superClass = node.getClass().getSuperclass();
            while (superClass != Object.class) {
                if (superClass.getSimpleName().equals(this.type)) {
                    this.all.add(node);
                    break;
                }
                superClass = superClass.getSuperclass();
            }
        }
    }
}

