/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.rdfconnection;

import java.net.http.HttpClient;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkHTTP;
import org.apache.jena.rdflink.RDFLinkHTTPBuilder;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.sparql.exec.http.QuerySendMode;
import org.apache.jena.sparql.exec.http.UpdateSendMode;

public class RDFConnectionRemoteBuilder {
    static String SameAsDestination = "";
    protected final RDFLinkHTTPBuilder builder;

    protected RDFConnectionRemoteBuilder() {
        this(RDFLinkHTTP.newBuilder());
    }

    protected RDFConnectionRemoteBuilder(RDFLinkHTTPBuilder builder) {
        this.builder = builder;
    }

    public RDFConnectionRemoteBuilder destination(String destination) {
        this.builder.destination(destination);
        return this;
    }

    public RDFConnectionRemoteBuilder queryOnly() {
        this.builder.queryOnly();
        return this;
    }

    public RDFConnectionRemoteBuilder queryEndpoint(String sQuery) {
        this.builder.queryEndpoint(sQuery);
        return this;
    }

    public RDFConnectionRemoteBuilder updateEndpoint(String sUpdate) {
        this.builder.updateEndpoint(sUpdate);
        return this;
    }

    public RDFConnectionRemoteBuilder gspEndpoint(String sGSP) {
        this.builder.gspEndpoint(sGSP);
        return this;
    }

    public RDFConnectionRemoteBuilder httpClient(HttpClient httpClient) {
        this.builder.httpClient(httpClient);
        return this;
    }

    public RDFConnectionRemoteBuilder quadsFormat(RDFFormat fmtQuads) {
        this.builder.quadsFormat(fmtQuads);
        return this;
    }

    public RDFConnectionRemoteBuilder quadsFormat(Lang langQuads) {
        this.builder.quadsFormat(langQuads);
        return this;
    }

    public RDFConnectionRemoteBuilder quadsFormat(String langQuads) {
        this.builder.quadsFormat(langQuads);
        return this;
    }

    public RDFConnectionRemoteBuilder triplesFormat(RDFFormat fmtTriples) {
        this.builder.triplesFormat(fmtTriples);
        return this;
    }

    public RDFConnectionRemoteBuilder triplesFormat(Lang langTriples) {
        this.builder.triplesFormat(langTriples);
        return this;
    }

    public RDFConnectionRemoteBuilder triplesFormat(String langTriples) {
        this.builder.triplesFormat(langTriples);
        Lang lang = RDFLanguages.nameToLang(langTriples);
        if (lang == null) {
            throw new RiotException("Language name not recognized: " + langTriples);
        }
        this.quadsFormat(lang);
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderGraph(String acceptGraph) {
        this.builder.acceptHeaderGraph(acceptGraph);
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderDataset(String acceptDataset) {
        this.builder.acceptHeaderDataset(acceptDataset);
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderSelectQuery(String acceptSelectHeader) {
        this.builder.acceptHeaderSelectQuery(acceptSelectHeader);
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderAskQuery(String acceptAskHeader) {
        this.builder.acceptHeaderAskQuery(acceptAskHeader);
        return this;
    }

    public RDFConnectionRemoteBuilder acceptHeaderQuery(String acceptHeader) {
        this.builder.acceptHeaderQuery(acceptHeader);
        return this;
    }

    public RDFConnectionRemoteBuilder parseCheckSPARQL(boolean parseCheck) {
        this.builder.parseCheckSPARQL(parseCheck);
        return this;
    }

    public RDFConnectionRemoteBuilder querySendMode(QuerySendMode sendMode) {
        this.builder.querySendMode(sendMode);
        return this;
    }

    public RDFConnectionRemoteBuilder updateSendMode(UpdateSendMode sendMode) {
        this.builder.updateSendMode(sendMode);
        return this;
    }

    public final RDFConnection build() {
        RDFLink rdfLink = this.buildLink();
        return this.adaptLink(rdfLink);
    }

    protected RDFLink buildLink() {
        return this.builder.build();
    }

    protected RDFConnection adaptLink(RDFLink rdfLink) {
        return RDFConnectionAdapter.adapt(rdfLink);
    }
}

