/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.wireformats;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gdata.util.ContentType;
import com.google.gdata.util.common.base.Preconditions;
import com.google.gdata.wireformats.WireFormat;
import java.util.Collection;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltFormat {
    public static final AltFormat RSS = AltFormat.builder().setName("rss").setWireFormat(WireFormat.XML).setContentType(ContentType.RSS).setAcceptableXmlTypes().setSelectableByType(true).build();
    public static final AltFormat OPENSEARCH = AltFormat.builder().setName("opensearch").setWireFormat(WireFormat.XML).setContentType(ContentType.OPENSEARCH).setAcceptableXmlTypes().setSelectableByType(true).build();
    public static final AltFormat ATOM_SERVICE = AltFormat.builder().setName("atom-service").setWireFormat(WireFormat.XML).setContentType(ContentType.ATOM_SERVICE).setAcceptableXmlTypes().setSelectableByType(true).build();
    public static final AltFormat APPLICATION_XML = AltFormat.builder().setName("application-xml").setWireFormat(WireFormat.XML).setContentType(ContentType.APPLICATION_XML).setAcceptableXmlTypes().setSelectableByType(true).build();
    public static final AltFormat MEDIA = AltFormat.builder().setName("media").setContentType(ContentType.ANY).build();
    public static final AltFormat MEDIA_MULTIPART = AltFormat.builder().setName("media-multipart").setContentType(ContentType.MULTIPART_RELATED).setSelectableByType(true).build();
    public static final AltFormat ATOM = AltFormat.builder().setName("atom").setWireFormat(WireFormat.XML).setContentType(ContentType.ATOM).setAcceptableXmlTypes().addAllowedInputFormats(MEDIA, MEDIA_MULTIPART, APPLICATION_XML).setSelectableByType(true).build();
    private final String name;
    private final WireFormat wireFormat;
    private final ContentType contentType;
    private final List<ContentType> acceptList;
    private final boolean isSelectableByType;
    private final Set<AltFormat> extraInputFormats;
    private final AltFormat base;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AltFormat format) {
        return new Builder(format);
    }

    private AltFormat(Builder builder) {
        this.base = builder.base;
        this.name = builder.name;
        this.wireFormat = builder.wireFormat;
        this.contentType = builder.contentType;
        ImmutableList.Builder acceptListBuilder = ImmutableList.builder();
        acceptListBuilder.add((Object)this.contentType);
        if (builder.acceptableTypes != null) {
            acceptListBuilder.addAll((Iterable)builder.acceptableTypes);
        }
        this.acceptList = acceptListBuilder.build();
        this.isSelectableByType = builder.isSelectableByType;
        this.extraInputFormats = builder.extraInputFormats.build();
    }

    @Deprecated
    public AltFormat(String name, WireFormat wireFormat, ContentType contentType, List<ContentType> acceptList, boolean isSelectableByType) {
        this(AltFormat.builder().setName(name).setWireFormat(wireFormat).setContentType(contentType).setAcceptableTypes(acceptList).setSelectableByType(isSelectableByType).check());
    }

    public String getName() {
        return this.name;
    }

    public WireFormat getWireFormat() {
        return this.wireFormat;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public List<ContentType> getMatchingTypes() {
        return this.acceptList;
    }

    public boolean isSelectableByType() {
        return this.isSelectableByType;
    }

    public boolean allowInputFormat(AltFormat inputFormat) {
        return inputFormat == this || this.extraInputFormats.contains(inputFormat);
    }

    public boolean hasBaseFormat() {
        return this.base != null;
    }

    public AltFormat getBaseFormat() {
        return this.base;
    }

    public boolean equals(Object o) {
        return o == this || o instanceof AltFormat && this.name.equals(((AltFormat)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name + "[" + this.contentType + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private String name;
        private WireFormat wireFormat;
        private ContentType contentType;
        private Set<ContentType> acceptableTypes;
        private final ImmutableSet.Builder<AltFormat> extraInputFormats = ImmutableSet.builder();
        private boolean isSelectableByType;
        private AltFormat base;

        private Builder() {
        }

        private Builder(AltFormat prototype) {
            this.name = prototype.name;
            this.wireFormat = prototype.wireFormat;
            this.contentType = prototype.contentType;
            this.acceptableTypes = ImmutableSet.copyOf((Collection)prototype.acceptList);
            this.extraInputFormats.addAll((Iterable)prototype.extraInputFormats);
            this.isSelectableByType = prototype.isSelectableByType;
            this.base = prototype.base;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setWireFormat(WireFormat wireFormat) {
            this.wireFormat = wireFormat;
            return this;
        }

        public Builder setContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setSelectableByType(boolean isSelectableByType) {
            this.isSelectableByType = isSelectableByType;
            return this;
        }

        public Builder setBaseFormat(AltFormat base) {
            this.base = base;
            return this;
        }

        public Builder setAcceptableTextTypes() {
            return this.setAcceptableTypes(ContentType.TEXT_PLAIN);
        }

        public Builder setAcceptableXmlTypes() {
            return this.setAcceptableTypes(ContentType.TEXT_XML, ContentType.TEXT_PLAIN);
        }

        public Builder setAcceptableTypes(ContentType ... types) {
            this.acceptableTypes = types == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])types);
            return this;
        }

        private Builder setAcceptableTypes(Iterable<ContentType> types) {
            this.acceptableTypes = types == null ? ImmutableSet.of() : ImmutableSet.copyOf(types);
            return this;
        }

        public Builder addAllowedInputFormats(AltFormat ... formats) {
            for (AltFormat format : formats) {
                this.extraInputFormats.add((Object)format);
            }
            return this;
        }

        public AltFormat build() {
            this.check();
            return new AltFormat(this);
        }

        private Builder check() {
            Preconditions.checkState(this.name != null, "Name must be set");
            Preconditions.checkState(this.contentType != null, "contentType must be set");
            return this;
        }
    }
}

