/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.simulink.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.epsilon.common.util.Multimap;
import org.eclipse.epsilon.common.util.StringProperties;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEngine;
import org.eclipse.epsilon.emc.simulink.engine.MatlabEnginePool;
import org.eclipse.epsilon.emc.simulink.exception.MatlabException;
import org.eclipse.epsilon.emc.simulink.exception.MatlabRuntimeException;
import org.eclipse.epsilon.emc.simulink.introspection.java.SimulinkPropertyGetter;
import org.eclipse.epsilon.emc.simulink.introspection.java.SimulinkPropertySetter;
import org.eclipse.epsilon.emc.simulink.model.TypeHelper;
import org.eclipse.epsilon.emc.simulink.model.element.ISimulinkModelElement;
import org.eclipse.epsilon.emc.simulink.model.element.SimulinkBlock;
import org.eclipse.epsilon.emc.simulink.model.element.StateflowBlock;
import org.eclipse.epsilon.emc.simulink.operations.contributors.ModelOperationContributor;
import org.eclipse.epsilon.emc.simulink.util.MatlabEngineUtil;
import org.eclipse.epsilon.emc.simulink.util.SimulinkUtil;
import org.eclipse.epsilon.eol.exceptions.EolInternalException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.execute.operations.contributors.IOperationContributorProvider;
import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.models.CachedModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IRelativePathResolver;

public class SimulinkModel
extends CachedModel<ISimulinkModelElement>
implements IOperationContributorProvider {
    public static final String PROPERTY_FILE = "file";
    public static final String PROPERTY_LIBRARY_PATH = "library_path";
    public static final String PROPERTY_ENGINE_JAR_PATH = "engine_jar_path";
    public static final String PROPERTY_SHOW_IN_MATLAB_EDITOR = "hidden_editor";
    public static final String PROPERTY_FOLLOW_LINKS = "follow_links";
    public static final String PROPERTY_WORKING_DIR = "working_dir";
    public static final String BLOCK = "Block";
    public static final String SIMULINK = "Simulink";
    public static final String STATEFLOW = "Stateflow";
    public static final String PWD = "cd ?;";
    public static final String GET_PARAM = "get_param('?', 'Handle');";
    public static final String LOAD_SYSTEM = "load_system ?";
    public static final String OPEN_SYSTEM = "open_system ?";
    public static final String NEW_SYSTEM = "new_system('?', 'Model');";
    public static final String SAVE_SYSTEM = "save_system('?', '?');";
    private static final Multimap<String, String> createBlockMap = new Multimap();
    private static final ArrayList<ArrayList<String>> deleteBlockMap = new ArrayList();
    protected File file = null;
    protected SimulinkPropertyGetter propertyGetter;
    protected SimulinkPropertySetter propertySetter;
    protected ModelOperationContributor simulinkOperationContributor;
    protected File workingDir = null;
    protected String libraryPath;
    protected String engineJarPath;
    protected MatlabEngine engine;
    protected boolean showInMatlabEditor = false;
    protected boolean followLinks = true;
    protected double handle = -1.0;

    static {
        createBlockMap.put((Object)"sflib/Chart", (Object)"Stateflow.Chart");
        ArrayList<String> chart = new ArrayList<String>();
        chart.add("SubSystem");
        chart.add("Stateflow.Chart");
        deleteBlockMap.add(chart);
    }

    protected void loadModel() throws EolModelLoadingException {
        try {
            this.engine = MatlabEnginePool.getInstance(this.libraryPath, this.engineJarPath).getMatlabEngine();
            this.simulinkOperationContributor = new ModelOperationContributor(this.engine);
            try {
                String pwd;
                String string = pwd = this.workingDir != null ? this.workingDir.getAbsolutePath() : this.file.getParentFile().getAbsolutePath();
                if (pwd != null) {
                    this.engine.eval(PWD, pwd);
                }
            }
            catch (Exception exception) {}
            if (!this.readOnLoad) {
                try {
                    this.engine.eval(NEW_SYSTEM, this.getSimulinkModelName());
                }
                catch (Exception exception) {}
            }
            String cmd = this.showInMatlabEditor ? OPEN_SYSTEM : LOAD_SYSTEM;
            this.engine.eval(cmd, this.getSimulinkModelName());
            this.handle = (Double)this.engine.evalWithResult(GET_PARAM, this.getSimulinkModelName());
        }
        catch (Exception e) {
            throw new EolModelLoadingException(e, (IModel)this);
        }
    }

    protected void disposeModel() {
        try {
            MatlabEnginePool.getInstance(this.libraryPath, this.engineJarPath).release(this.engine);
        }
        catch (MatlabRuntimeException matlabRuntimeException) {}
    }

    protected ISimulinkModelElement createInstanceInModel(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (type.contains("/")) {
            try {
                return new SimulinkBlock(this, this.engine, type);
            }
            catch (MatlabRuntimeException matlabRuntimeException) {
                throw new EolNotInstantiableModelElementTypeException(this.getSimulinkModelName(), type);
            }
        }
        if (type.startsWith("Stateflow.")) {
            try {
                return new StateflowBlock(this, this.engine, type);
            }
            catch (MatlabException matlabException) {
                throw new EolNotInstantiableModelElementTypeException(this.getSimulinkModelName(), type);
            }
        }
        throw new EolModelElementTypeNotFoundException(type, null);
    }

    protected void addToCache(String type, ISimulinkModelElement instance) throws EolModelElementTypeNotFoundException {
        for (String kind : this.getAllTypeNamesOf(instance)) {
            Object kindCacheKey = this.getCacheKeyForType(kind);
            if (!this.cachedKinds.contains(kindCacheKey)) continue;
            this.kindCache.put(kindCacheKey, (Object)instance);
        }
    }

    protected void removeFromCache(ISimulinkModelElement instance) throws EolModelElementTypeNotFoundException {
        for (String kind : this.getAllTypeNamesOf(instance)) {
            Object kindCacheKey = this.getCacheKeyForType(kind);
            if (!this.cachedKinds.contains(kindCacheKey)) continue;
            this.kindCache.remove(kindCacheKey, (Object)instance);
        }
    }

    public void deleteElement(Object o) throws EolRuntimeException {
        this.deleteElementInModel(o);
        if (this.isCachingEnabled() && o instanceof ISimulinkModelElement) {
            this.removeFromCache((ISimulinkModelElement)o);
            String type = ((ISimulinkModelElement)o).getType();
            for (List list : deleteBlockMap) {
                if (!list.contains(type)) continue;
                for (String equivalent : list) {
                    if (equivalent.equals(type) || !this.cachedKinds.contains(equivalent)) continue;
                    this.kindCache.get((Object)equivalent).clear();
                    this.kindCache.putAll((Object)equivalent, this.getAllOfTypeFromModel(equivalent));
                }
            }
        }
    }

    public ISimulinkModelElement createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        ISimulinkModelElement instance = this.createInstanceInModel(type);
        if (this.isCachingEnabled()) {
            this.addToCache(instance.getType(), instance);
            if (createBlockMap.containsKey((Object)type)) {
                for (String equivalent : createBlockMap.get((Object)type)) {
                    if (!this.cachedKinds.contains(equivalent)) continue;
                    this.kindCache.get((Object)equivalent).clear();
                    this.kindCache.putAll((Object)equivalent, this.getAllOfTypeFromModel(equivalent));
                }
            }
        }
        return instance;
    }

    public Object createInstance(String type, Collection<Object> parameters) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        if (type.startsWith(STATEFLOW) && parameters.size() == 1) {
            Object parentObject = parameters.toArray()[0];
            try {
                if (parentObject instanceof StateflowBlock) {
                    try {
                        StateflowBlock instance = new StateflowBlock(this, this.engine, type, (StateflowBlock)parentObject);
                        if (this.isCachingEnabled()) {
                            this.addToCache(instance.getType(), instance);
                            if (createBlockMap.containsKey((Object)type)) {
                                for (String equivalent : createBlockMap.get((Object)type)) {
                                    if (!this.cachedKinds.contains(equivalent)) continue;
                                    this.kindCache.get((Object)equivalent).clear();
                                    this.kindCache.putAll((Object)equivalent, this.getAllOfTypeFromModel(equivalent));
                                }
                            }
                        }
                        return instance;
                    }
                    catch (MatlabException e) {
                        throw new EolModelElementTypeNotFoundException(type, null, e.getMessage());
                    }
                }
                throw new EolModelElementTypeNotFoundException(type, null, "invalid parameters");
            }
            catch (EolRuntimeException e) {
                throw new EolModelElementTypeNotFoundException(type, null, e.getMessage());
            }
        }
        throw new EolModelElementTypeNotFoundException(type, null);
    }

    protected boolean deleteElementInModel(Object instance) throws EolRuntimeException {
        try {
            if (instance instanceof ISimulinkModelElement) {
                return ((ISimulinkModelElement)instance).deleteElementInModel();
            }
            return false;
        }
        catch (Exception e) {
            throw new EolInternalException((Throwable)e);
        }
    }

    protected Object getCacheKeyForType(String type) throws EolModelElementTypeNotFoundException {
        return type;
    }

    protected Collection<String> getAllTypeNamesOf(Object instance) {
        if (instance instanceof ISimulinkModelElement) {
            return ((ISimulinkModelElement)instance).getAllTypeNamesOf();
        }
        return Arrays.asList(this.getTypeNameOf(instance));
    }

    protected Collection<ISimulinkModelElement> allContentsFromModel() {
        return TypeHelper.getAll(this.engine, this);
    }

    protected Collection<ISimulinkModelElement> getAllOfTypeFromModel(String type) throws EolModelElementTypeNotFoundException {
        return TypeHelper.getAllOfType(this, this.engine, type);
    }

    protected Collection<ISimulinkModelElement> getAllOfKindFromModel(String kind) throws EolModelElementTypeNotFoundException {
        try {
            return TypeHelper.Kind.get(kind).getAll(this.engine, this);
        }
        catch (Exception exception) {
            try {
                return this.getAllOfTypeFromModel(kind);
            }
            catch (Exception exception2) {
                throw new EolModelElementTypeNotFoundException(null, null);
            }
        }
    }

    public static void main(String[] args) throws Exception {
        File tmpFile = File.createTempFile("foo", ".slx");
        SimulinkModel model = new SimulinkModel();
        model.setName("M");
        model.setFile(tmpFile);
        model.setWorkingDir(tmpFile.getParentFile());
        model.setReadOnLoad(false);
        model.setStoredOnDisposal(false);
        model.setShowInMatlabEditor(true);
        model.setFollowLinks(false);
        model.load();
        System.out.println(model.getAllOfType("Gain"));
    }

    public void load(StringProperties properties, IRelativePathResolver resolver) throws EolModelLoadingException {
        super.load(properties, resolver);
        String filePath = properties.getProperty(PROPERTY_FILE);
        String workingDirPath = properties.getProperty(PROPERTY_WORKING_DIR);
        if (properties.hasProperty(PROPERTY_LIBRARY_PATH)) {
            this.libraryPath = properties.getProperty(PROPERTY_LIBRARY_PATH);
        }
        if (properties.hasProperty(PROPERTY_ENGINE_JAR_PATH)) {
            this.engineJarPath = properties.getProperty(PROPERTY_ENGINE_JAR_PATH);
        }
        if (properties.hasProperty(PROPERTY_SHOW_IN_MATLAB_EDITOR)) {
            this.showInMatlabEditor = properties.getBooleanProperty(PROPERTY_SHOW_IN_MATLAB_EDITOR, false);
        }
        if (properties.hasProperty(PROPERTY_FOLLOW_LINKS)) {
            this.followLinks = properties.getBooleanProperty(PROPERTY_FOLLOW_LINKS, true);
        }
        if (filePath != null && filePath.trim().length() > 0) {
            this.file = new File(resolver.resolve(filePath));
        }
        this.workingDir = workingDirPath != null && workingDirPath.trim().length() > 0 ? new File(resolver.resolve(filePath)) : this.file.getParentFile();
        this.load();
    }

    public void simulate() throws InterruptedException {
        String name = this.getFile().getName().substring(0, this.getFile().getName().lastIndexOf("."));
        try {
            Future<Void> fSim = this.engine.evalAsync("simout = sim('" + name + "', []);");
            while (!fSim.isDone()) {
                Thread.sleep(1000L);
            }
        }
        catch (MatlabException e) {
            e.printStackTrace();
        }
    }

    public boolean hasType(String type) {
        return true;
    }

    public String getTypeNameOf(Object instance) {
        if (instance instanceof ISimulinkModelElement) {
            return ((ISimulinkModelElement)instance).getType();
        }
        return instance.getClass().getSimpleName().replace(SIMULINK, "");
    }

    public Object getElementById(String id) {
        return null;
    }

    public void setElementId(Object instance, String newId) {
    }

    public String getElementId(Object instance) {
        try {
            return (String)this.propertyGetter.invoke(instance, "id");
        }
        catch (EolRuntimeException eolRuntimeException) {
            return "";
        }
    }

    public boolean owns(Object instance) {
        if (instance == null) {
            return false;
        }
        return instance instanceof ISimulinkModelElement && ((ISimulinkModelElement)instance).getOwningModel() == this || instance instanceof SimulinkModel || instance.getClass().getCanonicalName().startsWith("org.eclipse.epsilon.emc.simulink.types");
    }

    public boolean store(String location) {
        try {
            this.engine.eval(SAVE_SYSTEM, this.getSimulinkModelName(), location);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean store() {
        this.store(this.file.getAbsolutePath());
        return true;
    }

    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        throw new UnsupportedOperationException();
    }

    public boolean isInstantiable(String type) {
        return this.hasType(type);
    }

    public String getSimulinkModelName() {
        String name = this.file.getName();
        int pos = name.lastIndexOf(".");
        if (pos > 0) {
            name = name.substring(0, pos);
        }
        return name;
    }

    public IPropertySetter getPropertySetter() {
        if (this.propertySetter == null) {
            this.propertySetter = new SimulinkPropertySetter(this.engine);
        }
        return this.propertySetter;
    }

    public IPropertyGetter getPropertyGetter() {
        if (this.propertyGetter == null) {
            this.propertyGetter = new SimulinkPropertyGetter();
        }
        return this.propertyGetter;
    }

    public OperationContributor getOperationContributor() {
        return this.simulinkOperationContributor;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public MatlabEngine getEngine() {
        return this.engine;
    }

    public Double getHandle() {
        return this.handle;
    }

    public String getLibraryPath() {
        return this.libraryPath;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public String getEngineJarPath() {
        return this.engineJarPath;
    }

    public void setEngineJarPath(String engineJarPath) {
        this.engineJarPath = engineJarPath;
    }

    public boolean isShowInMatlabEditor() {
        return this.showInMatlabEditor;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public void setShowInMatlabEditor(boolean openMatlabEditor) {
        this.showInMatlabEditor = openMatlabEditor;
    }

    public boolean isFollowLinks() {
        return this.followLinks;
    }

    public void setFollowLinks(boolean followLinks) {
        this.followLinks = followLinks;
    }

    public Object parseMatlabEngineVariable(String variableName) throws MatlabException {
        return MatlabEngineUtil.parseMatlabEngineVariable(this.engine, variableName);
    }

    public void statement(String statement) throws EolRuntimeException {
        try {
            this.engine.eval(statement);
        }
        catch (MatlabException e) {
            throw new EolRuntimeException(e.getMessage());
        }
    }

    public Object getWorkspaceVariable(String value) {
        try {
            return MatlabEngineUtil.parseMatlabEngineVariable(this.engine, value);
        }
        catch (MatlabException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Collection<ISimulinkModelElement> getChildren() throws MatlabException {
        return SimulinkUtil.findBlocks(this, this.engine, 1);
    }

    public Collection<ISimulinkModelElement> findBlocks(Integer depth) throws MatlabException {
        return SimulinkUtil.findBlocks(this, this.engine, depth);
    }

    public Collection<ISimulinkModelElement> findBlocks() throws MatlabException {
        return this.findBlocks(1);
    }
}

