/*
 * Decompiled with CFR 0.152.
 */
package org.h2.index;

import java.sql.SQLException;
import org.h2.constant.SysProperties;
import org.h2.engine.Session;
import org.h2.index.BaseIndex;
import org.h2.index.Cursor;
import org.h2.index.IndexType;
import org.h2.index.PageBtree;
import org.h2.index.PageBtreeCursor;
import org.h2.index.PageBtreeLeaf;
import org.h2.index.PageBtreeNode;
import org.h2.message.Message;
import org.h2.result.Row;
import org.h2.result.SearchRow;
import org.h2.store.Data;
import org.h2.store.PageStore;
import org.h2.store.Record;
import org.h2.table.Column;
import org.h2.table.IndexColumn;
import org.h2.table.TableData;
import org.h2.value.Value;
import org.h2.value.ValueLob;
import org.h2.value.ValueNull;

public class PageBtreeIndex
extends BaseIndex {
    private PageStore store;
    private TableData tableData;
    private final int headPos;
    private boolean needRebuild;
    private long rowCount;

    public PageBtreeIndex(TableData tableData, int n, String string, IndexColumn[] indexColumnArray, IndexType indexType, int n2, Session session) throws SQLException {
        this.initBaseIndex(tableData, n, string, indexColumnArray, indexType);
        this.tableData = tableData;
        if (!this.database.isPersistent() || n < 0) {
            this.headPos = 0;
            throw Message.throwInternalError("" + string);
        }
        this.store = this.database.getPageStore();
        if (n2 == -1) {
            this.needRebuild = true;
            this.headPos = n2 = this.store.allocatePage();
            this.store.addMeta(this, session, n2);
            PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this, n2, 0, this.store.createData());
            this.store.updateRecord(pageBtreeLeaf, true, pageBtreeLeaf.data);
        } else {
            this.headPos = n2;
            PageBtree pageBtree = this.getPage(n2);
            this.rowCount = pageBtree.getRowCount();
            if (this.rowCount == 0L && this.store.isRecoveryRunning()) {
                this.needRebuild = true;
            }
            if (!this.database.isReadOnly()) {
                this.store.updateRecord(pageBtree, false, null);
            }
        }
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("opened " + this.getName() + " rows:" + this.rowCount);
        }
    }

    public int getHeadPos() {
        return this.headPos;
    }

    public void add(Session session, Row row) throws SQLException {
        PageBtree pageBtree;
        int n;
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("add " + row.getPos());
        }
        SearchRow searchRow = this.getSearchRow(row);
        while ((n = (pageBtree = this.getPage(this.headPos)).addRowTry(searchRow)) != -1) {
            if (this.trace.isDebugEnabled()) {
                this.trace.debug("split " + n);
            }
            SearchRow searchRow2 = pageBtree.getRow(n - 1);
            PageBtree pageBtree2 = pageBtree;
            PageBtree pageBtree3 = pageBtree.split(n);
            int n2 = pageBtree.getPos();
            int n3 = this.store.allocatePage();
            pageBtree2.setPageId(n3);
            pageBtree2.setParentPageId(this.headPos);
            pageBtree3.setParentPageId(this.headPos);
            PageBtreeNode pageBtreeNode = new PageBtreeNode(this, n2, 0, this.store.createData());
            pageBtreeNode.init(pageBtree2, searchRow2, pageBtree3);
            this.store.updateRecord(pageBtree2, true, pageBtree2.data);
            this.store.updateRecord(pageBtree3, true, pageBtree3.data);
            this.store.updateRecord(pageBtreeNode, true, null);
            pageBtree = pageBtreeNode;
        }
        ++this.rowCount;
    }

    private SearchRow getSearchRow(Row row) {
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setPosAndVersion(row);
        for (int i = 0; i < this.columns.length; ++i) {
            int n = this.columns[i].getColumnId();
            searchRow.setValue(n, row.getValue(n));
        }
        return searchRow;
    }

    PageBtree getPage(int n) throws SQLException {
        PageBtree pageBtree;
        Record record = this.store.getRecord(n);
        if (record != null) {
            if (SysProperties.CHECK) {
                if (!(record instanceof PageBtree)) {
                    throw Message.throwInternalError("Wrong page: " + record + " " + this);
                }
                PageBtree pageBtree2 = (PageBtree)record;
                if (pageBtree2.index.headPos != this.headPos) {
                    throw Message.throwInternalError("Wrong index: " + pageBtree2.index + " " + this);
                }
            }
            return (PageBtree)record;
        }
        Data data = this.store.readPage(n);
        data.reset();
        int n2 = data.readInt();
        int n3 = data.readByte() & 0xFF;
        switch (n3 & 0xFFFFFFEF) {
            case 4: {
                pageBtree = new PageBtreeLeaf(this, n, n2, data);
                break;
            }
            case 5: {
                pageBtree = new PageBtreeNode(this, n, n2, data);
                break;
            }
            case 0: {
                PageBtreeLeaf pageBtreeLeaf = new PageBtreeLeaf(this, n, n2, data);
                return pageBtreeLeaf;
            }
            default: {
                throw Message.getSQLException(90030, "page=" + n + " type=" + n3);
            }
        }
        pageBtree.read();
        return pageBtree;
    }

    public boolean canGetFirstOrLast() {
        return true;
    }

    public Cursor findNext(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, true, searchRow2);
    }

    public Cursor find(Session session, SearchRow searchRow, SearchRow searchRow2) throws SQLException {
        return this.find(session, searchRow, false, searchRow2);
    }

    private Cursor find(Session session, SearchRow searchRow, boolean bl, SearchRow searchRow2) throws SQLException {
        if (SysProperties.CHECK && this.store == null) {
            throw Message.getSQLException(90007);
        }
        PageBtree pageBtree = this.getPage(this.headPos);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, searchRow2);
        pageBtree.find(pageBtreeCursor, searchRow, bl);
        return pageBtreeCursor;
    }

    public Cursor findFirstOrLast(Session session, boolean bl) throws SQLException {
        SearchRow searchRow;
        if (bl) {
            Cursor cursor = this.find(session, null, false, null);
            while (cursor.next()) {
                SearchRow searchRow2 = cursor.getSearchRow();
                Value value = searchRow2.getValue(this.columnIds[0]);
                if (value == ValueNull.INSTANCE) continue;
                return cursor;
            }
            return cursor;
        }
        PageBtree pageBtree = this.getPage(this.headPos);
        PageBtreeCursor pageBtreeCursor = new PageBtreeCursor(session, this, null);
        pageBtree.last(pageBtreeCursor);
        pageBtreeCursor.previous();
        while ((searchRow = pageBtreeCursor.getSearchRow()) != null) {
            Value value = searchRow.getValue(this.columnIds[0]);
            if (value != ValueNull.INSTANCE) {
                return pageBtreeCursor;
            }
            if (pageBtreeCursor.previous()) continue;
        }
        return pageBtreeCursor;
    }

    public double getCost(Session session, int[] nArray) {
        return 10L * this.getCostRangeIndex(nArray, this.tableData.getRowCount(session));
    }

    public boolean needRebuild() {
        return this.needRebuild;
    }

    public void remove(Session session, Row row) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove " + row.getPos());
        }
        if (this.tableData.getContainsLargeObject()) {
            for (int i = 0; i < row.getColumnCount(); ++i) {
                Value value = row.getValue(i);
                if (!value.isLinked()) continue;
                session.unlinkAtCommit((ValueLob)value);
            }
        }
        if (this.rowCount == 1L) {
            this.removeAllRows();
        } else {
            PageBtree pageBtree = this.getPage(this.headPos);
            pageBtree.remove(row);
            --this.rowCount;
        }
    }

    public void remove(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("remove");
        }
        this.removeAllRows();
        this.store.freePage(this.headPos, false, null);
        this.store.removeMeta(this, session);
    }

    public void truncate(Session session) throws SQLException {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("truncate");
        }
        this.removeAllRows();
        if (this.tableData.getContainsLargeObject()) {
            ValueLob.removeAllForTable(this.database, this.table.getId());
        }
        this.tableData.setRowCount(0L);
    }

    private void removeAllRows() throws SQLException {
        PageBtree pageBtree = this.getPage(this.headPos);
        pageBtree.freeChildren();
        pageBtree = new PageBtreeLeaf(this, this.headPos, 0, this.store.createData());
        this.store.removeRecord(this.headPos);
        this.store.updateRecord(pageBtree, true, null);
        this.rowCount = 0L;
    }

    public void checkRename() {
    }

    Row getRow(Session session, int n) throws SQLException {
        return this.tableData.getRow(session, n);
    }

    PageStore getPageStore() {
        return this.store;
    }

    public long getRowCountApproximation() {
        return this.tableData.getRowCountApproximation();
    }

    public long getRowCount(Session session) {
        return this.tableData.getRowCount(session);
    }

    public void close(Session session) {
        if (this.trace.isDebugEnabled()) {
            this.trace.debug("close");
        }
    }

    SearchRow readRow(Data data, int n, boolean bl) throws SQLException {
        data.setPos(n);
        int n2 = data.readInt();
        if (bl) {
            return this.tableData.getRow(null, n2);
        }
        SearchRow searchRow = this.table.getTemplateSimpleRow(this.columns.length == 1);
        searchRow.setPos(n2);
        for (Column column : this.columns) {
            int n3 = column.getColumnId();
            searchRow.setValue(n3, data.readValue());
        }
        return searchRow;
    }

    void writeRow(Data data, int n, SearchRow searchRow, boolean bl) throws SQLException {
        data.setPos(n);
        data.writeInt(searchRow.getPos());
        if (!bl) {
            for (Column column : this.columns) {
                int n2 = column.getColumnId();
                data.writeValue(searchRow.getValue(n2));
            }
        }
    }

    int getRowSize(Data data, SearchRow searchRow, boolean bl) throws SQLException {
        int n = 4;
        if (!bl) {
            for (Column column : this.columns) {
                Value value = searchRow.getValue(column.getColumnId());
                n += data.getValueLen(value);
            }
        }
        return n;
    }

    public boolean canFindNext() {
        return true;
    }
}

