/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.geo.impl;

import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ValueConstruct;
import com.google.gdata.data.geo.Box;
import com.google.gdata.data.geo.Namespaces;
import com.google.gdata.data.geo.Point;
import com.google.gdata.data.geo.impl.GeoRssPoint;

public class GeoRssBox
extends ValueConstruct
implements Box {
    static final String NAME = "box";
    private Point lowerLeft;
    private Point upperRight;

    public GeoRssBox() {
        this((Point)null, (Point)null);
    }

    public GeoRssBox(Double lowerLat, Double lowerLon, Double upperLat, Double upperLon) {
        this(new GeoRssPoint(lowerLat, lowerLon), new GeoRssPoint(upperLat, upperLon));
    }

    public GeoRssBox(Point lowerLeft, Point upperRight) {
        super(Namespaces.GEO_RSS_NAMESPACE, NAME, null);
        if (lowerLeft == null && upperRight == null) {
            this.setRequired(false);
        }
        this.setGeoLocation(lowerLeft, upperRight);
    }

    public GeoRssBox(Box box) {
        this(box == null ? null : box.getLowerLeft(), box == null ? null : box.getUpperRight());
    }

    public static ExtensionDescription getDefaultDescription(boolean repeatable) {
        ExtensionDescription desc = new ExtensionDescription();
        desc.setExtensionClass(GeoRssBox.class);
        desc.setNamespace(Namespaces.GEO_RSS_NAMESPACE);
        desc.setLocalName(NAME);
        desc.setRepeatable(repeatable);
        return desc;
    }

    public static ExtensionDescription getDefaultDescription() {
        return GeoRssBox.getDefaultDescription(true);
    }

    public Point getLowerLeft() {
        return this.lowerLeft;
    }

    public Point getUpperRight() {
        return this.upperRight;
    }

    public void setGeoLocation(Point lowerLeft, Point upperRight) {
        if (lowerLeft != null && upperRight != null) {
            if (lowerLeft.getLatitude() > upperRight.getLatitude()) {
                throw new IllegalArgumentException("'lowerLeft' must be below 'upperRight'.");
            }
        } else if (lowerLeft != null || upperRight != null) {
            throw new IllegalArgumentException("'lowerLeft' and 'upperRight' must either both be null or non-null.");
        }
        this.lowerLeft = lowerLeft;
        this.upperRight = upperRight;
        super.setValue(this.toString());
    }

    public String toString() {
        if (this.lowerLeft != null && this.upperRight != null) {
            return this.lowerLeft.getLatitude() + " " + this.lowerLeft.getLongitude() + " " + this.upperRight.getLatitude() + " " + this.upperRight.getLongitude();
        }
        return null;
    }

    public void setValue(String v) {
        Point lower = null;
        Point upper = null;
        if (v != null) {
            String[] values = (v = v.trim()).split(" ");
            if (values.length != 4) {
                throw this.createInvalidValueException();
            }
            lower = this.getPoint(values[0], values[1]);
            upper = this.getPoint(values[2], values[3]);
        }
        this.setGeoLocation(lower, upper);
    }

    private Point getPoint(String latStr, String lonStr) {
        try {
            Double lat = Double.valueOf(latStr);
            Double lon = Double.valueOf(lonStr);
            return new GeoRssPoint(lat, lon);
        }
        catch (NumberFormatException e) {
            throw this.createInvalidValueException();
        }
    }

    private IllegalArgumentException createInvalidValueException() {
        return new IllegalArgumentException("Format of a georss:box is \"latitude longitude latitude longitutde\", where the first pair is the lower left point, and the second pair is the upper right point.  All values must be doubles, separated by spaces.");
    }
}

