/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util;

import com.google.gdata.util.common.xml.XmlNamespace;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlBlob {
    protected String lang;
    protected String base;
    protected LinkedList<XmlNamespace> namespaces = new LinkedList();
    protected String blob;
    protected String fullText;

    public String getLang() {
        return this.lang;
    }

    public void setLang(String v) {
        this.lang = v;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String v) {
        this.base = v;
    }

    public List<XmlNamespace> getNamespaces() {
        return this.namespaces;
    }

    public boolean addNamespace(XmlNamespace namespace) {
        return this.namespaces.add(namespace);
    }

    public String getBlob() {
        return this.blob;
    }

    public void setBlob(String v) {
        this.blob = v;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String v) {
        this.fullText = v;
    }

    public static void startElement(XmlWriter w, XmlNamespace namespace, String elementName, XmlBlob xml, Collection<XmlWriter.Attribute> additionalAttrs, Collection<XmlNamespace> additionalNs) throws IOException {
        Collection<XmlNamespace> namespaces;
        Collection<XmlWriter.Attribute> attrs;
        if (xml != null) {
            int additionalNsSize;
            String lang = xml.getLang();
            String base = xml.getBase();
            if (lang != null || base != null) {
                attrs = new ArrayList<XmlWriter.Attribute>();
                if (additionalAttrs != null) {
                    attrs.addAll(additionalAttrs);
                }
                if (lang != null) {
                    attrs.add(new XmlWriter.Attribute("xml:lang", lang));
                }
                if (base != null) {
                    attrs.add(new XmlWriter.Attribute("xml:base", base));
                }
            } else {
                assert (lang == null && base == null);
                attrs = additionalAttrs;
            }
            List<XmlNamespace> blobNamespaces = xml.getNamespaces();
            int n = additionalNsSize = additionalNs == null ? 0 : additionalNs.size();
            if (blobNamespaces.size() == 0 && additionalNsSize == 0) {
                namespaces = null;
            } else {
                namespaces = new ArrayList<XmlNamespace>(additionalNsSize + blobNamespaces.size());
                for (XmlNamespace blobNs : blobNamespaces) {
                    namespaces.add(new XmlNamespace(blobNs.getAlias(), blobNs.getUri()));
                }
                if (additionalNs != null) {
                    namespaces.addAll(additionalNs);
                }
            }
        } else {
            assert (xml == null);
            attrs = additionalAttrs;
            namespaces = additionalNs;
        }
        w.startElement(namespace, elementName, attrs, namespaces);
    }

    public static void endElement(XmlWriter w, XmlNamespace namespace, String elementName, XmlBlob xml) throws IOException {
        if (xml != null && xml.getBlob() != null) {
            w.innerXml(xml.getBlob());
        }
        w.endElement(namespace, elementName);
    }
}

