/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.util.common.xml;

import com.google.gdata.util.common.base.StringUtil;
import com.google.gdata.util.common.xml.XmlNamespace;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlWriter {
    protected final Set<WriterFlags> flags;
    private static final String INDENTATION_UNIT = "\t";
    protected final Writer writer;
    private final Stack<Element> elementStack;
    private String defaultNamespace;
    protected String encoding;
    private String nextDefaultNamespace;
    private Boolean standalone;

    public XmlWriter(Writer w, Set<WriterFlags> f, String encoding, boolean standalone) throws IOException {
        this(w, f, encoding);
        this.standalone = standalone;
    }

    public XmlWriter(Writer w, Set<WriterFlags> f, String encoding) throws IOException {
        this.writer = w;
        this.flags = f != null ? f : EnumSet.noneOf(WriterFlags.class);
        this.encoding = encoding;
        this.elementStack = new Stack();
        Element rootElement = this.createElement(null, null, null);
        rootElement.openTagEnded = true;
        this.elementStack.push(rootElement);
    }

    public XmlWriter(Writer w) throws IOException {
        this(w, null, null);
    }

    public XmlWriter(Writer w, String encoding) throws IOException {
        this(w, EnumSet.of(WriterFlags.WRITE_HEADER), encoding);
    }

    @Deprecated
    public XmlWriter(Writer w, boolean includeHeader) throws IOException {
        this(w, EnumSet.of(WriterFlags.WRITE_HEADER), null);
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void setDefaultNamespace(XmlNamespace namespace) {
        if (!namespace.uri.equals(this.defaultNamespace)) {
            this.nextDefaultNamespace = namespace.uri;
        }
    }

    protected Element createElement(String nsAlias, String nsUri, String name) {
        return new Element(nsAlias, nsUri, name);
    }

    protected Element currentElement() {
        try {
            return this.elementStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    protected Element parentElement() {
        return (Element)this.elementStack.get(this.elementStack.size() - 1 - 1);
    }

    public void startElement(String name) throws IOException {
        this.startElement(null, name, null, null);
    }

    public void startElement(XmlNamespace namespace, String name, Collection<Attribute> attrs, Collection<? extends XmlNamespace> namespaceDecls) throws IOException {
        if (this.elementStack.size() == 1) {
            this.writeBeginOutput();
            if (this.shouldWriteHeaderAndFooter()) {
                this.writeHeader(this.encoding);
            }
        }
        this.endOpenTag();
        Element element = namespace != null ? this.createElement(namespace.alias, namespace.uri, name) : this.createElement(null, null, name);
        Element parentElement = this.currentElement();
        if (parentElement != null) {
            element.xmlLang = parentElement.xmlLang;
            element.unformattedChildren = parentElement.unformattedChildren;
            if (parentElement.repeatingCount != -1) {
                element.repeatingIndex = parentElement.repeatingCount++;
            }
        }
        this.elementStack.push(element);
        if (this.nextDefaultNamespace != null) {
            XmlNamespace defaultNs = new XmlNamespace(this.nextDefaultNamespace);
            this.defaultNamespace = this.nextDefaultNamespace;
            element.addNamespace(defaultNs);
            this.nextDefaultNamespace = null;
        }
        if (namespaceDecls != null) {
            for (XmlNamespace xmlNamespace : namespaceDecls) {
                this.ensureNamespace(xmlNamespace);
            }
        }
        if (namespace != null) {
            element.nsAlias = this.ensureNamespace(namespace);
        }
        this.writeOpenTagStart(element.nsAlias, name);
        for (XmlNamespace xmlNamespace : element.nsDecls) {
            if (xmlNamespace.alias != null && xmlNamespace.alias.length() > 0) {
                this.writeAttribute("xmlns", xmlNamespace.alias, xmlNamespace.uri);
                continue;
            }
            this.writeAttribute(null, "xmlns", xmlNamespace.uri);
        }
        if (attrs != null) {
            for (Attribute attribute : attrs) {
                if (attribute.name.equals("lang") && "xml".equals(attribute.nsAlias)) {
                    if (attribute.value.equals(element.xmlLang)) continue;
                    element.xmlLang = attribute.value;
                }
                this.writeAttribute(attribute.nsAlias, attribute.name, attribute.value);
            }
        }
        if (this.flags.contains((Object)WriterFlags.EXPAND_EMPTY)) {
            this.endOpenTag();
        }
    }

    protected boolean shouldWriteHeaderAndFooter() {
        return this.flags.contains((Object)WriterFlags.WRITE_HEADER) || this.encoding != null || this.standalone != null;
    }

    protected void endOpenTag() throws IOException {
        Element element = this.currentElement();
        if (!element.openTagEnded) {
            this.writeOpenTagEnd();
            element.openTagEnded = true;
        }
    }

    public void endElement(XmlNamespace namespace, String name) throws IOException {
        Element element = this.currentElement();
        assert (namespace == null || element.nsUri.equals(namespace.uri));
        assert (element.name.equals(name));
        this.endElement();
    }

    public void endElement() throws IOException {
        Element element = this.currentElement();
        this.writeCloseTag(element.nsAlias, element.name);
        this.defaultNamespace = element.enclosingDefaultNamespace;
        this.elementStack.pop();
        if (this.elementStack.size() == 1) {
            if (this.shouldWriteHeaderAndFooter()) {
                this.writeFooter();
            }
            this.writeEndOutput();
        }
    }

    public void simpleElement(String name, String value) throws IOException {
        this.simpleElement(null, name, null, value);
    }

    public void startRepeatingElement() throws IOException {
        Element currentElement = this.currentElement();
        if (currentElement.repeatingCount != -1) {
            throw new IllegalStateException("Existing repeating element is active");
        }
        currentElement.repeatingCount = 0;
    }

    public void endRepeatingElement() throws IOException {
        this.currentElement().repeatingCount = -1;
    }

    public void simpleElement(XmlNamespace namespace, String name, List<Attribute> attrs, String value) throws IOException {
        this.startElement(namespace, name, attrs, null);
        this.characters(value);
        this.endElement(namespace, name);
    }

    private String checkNamespace(String namespaceUri) {
        for (int i = this.elementStack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.elementStack.get(i);
            for (XmlNamespace ns : element.nsDecls) {
                if (ns.alias == null || !ns.uri.equals(namespaceUri)) continue;
                return ns.alias;
            }
        }
        return null;
    }

    private boolean isPrettyPrintingEnabled() {
        return this.flags.contains((Object)WriterFlags.PRETTY_PRINT) && !this.currentElement().unformattedChildren;
    }

    private int getIndentationLevel() {
        return this.elementStack.size() - 2;
    }

    private void writeNewline() throws IOException {
        this.writer.write("\n");
    }

    private void writeIndentation() throws IOException {
        this.writeUnitsOfIndentation(this.getIndentationLevel());
    }

    private void writeUnitsOfIndentation(int i) throws IOException {
        while (i > 0) {
            this.writer.write(INDENTATION_UNIT);
            --i;
        }
    }

    protected String ensureNamespace(XmlNamespace namespace) {
        if (namespace.uri.equals(this.defaultNamespace)) {
            return null;
        }
        String alias = this.checkNamespace(namespace.uri);
        if (alias == null) {
            Element current = this.currentElement();
            namespace = this.ensureUniqueNamespaceAlias(current, namespace);
            current.addNamespace(namespace);
            alias = namespace.alias;
        }
        return alias;
    }

    private XmlNamespace ensureUniqueNamespaceAlias(Element element, XmlNamespace namespace) {
        boolean unique;
        int serial = 0;
        block0: do {
            unique = true;
            for (XmlNamespace ns : element.nsDecls) {
                if (!namespace.alias.equals(ns.alias)) continue;
                unique = false;
                namespace = new XmlNamespace("ns" + String.valueOf(++serial), namespace.uri);
                continue block0;
            }
        } while (!unique);
        return namespace;
    }

    protected String getNamespaceUri(String nsAlias) {
        if (nsAlias == null) {
            return this.defaultNamespace;
        }
        for (int i = this.elementStack.size() - 1; i >= 0; --i) {
            Element element = (Element)this.elementStack.get(i);
            for (XmlNamespace ns : element.nsDecls) {
                if (!ns.getAlias().equals(nsAlias)) continue;
                return ns.getUri();
            }
        }
        return null;
    }

    protected void writeBeginOutput() throws IOException {
    }

    protected void writeEndOutput() throws IOException {
    }

    protected void writeHeader(String enc) throws IOException {
        this.writer.write("<?xml");
        this.writeAttribute("version", "1.0");
        if (enc != null) {
            this.writeAttribute("encoding", enc);
        }
        if (this.standalone != null) {
            this.writeAttribute("standalone", this.standalone != false ? "yes" : "no");
        }
        this.writer.write("?>");
    }

    protected void writeFooter() throws IOException {
    }

    protected void writeQualifiedName(String nsAlias, String name) throws IOException {
        if (nsAlias != null && nsAlias.length() > 0) {
            this.writer.write(nsAlias);
            this.writer.write(58);
        }
        this.writer.write(name);
    }

    protected void writeOpenTagStart(String nsAlias, String name) throws IOException {
        if (this.isPrettyPrintingEnabled()) {
            if (this.getIndentationLevel() > 0 || this.flags.contains((Object)WriterFlags.WRITE_HEADER)) {
                this.writeNewline();
            }
            this.writeIndentation();
        }
        this.writer.write(60);
        this.writeQualifiedName(nsAlias, name);
    }

    protected void writeOpenTagEnd() throws IOException {
        this.writer.write(62);
    }

    protected void writeCloseTag(String nsAlias, String name) throws IOException {
        Element element = this.currentElement();
        if (element.openTagEnded) {
            if (this.isPrettyPrintingEnabled()) {
                this.writeNewline();
                this.writeIndentation();
            }
            this.writer.write("</");
            this.writeQualifiedName(nsAlias, name);
            this.writer.write(">");
        } else {
            this.writer.write("/>");
        }
    }

    protected void writeAttribute(String name, String value) throws IOException {
        this.writeAttribute(null, name, value);
    }

    protected void writeAttribute(String nsAlias, String name, String value) throws IOException {
        this.writer.write(" ");
        this.writeQualifiedName(nsAlias, name);
        this.writer.write(61);
        this.writer.write(39);
        if (value != null) {
            this.writer.write(StringUtil.xmlEscape(value));
        }
        this.writer.write(39);
    }

    public void characters(String s) throws IOException {
        this.characters(s, false);
    }

    public void characters(String s, boolean useCData) throws IOException {
        if (s == null) {
            return;
        }
        this.endOpenTag();
        this.currentElement().unformattedChildren = true;
        String escaped = useCData ? "<![CDATA[" + StringUtil.xmlCDataEscape(s) + "]]>" : StringUtil.xmlContentEscape(s);
        this.writer.write(escaped);
    }

    public void innerXml(String xml) throws IOException {
        if (xml == null) {
            return;
        }
        this.writeUnescaped(xml);
    }

    public void writeUnescaped(String s) throws IOException {
        this.endOpenTag();
        this.currentElement().unformattedChildren = true;
        this.writer.write(s);
    }

    protected static class Element {
        public static final int NOT_REPEATING = -1;
        public List<XmlNamespace> nsDecls = new ArrayList<XmlNamespace>();
        public String nsAlias;
        public final String nsUri;
        public final String name;
        public String xmlLang;
        public boolean hasAttributes;
        public boolean unformattedChildren;
        public int repeatingCount = -1;
        public int repeatingIndex = -1;
        public String enclosingDefaultNamespace;
        public boolean openTagEnded;

        protected Element(String nsAlias, String nsUri, String name) {
            this.nsAlias = nsAlias;
            this.nsUri = nsUri;
            this.name = name;
        }

        public void addNamespace(XmlNamespace ns) {
            if (!this.nsDecls.contains(ns)) {
                this.nsDecls.add(ns);
            }
        }
    }

    public static final class Attribute {
        public final String nsAlias;
        public final String name;
        public final String value;

        public Attribute(String name, String value) {
            this(null, name, value);
        }

        public Attribute(String nsAlias, String name, String value) {
            int separator;
            if (nsAlias == null && (separator = name.indexOf(58)) > 0) {
                nsAlias = name.substring(0, separator);
                name = name.substring(separator + 1);
            }
            this.nsAlias = nsAlias;
            this.name = name;
            this.value = value;
        }

        public Attribute(String name, boolean value) {
            this(null, name, value ? "true" : "false");
        }
    }

    @Deprecated
    public static final class Namespace
    extends XmlNamespace {
        public Namespace(String alias, String uri) {
            super(alias, uri);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WriterFlags {
        WRITE_HEADER,
        EXPAND_EMPTY,
        PRETTY_PRINT;

    }
}

