/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tooling.simplemap.migrate.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.IStructuredSelection;

public class WizardUtil {
    public static String getDefaultFileName(IStructuredSelection selection, String defaultName, String extension) {
        Object selected;
        if (selection != null && !selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IFile) {
            return WizardUtil.getDefaultFileName((IFile)selected, extension);
        }
        return String.valueOf(defaultName) + '.' + extension;
    }

    public static String getDefaultFileName(IFile file, String extension) {
        String fileNameBase = WizardUtil.getFileBaseName(file);
        String modelFilename = String.valueOf(fileNameBase) + '.' + extension;
        int i = 1;
        while (file.getParent().findMember(modelFilename) != null) {
            modelFilename = String.valueOf(fileNameBase) + i + '.' + extension;
            ++i;
        }
        return modelFilename;
    }

    public static IFile findExistingFile(IStructuredSelection selection, String fileExt) {
        if (selection == null || selection.isEmpty() || !(selection.getFirstElement() instanceof IFile)) {
            return null;
        }
        IFile selected = (IFile)selection.getFirstElement();
        String fileNameBase = WizardUtil.getFileBaseName(selected);
        IResource candidate = selected.getParent().findMember(String.valueOf(fileNameBase) + '.' + fileExt);
        if (candidate != null && candidate.getType() == 1 && candidate.exists()) {
            return (IFile)candidate;
        }
        return null;
    }

    private static String getFileBaseName(IFile file) {
        String fileNameBase = file.getName();
        if (file.getFileExtension() != null) {
            fileNameBase = fileNameBase.substring(0, fileNameBase.length() - (file.getFileExtension().length() + 1));
        }
        return fileNameBase;
    }
}

