/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository.io;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.internal.p2.core.helpers.OrderedProperties;
import org.eclipse.equinox.internal.p2.metadata.ArtifactKey;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.metadata.repository.io.XMLConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLParser;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.ExpressionParseException;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.metadata.expression.IFilterExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.repository.IRepositoryReference;
import org.eclipse.equinox.p2.repository.spi.RepositoryReference;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;

public abstract class MetadataParser
extends XMLParser
implements XMLConstants {
    static final ILicense[] NO_LICENSES = new ILicense[0];

    public MetadataParser(String bundleId) {
        super(bundleId);
    }

    public MetadataParser(SAXParserFactory factory, String bundleId) {
        super(factory, bundleId);
    }

    static IMatchExpression<IInstallableUnit> createMatchExpression(String match, String matchParams) {
        Object[] params;
        IExpressionFactory factory = ExpressionUtil.getFactory();
        IExpression expr = ExpressionUtil.parse((String)match);
        if (matchParams == null) {
            params = new Object[]{};
        } else {
            IExpression[] arrayExpr = ExpressionUtil.getOperands((IExpression)ExpressionUtil.parse((String)matchParams));
            params = new Object[arrayExpr.length];
            int idx = 0;
            while (idx < arrayExpr.length) {
                params[idx] = arrayExpr[idx].evaluate(null);
                ++idx;
            }
        }
        return factory.matchExpression(expr, params);
    }

    protected abstract class AbstractMetadataHandler
    extends XMLParser.AbstractHandler {
        public AbstractMetadataHandler(ContentHandler parentHandler, String elementHandled) {
            super((XMLParser)MetadataParser.this, parentHandler, elementHandled);
        }

        int getOptionalSize(Attributes attributes, int dflt) {
            String sizeStr = this.parseOptionalAttribute(attributes, "size");
            return sizeStr != null ? Integer.parseInt(sizeStr) : dflt;
        }
    }

    protected class ApplicabilityScopeHandler
    extends XMLParser.AbstractHandler {
        private RequirementsHandler children;
        private final List<IRequirement[]> scopes;

        public ApplicabilityScopeHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IRequirement[]> scopes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "scope");
            this.scopes = scopes;
        }

        public void startElement(String name, Attributes attributes) {
            if ("requires".equals(name)) {
                this.children = new RequirementsHandler(this, attributes);
            } else {
                MetadataParser.this.duplicateElement(this, name, attributes);
            }
        }

        protected void finished() {
            if (this.children != null) {
                this.scopes.add(this.children.getRequirements());
            }
        }
    }

    protected class ApplicabilityScopesHandler
    extends AbstractMetadataHandler {
        private final List<IRequirement[]> scopes;

        public ApplicabilityScopesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "patchScope");
            this.scopes = new ArrayList<IRequirement[]>(this.getOptionalSize(attributes, 4));
        }

        public void startElement(String name, Attributes attributes) {
            if ("scope".equals(name)) {
                new ApplicabilityScopeHandler(this, attributes, this.scopes);
            } else {
                MetadataParser.this.duplicateElement(this, name, attributes);
            }
        }

        public IRequirement[][] getScope() {
            return (IRequirement[][])this.scopes.toArray((T[])new IRequirement[this.scopes.size()][]);
        }
    }

    protected class ArtifactHandler
    extends XMLParser.AbstractHandler {
        private final String[] required;

        public ArtifactHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IArtifactKey> artifacts) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "artifact");
            this.required = new String[]{"classifier", "id", "version"};
            String[] values = this.parseRequiredAttributes(attributes, this.required);
            Version version = MetadataParser.this.checkVersion("artifact", "version", values[2]);
            artifacts.add((IArtifactKey)new ArtifactKey(values[0], values[1], version));
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class ArtifactsHandler
    extends XMLParser.AbstractHandler {
        private final List<IArtifactKey> artifacts;

        public ArtifactsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "artifacts");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.artifacts = size != null ? new ArrayList<IArtifactKey>(Integer.parseInt(size)) : new ArrayList(4);
        }

        public IArtifactKey[] getArtifactKeys() {
            return this.artifacts.toArray(new IArtifactKey[this.artifacts.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("artifact")) {
                new ArtifactHandler(this, attributes, this.artifacts);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class CopyrightHandler
    extends XMLParser.TextHandler {
        URI location;
        private ICopyright copyright;

        public CopyrightHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, parentHandler, "copyright");
            this.location = null;
            this.location = this.parseURIAttribute(attributes, false);
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML()) {
                this.copyright = MetadataFactory.createCopyright((URI)this.location, (String)this.getText());
            }
        }

        public ICopyright getCopyright() {
            return this.copyright;
        }
    }

    protected class HostRequiredCapabilitiesHandler
    extends AbstractMetadataHandler {
        private final List<IRequirement> requiredCapabilities;

        public HostRequiredCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "hostRequirements");
            this.requiredCapabilities = new ArrayList<IRequirement>(this.getOptionalSize(attributes, 4));
        }

        public IRequirement[] getHostRequiredCapabilities() {
            return this.requiredCapabilities.toArray(new IRequirement[this.requiredCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("required")) {
                new RequirementHandler(this, attributes, this.requiredCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class InstallableUnitHandler
    extends XMLParser.AbstractHandler {
        MetadataFactory.InstallableUnitDescription currentUnit;
        private XMLParser.PropertiesHandler propertiesHandler;
        private ProvidedCapabilitiesHandler providedCapabilitiesHandler;
        private RequirementsHandler requiredCapabilitiesHandler;
        private HostRequiredCapabilitiesHandler hostRequiredCapabilitiesHandler;
        private MetaRequiredCapabilitiesHandler metaRequiredCapabilitiesHandler;
        private XMLParser.TextHandler filterHandler;
        private ArtifactsHandler artifactsHandler;
        private TouchpointTypeHandler touchpointTypeHandler;
        private TouchpointDataHandler touchpointDataHandler;
        private UpdateDescriptorHandler updateDescriptorHandler;
        private LicensesHandler licensesHandler;
        private CopyrightHandler copyrightHandler;
        private RequirementsChangeHandler requirementChangesHandler;
        private ApplicabilityScopesHandler applicabilityScopeHandler;
        private LifeCycleHandler lifeCycleHandler;
        private String id;
        private Version version;
        private boolean singleton;
        private List<MetadataFactory.InstallableUnitDescription> units;

        public InstallableUnitHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<MetadataFactory.InstallableUnitDescription> units) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "unit");
            this.currentUnit = null;
            this.propertiesHandler = null;
            this.providedCapabilitiesHandler = null;
            this.requiredCapabilitiesHandler = null;
            this.hostRequiredCapabilitiesHandler = null;
            this.metaRequiredCapabilitiesHandler = null;
            this.filterHandler = null;
            this.artifactsHandler = null;
            this.touchpointTypeHandler = null;
            this.touchpointDataHandler = null;
            this.updateDescriptorHandler = null;
            this.licensesHandler = null;
            this.copyrightHandler = null;
            this.requirementChangesHandler = null;
            this.applicabilityScopeHandler = null;
            String[] values = this.parseAttributes(attributes, REQUIRED_IU_ATTRIBUTES, OPTIONAL_IU_ATTRIBUTES);
            this.units = units;
            if (values[0] == null) {
                return;
            }
            this.id = values[0];
            this.version = MetadataParser.this.checkVersion("unit", "version", values[1]);
            this.singleton = MetadataParser.this.checkBoolean("unit", "singleton", values[2], true);
        }

        public IInstallableUnit getInstallableUnit() {
            return MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)this.currentUnit);
        }

        public void startElement(String name, Attributes attributes) {
            MetadataParser.this.checkCancel();
            if ("properties".equals(name)) {
                if (this.propertiesHandler == null) {
                    this.propertiesHandler = new XMLParser.PropertiesHandler((XMLParser)MetadataParser.this, (ContentHandler)((Object)this), attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("provides".equals(name)) {
                if (this.providedCapabilitiesHandler == null) {
                    this.providedCapabilitiesHandler = new ProvidedCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("requires".equals(name)) {
                if (this.requiredCapabilitiesHandler == null) {
                    this.requiredCapabilitiesHandler = new RequirementsHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("hostRequirements".equals(name)) {
                if (this.hostRequiredCapabilitiesHandler == null) {
                    this.hostRequiredCapabilitiesHandler = new HostRequiredCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("metaRequirements".equals(name)) {
                if (this.metaRequiredCapabilitiesHandler == null) {
                    this.metaRequiredCapabilitiesHandler = new MetaRequiredCapabilitiesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("filter".equals(name)) {
                if (this.filterHandler == null) {
                    this.filterHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "filter", attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("artifacts".equals(name)) {
                if (this.artifactsHandler == null) {
                    this.artifactsHandler = new ArtifactsHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("touchpoint".equals(name)) {
                if (this.touchpointTypeHandler == null) {
                    this.touchpointTypeHandler = new TouchpointTypeHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("touchpointData".equals(name)) {
                if (this.touchpointDataHandler == null) {
                    this.touchpointDataHandler = new TouchpointDataHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("update".equals(name)) {
                if (this.updateDescriptorHandler == null) {
                    this.updateDescriptorHandler = new UpdateDescriptorHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("licenses".equals(name)) {
                if (this.licensesHandler == null) {
                    this.licensesHandler = new LicensesHandler((ContentHandler)((Object)this), attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("changes".equals(name)) {
                if (this.requirementChangesHandler == null) {
                    this.requirementChangesHandler = new RequirementsChangeHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("patchScope".equals(name)) {
                if (this.applicabilityScopeHandler == null) {
                    this.applicabilityScopeHandler = new ApplicabilityScopesHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("lifeCycle".equals(name)) {
                if (this.lifeCycleHandler == null) {
                    this.lifeCycleHandler = new LifeCycleHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else if ("copyright".equals(name)) {
                if (this.copyrightHandler == null) {
                    this.copyrightHandler = new CopyrightHandler(this, attributes);
                } else {
                    MetadataParser.this.duplicateElement(this, name, attributes);
                }
            } else {
                this.invalidElement(name, attributes);
            }
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML()) {
                ITouchpointData[] touchpointData;
                if (this.requirementChangesHandler != null) {
                    this.currentUnit = new MetadataFactory.InstallableUnitPatchDescription();
                    ((MetadataFactory.InstallableUnitPatchDescription)this.currentUnit).setRequirementChanges(this.requirementChangesHandler.getRequirementChanges().toArray(new IRequirementChange[this.requirementChangesHandler.getRequirementChanges().size()]));
                    if (this.applicabilityScopeHandler != null) {
                        ((MetadataFactory.InstallableUnitPatchDescription)this.currentUnit).setApplicabilityScope(this.applicabilityScopeHandler.getScope());
                    }
                    if (this.lifeCycleHandler != null) {
                        ((MetadataFactory.InstallableUnitPatchDescription)this.currentUnit).setLifeCycle(this.lifeCycleHandler.getLifeCycleRequirement());
                    }
                } else if (this.hostRequiredCapabilitiesHandler == null || this.hostRequiredCapabilitiesHandler.getHostRequiredCapabilities().length == 0) {
                    this.currentUnit = new MetadataFactory.InstallableUnitDescription();
                } else {
                    this.currentUnit = new MetadataFactory.InstallableUnitFragmentDescription();
                    ((MetadataFactory.InstallableUnitFragmentDescription)this.currentUnit).setHost(this.hostRequiredCapabilitiesHandler.getHostRequiredCapabilities());
                }
                this.currentUnit.setId(this.id);
                this.currentUnit.setVersion(this.version);
                this.currentUnit.setSingleton(this.singleton);
                OrderedProperties properties = this.propertiesHandler == null ? new OrderedProperties(0) : this.propertiesHandler.getProperties();
                String updateFrom = null;
                VersionRange updateRange = null;
                for (Map.Entry e : properties.entrySet()) {
                    String key = (String)e.getKey();
                    String value = (String)e.getValue();
                    if (key.equals("equinox.p2.update.from")) {
                        updateFrom = value;
                        continue;
                    }
                    if (key.equals("equinox.p2.update.range")) {
                        updateRange = VersionRange.create((String)value);
                        continue;
                    }
                    this.currentUnit.setProperty(key, value);
                }
                if (updateFrom != null && updateRange != null) {
                    this.currentUnit.setUpdateDescriptor(MetadataFactory.createUpdateDescriptor(updateFrom, updateRange, (int)0, null));
                }
                if (this.licensesHandler != null) {
                    this.currentUnit.setLicenses(this.licensesHandler.getLicenses());
                }
                if (this.copyrightHandler != null) {
                    ICopyright copyright = this.copyrightHandler.getCopyright();
                    this.currentUnit.setCopyright(copyright);
                }
                IProvidedCapability[] providedCapabilities = this.providedCapabilitiesHandler == null ? new IProvidedCapability[]{} : this.providedCapabilitiesHandler.getProvidedCapabilities();
                this.currentUnit.setCapabilities(providedCapabilities);
                IRequirement[] requiredCapabilities = this.requiredCapabilitiesHandler == null ? new IRequirement[]{} : this.requiredCapabilitiesHandler.getRequirements();
                this.currentUnit.setRequirements(requiredCapabilities);
                IRequirement[] metaRequiredCapabilities = this.metaRequiredCapabilitiesHandler == null ? new IRequirement[]{} : this.metaRequiredCapabilitiesHandler.getMetaRequiredCapabilities();
                this.currentUnit.setMetaRequirements(metaRequiredCapabilities);
                if (this.filterHandler != null) {
                    this.currentUnit.setFilter(this.filterHandler.getText());
                }
                IArtifactKey[] artifacts = this.artifactsHandler == null ? new IArtifactKey[]{} : this.artifactsHandler.getArtifactKeys();
                this.currentUnit.setArtifacts(artifacts);
                if (this.touchpointTypeHandler != null) {
                    this.currentUnit.setTouchpointType(this.touchpointTypeHandler.getTouchpointType());
                }
                ITouchpointData[] iTouchpointDataArray = touchpointData = this.touchpointDataHandler == null ? new ITouchpointData[]{} : this.touchpointDataHandler.getTouchpointData();
                int n = touchpointData.length;
                int n2 = 0;
                while (n2 < n) {
                    ITouchpointData touchpointData1 = iTouchpointDataArray[n2];
                    this.currentUnit.addTouchpointData(touchpointData1);
                    ++n2;
                }
                if (this.updateDescriptorHandler != null) {
                    this.currentUnit.setUpdateDescriptor(this.updateDescriptorHandler.getUpdateDescriptor());
                }
                this.units.add(this.currentUnit);
            }
        }
    }

    protected class InstallableUnitsHandler
    extends AbstractMetadataHandler {
        private final ArrayList<MetadataFactory.InstallableUnitDescription> units;

        public InstallableUnitsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "units");
            this.units = new ArrayList(this.getOptionalSize(attributes, 4));
        }

        public IInstallableUnit[] getUnits() {
            int size = this.units.size();
            IInstallableUnit[] result = new IInstallableUnit[size];
            int i = 0;
            for (MetadataFactory.InstallableUnitDescription desc : this.units) {
                result[i++] = MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)desc);
            }
            return result;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("unit")) {
                new InstallableUnitHandler(this, attributes, this.units);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class LicenseHandler
    extends XMLParser.TextHandler {
        URI location;
        private final List<ILicense> licenses;

        public LicenseHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<ILicense> licenses) {
            super((XMLParser)MetadataParser.this, parentHandler, "license");
            this.location = null;
            this.location = this.parseURIAttribute(attributes, false);
            this.licenses = licenses;
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML()) {
                this.licenses.add(MetadataFactory.createLicense((URI)this.location, (String)this.getText()));
            }
        }
    }

    protected class LicensesHandler
    extends XMLParser.AbstractHandler {
        private final List<ILicense> licenses;

        public LicensesHandler(ContentHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, parentHandler, "licenses");
            String size = this.parseOptionalAttribute(attributes, "size");
            this.licenses = size != null ? new ArrayList<ILicense>(Integer.parseInt(size)) : new ArrayList(2);
        }

        public ILicense[] getLicenses() {
            if (this.licenses.size() == 0) {
                return NO_LICENSES;
            }
            return this.licenses.toArray(new ILicense[this.licenses.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("license")) {
                new LicenseHandler(this, attributes, this.licenses);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class LifeCycleHandler
    extends XMLParser.AbstractHandler {
        private final List<IRequirement> lifeCycleRequirement;

        public LifeCycleHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "lifeCycle");
            this.lifeCycleRequirement = new ArrayList<IRequirement>(1);
        }

        public IRequirement getLifeCycleRequirement() {
            if (this.lifeCycleRequirement.size() == 0) {
                return null;
            }
            return this.lifeCycleRequirement.get(0);
        }

        public void startElement(String name, Attributes attributes) {
            if ("required".equals(name)) {
                new RequirementHandler(this, attributes, this.lifeCycleRequirement);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class MetaRequiredCapabilitiesHandler
    extends AbstractMetadataHandler {
        private final List<IRequirement> requiredCapabilities;

        public MetaRequiredCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "metaRequirements");
            this.requiredCapabilities = new ArrayList<IRequirement>(this.getOptionalSize(attributes, 4));
        }

        public IRequirement[] getMetaRequiredCapabilities() {
            return this.requiredCapabilities.toArray(new IRequirement[this.requiredCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("required")) {
                new RequirementHandler(this, attributes, this.requiredCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class ProvidedCapabilitiesHandler
    extends AbstractMetadataHandler {
        private final List<IProvidedCapability> providedCapabilities;

        public ProvidedCapabilitiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "provides");
            this.providedCapabilities = new ArrayList<IProvidedCapability>(this.getOptionalSize(attributes, 4));
        }

        public IProvidedCapability[] getProvidedCapabilities() {
            return this.providedCapabilities.toArray(new IProvidedCapability[this.providedCapabilities.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("provided")) {
                new ProvidedCapabilityHandler(this, attributes, this.providedCapabilities);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class ProvidedCapabilityHandler
    extends XMLParser.AbstractHandler {
        private final String namespace;
        private final String name;
        private final Version version;
        private ProvidedCapabilityPropertiesHandler propertiesHandler;
        private final List<IProvidedCapability> capabilities;

        public ProvidedCapabilityHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IProvidedCapability> capabilities) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "provided");
            this.capabilities = capabilities;
            String[] values = this.parseRequiredAttributes(attributes, REQUIRED_PROVIDED_CAPABILITY_ATTRIBUTES);
            this.namespace = values[0];
            this.name = values[1];
            this.version = MetadataParser.this.checkVersion("provided", "version", values[2]);
        }

        public void startElement(String elem, Attributes attributes) {
            switch (elem) {
                case "properties": {
                    this.propertiesHandler = new ProvidedCapabilityPropertiesHandler(this, attributes);
                    break;
                }
                default: {
                    this.invalidElement(elem, attributes);
                }
            }
        }

        protected void finished() {
            Map<Object, Object> properties = this.propertiesHandler != null ? this.propertiesHandler.getProperties() : new HashMap();
            properties.put(this.namespace, this.name);
            properties.put("version", this.version);
            IProvidedCapability cap = MetadataFactory.createProvidedCapability((String)this.namespace, properties);
            this.capabilities.add(cap);
        }
    }

    protected class ProvidedCapabilityPropertiesHandler
    extends AbstractMetadataHandler {
        private final Map<String, Object> properties;

        public ProvidedCapabilityPropertiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "properties");
            this.properties = new HashMap<String, Object>(this.getOptionalSize(attributes, 2));
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void startElement(String elem, Attributes attributes) {
            switch (elem) {
                case "property": {
                    new ProvidedCapabilityPropertyHandler(this, attributes, this.properties);
                    break;
                }
                default: {
                    this.invalidElement(elem, attributes);
                }
            }
        }
    }

    protected class ProvidedCapabilityPropertyHandler
    extends AbstractMetadataHandler {
        public ProvidedCapabilityPropertyHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Map<String, Object> properties) {
            String type;
            super((ContentHandler)parentHandler, "property");
            String[] values = this.parseAttributes(attributes, PROPERTY_ATTRIBUTES, PROPERTY_OPTIONAL_ATTRIBUTES);
            String name = values[0];
            String value = values[1];
            String string = type = values[2] == null ? PROPERTY_TYPE_STRING : values[2];
            if (type.startsWith(PROPERTY_TYPE_LIST)) {
                properties.put(name, this.parseList(type, value));
            } else {
                properties.put(name, this.parseScalar(type, value));
            }
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }

        private List<Object> parseList(String type, String value) {
            String elType = type.length() > PROPERTY_TYPE_LIST.length() ? type.substring(PROPERTY_TYPE_LIST.length() + 1, type.length() - 1) : PROPERTY_TYPE_STRING;
            return Arrays.stream(value.split("\\s*,\\s*")).map(val -> this.parseScalar(elType, (String)val)).collect(Collectors.toList());
        }

        private Object parseScalar(String type, String value) {
            if (PROPERTY_TYPE_STRING.equals(type)) {
                return value;
            }
            if (PROPERTY_TYPE_INTEGER.equals(type)) {
                return Integer.parseInt(value);
            }
            if (PROPERTY_TYPE_LONG.equals(type)) {
                return Long.parseLong(value);
            }
            if (PROPERTY_TYPE_FLOAT.equals(type)) {
                return Float.valueOf(Float.parseFloat(value));
            }
            if (PROPERTY_TYPE_DOUBLE.equals(type)) {
                return Double.parseDouble(value);
            }
            if (PROPERTY_TYPE_BYTE.equals(type)) {
                return Byte.parseByte(value);
            }
            if (PROPERTY_TYPE_SHORT.equals(type)) {
                return Short.parseShort(value);
            }
            if (PROPERTY_TYPE_CHARACTER.equals(type)) {
                return Character.valueOf(value.charAt(0));
            }
            if (PROPERTY_TYPE_BOOLEAN.equals(type)) {
                return Boolean.parseBoolean(value);
            }
            if (PROPERTY_TYPE_VERSION.equals(type)) {
                return Version.create((String)value);
            }
            return value;
        }
    }

    protected class RepositoryReferenceHandler
    extends XMLParser.AbstractHandler {
        private final String[] required;

        public RepositoryReferenceHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Set<IRepositoryReference> references) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "repository");
            this.required = new String[]{"type", "options"};
            String[] values = this.parseRequiredAttributes(attributes, this.required);
            String name = this.parseOptionalAttribute(attributes, "name");
            int type = MetadataParser.this.checkInteger(this.elementHandled, "type", values[0]);
            int options = MetadataParser.this.checkInteger(this.elementHandled, "options", values[1]);
            URI location = this.parseURIAttribute(attributes, true);
            if (location != null) {
                references.add((IRepositoryReference)new RepositoryReference(location, name, type, options));
            }
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class RepositoryReferencesHandler
    extends AbstractMetadataHandler {
        private final HashSet<IRepositoryReference> references;

        public RepositoryReferencesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "references");
            this.references = new HashSet(this.getOptionalSize(attributes, 4));
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("repository")) {
                new RepositoryReferenceHandler(this, attributes, this.references);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        public IRepositoryReference[] getReferences() {
            return this.references.toArray(new IRepositoryReference[this.references.size()]);
        }
    }

    protected class RequirementChangeEltHandler
    extends XMLParser.AbstractHandler {
        private final List<IRequirement> requirement;

        public RequirementChangeEltHandler(XMLParser.AbstractHandler parentHandler, String parentId, Attributes attributes, List<IRequirement> from) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, parentId);
            this.requirement = from;
        }

        public void startElement(String name, Attributes attributes) {
            if ("required".equals(name)) {
                new RequirementHandler(this, attributes, this.requirement);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class RequirementChangeHandler
    extends XMLParser.AbstractHandler {
        private final List<IRequirement> from;
        private final List<IRequirement> to;
        private final List<IRequirementChange> requirementChanges;

        public RequirementChangeHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IRequirementChange> requirementChanges) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "change");
            this.from = new ArrayList<IRequirement>(1);
            this.to = new ArrayList<IRequirement>(1);
            this.requirementChanges = requirementChanges;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("from")) {
                new RequirementChangeEltHandler(this, "from", attributes, this.from);
                return;
            }
            if (name.equals("to")) {
                new RequirementChangeEltHandler(this, "to", attributes, this.to);
                return;
            }
            this.invalidElement(name, attributes);
        }

        protected void finished() {
            this.requirementChanges.add(MetadataFactory.createRequirementChange((IRequirement)(this.from.size() == 0 ? null : this.from.get(0)), this.to.size() == 0 ? null : this.to.get(0)));
        }
    }

    protected class RequirementHandler
    extends XMLParser.AbstractHandler {
        private final List<IRequirement> capabilities;
        private String match;
        private String matchParams;
        private String namespace;
        private String name;
        private VersionRange range;
        private int min;
        private int max;
        private boolean greedy;
        private XMLParser.TextHandler filterHandler;
        private XMLParser.TextHandler descriptionHandler;

        public RequirementHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IRequirement> capabilities) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "required");
            this.filterHandler = null;
            this.descriptionHandler = null;
            this.capabilities = capabilities;
            if (attributes.getIndex("namespace") >= 0) {
                String[] values = this.parseAttributes(attributes, REQIURED_CAPABILITY_ATTRIBUTES, REQUIRED_CAPABILITY_OPTIONAL_ATTRIBUTES);
                this.namespace = values[0];
                this.name = values[1];
                this.range = MetadataParser.this.checkVersionRange("required", "range", values[2]);
                boolean isOptional = MetadataParser.this.checkBoolean("required", "optional", values[3], false);
                this.min = isOptional ? 0 : 1;
                boolean isMultiple = MetadataParser.this.checkBoolean("required", "multiple", values[4], false);
                this.max = isMultiple ? Integer.MAX_VALUE : 1;
                this.greedy = MetadataParser.this.checkBoolean("required", "greedy", values[5], true);
            } else {
                String[] values = this.parseAttributes(attributes, REQUIRED_IU_MATCH_ATTRIBUTES, REQUIRED_IU_MATCH_OPTIONAL_ATTRIBUTES);
                this.match = values[0];
                this.matchParams = values[1];
                this.min = values[2] == null ? 1 : MetadataParser.this.checkInteger("required", "min", values[2]);
                this.max = values[3] == null ? 1 : MetadataParser.this.checkInteger("required", "max", values[3]);
                this.greedy = MetadataParser.this.checkBoolean("required", "greedy", values[4], true);
            }
        }

        public void startElement(String elem, Attributes attributes) {
            switch (elem) {
                case "filter": {
                    this.filterHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "filter", attributes);
                    break;
                }
                case "description": {
                    this.descriptionHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "description", attributes);
                    break;
                }
                default: {
                    this.invalidElement(elem, attributes);
                }
            }
        }

        protected void finished() {
            IRequirement requirement;
            String description;
            IMatchExpression filter;
            block6: {
                if (!MetadataParser.this.isValidXML()) {
                    return;
                }
                filter = null;
                if (this.filterHandler != null) {
                    try {
                        filter = InstallableUnit.parseFilter((String)this.filterHandler.getText());
                    }
                    catch (ExpressionParseException e) {
                        if (this.removeWhiteSpace(this.filterHandler.getText()).equals("(&(|)(|)(|))")) break block6;
                        throw e;
                    }
                }
            }
            String string = description = this.descriptionHandler == null ? null : this.descriptionHandler.getText();
            if (this.match != null) {
                IMatchExpression<IInstallableUnit> matchExpr = MetadataParser.createMatchExpression(this.match, this.matchParams);
                requirement = MetadataFactory.createRequirement(matchExpr, (IMatchExpression)filter, (int)this.min, (int)this.max, (boolean)this.greedy, (String)description);
            } else {
                requirement = MetadataFactory.createRequirement((String)this.namespace, (String)this.name, (VersionRange)this.range, (IMatchExpression)filter, (int)this.min, (int)this.max, (boolean)this.greedy, (String)description);
            }
            this.capabilities.add(requirement);
        }

        private String removeWhiteSpace(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) != ' ') {
                    builder.append(s.charAt(i));
                }
                ++i;
            }
            return builder.toString();
        }
    }

    protected class RequirementPropertiesHandler
    extends XMLParser.AbstractHandler {
        private final List<IRequirement> requirements;
        private final String namespace;
        private final String match;
        private final int min;
        private final int max;
        private final boolean greedy;
        private XMLParser.TextHandler filterHandler;
        private XMLParser.TextHandler descriptionHandler;

        public RequirementPropertiesHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<IRequirement> requirements) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "requiredProperties");
            this.requirements = requirements;
            String[] values = this.parseAttributes(attributes, REQIURED_PROPERTIES_MATCH_ATTRIBUTES, REQIURED_PROPERTIES_MATCH_OPTIONAL_ATTRIBUTES);
            this.namespace = values[0];
            this.match = values[1];
            this.min = values[2] == null ? 1 : MetadataParser.this.checkInteger("requiredProperties", "min", values[2]);
            this.max = values[3] == null ? 1 : MetadataParser.this.checkInteger("requiredProperties", "max", values[3]);
            this.greedy = MetadataParser.this.checkBoolean("requiredProperties", "greedy", values[4], true);
        }

        public void startElement(String elem, Attributes attributes) {
            switch (elem) {
                case "filter": {
                    this.filterHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "filter", attributes);
                    break;
                }
                case "description": {
                    this.descriptionHandler = new XMLParser.TextHandler((XMLParser)MetadataParser.this, (XMLParser.AbstractHandler)this, "description", attributes);
                    break;
                }
                default: {
                    this.invalidElement(elem, attributes);
                }
            }
        }

        protected void finished() {
            IMatchExpression filter;
            block4: {
                if (!MetadataParser.this.isValidXML()) {
                    return;
                }
                filter = null;
                if (this.filterHandler != null) {
                    try {
                        filter = InstallableUnit.parseFilter((String)this.filterHandler.getText());
                    }
                    catch (ExpressionParseException e) {
                        if (this.removeWhiteSpace(this.filterHandler.getText()).equals("(&(|)(|)(|))")) break block4;
                        throw e;
                    }
                }
            }
            String description = this.descriptionHandler != null ? this.descriptionHandler.getText() : null;
            IFilterExpression attrMatch = ExpressionUtil.parseLDAP((String)this.match);
            IRequirement requirement = MetadataFactory.createRequirement((String)this.namespace, (IFilterExpression)attrMatch, (IMatchExpression)filter, (int)this.min, (int)this.max, (boolean)this.greedy, (String)description);
            this.requirements.add(requirement);
        }

        private String removeWhiteSpace(String s) {
            if (s == null) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                if (s.charAt(i) != ' ') {
                    builder.append(s.charAt(i));
                }
                ++i;
            }
            return builder.toString();
        }
    }

    protected class RequirementsChangeHandler
    extends AbstractMetadataHandler {
        private final List<IRequirementChange> requirementChanges;

        public RequirementsChangeHandler(InstallableUnitHandler parentHandler, Attributes attributes) {
            super((ContentHandler)((Object)parentHandler), "changes");
            this.requirementChanges = new ArrayList<IRequirementChange>(this.getOptionalSize(attributes, 4));
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("change")) {
                new RequirementChangeHandler(this, attributes, this.requirementChanges);
            } else {
                this.invalidElement(name, attributes);
            }
        }

        public List<IRequirementChange> getRequirementChanges() {
            return this.requirementChanges;
        }
    }

    protected class RequirementsHandler
    extends AbstractMetadataHandler {
        private final List<IRequirement> requirements;

        public RequirementsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((ContentHandler)parentHandler, "requires");
            this.requirements = new ArrayList<IRequirement>(this.getOptionalSize(attributes, 4));
        }

        public IRequirement[] getRequirements() {
            return this.requirements.toArray(new IRequirement[this.requirements.size()]);
        }

        public void startElement(String name, Attributes attributes) {
            switch (name) {
                case "required": {
                    new RequirementHandler(this, attributes, this.requirements);
                    break;
                }
                case "requiredProperties": {
                    new RequirementPropertiesHandler(this, attributes, this.requirements);
                    break;
                }
                default: {
                    this.invalidElement(name, attributes);
                }
            }
        }
    }

    protected class TouchpointDataHandler
    extends XMLParser.AbstractHandler {
        ITouchpointData touchpointData;
        List<TouchpointInstructionsHandler> data;

        public TouchpointDataHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "touchpointData");
            this.touchpointData = null;
            this.data = null;
            String size = this.parseOptionalAttribute(attributes, "size");
            this.data = size != null ? new ArrayList<TouchpointInstructionsHandler>(Integer.parseInt(size)) : new ArrayList(4);
        }

        public ITouchpointData[] getTouchpointData() {
            ITouchpointData[] result = new ITouchpointData[this.data.size()];
            int i = 0;
            while (i < result.length) {
                result[i] = this.data.get(i).getTouchpointData();
                ++i;
            }
            return result;
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("instructions")) {
                this.data.add(new TouchpointInstructionsHandler(this, attributes, this.data));
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class TouchpointInstructionHandler
    extends XMLParser.TextHandler {
        private final String[] required;
        private final String[] optional;
        Map<String, ITouchpointInstruction> instructions;
        String key;
        String qualifier;

        public TouchpointInstructionHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, Map<String, ITouchpointInstruction> instructions) {
            super((XMLParser)MetadataParser.this, parentHandler, "instruction");
            this.required = new String[]{"key"};
            this.optional = new String[]{"import"};
            this.instructions = null;
            this.key = null;
            this.qualifier = null;
            String[] values = this.parseAttributes(attributes, this.required, this.optional);
            this.key = values[0];
            this.qualifier = values[1];
            this.instructions = instructions;
        }

        protected void finished() {
            if (MetadataParser.this.isValidXML() && this.key != null) {
                this.instructions.put(this.key, MetadataFactory.createTouchpointInstruction((String)this.getText(), (String)this.qualifier));
            }
        }
    }

    protected class TouchpointInstructionsHandler
    extends XMLParser.AbstractHandler {
        Map<String, ITouchpointInstruction> instructions;

        public TouchpointInstructionsHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes, List<TouchpointInstructionsHandler> data) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "instructions");
            this.instructions = null;
            String size = this.parseOptionalAttribute(attributes, "size");
            this.instructions = size != null ? new LinkedHashMap<String, ITouchpointInstruction>(Integer.parseInt(size)) : new LinkedHashMap(4);
        }

        public ITouchpointData getTouchpointData() {
            return MetadataFactory.createTouchpointData(this.instructions);
        }

        public void startElement(String name, Attributes attributes) {
            if (name.equals("instruction")) {
                new TouchpointInstructionHandler(this, attributes, this.instructions);
            } else {
                this.invalidElement(name, attributes);
            }
        }
    }

    protected class TouchpointTypeHandler
    extends XMLParser.AbstractHandler {
        private final String[] required;
        ITouchpointType touchpointType;

        public TouchpointTypeHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            super((XMLParser)MetadataParser.this, (ContentHandler)parentHandler, "touchpoint");
            this.required = new String[]{"id", "version"};
            this.touchpointType = null;
            String[] values = this.parseRequiredAttributes(attributes, this.required);
            Version version = MetadataParser.this.checkVersion("touchpoint", "version", values[1]);
            this.touchpointType = MetadataFactory.createTouchpointType((String)values[0], (Version)version);
        }

        public ITouchpointType getTouchpointType() {
            return this.touchpointType;
        }

        public void startElement(String name, Attributes attributes) {
            this.invalidElement(name, attributes);
        }
    }

    protected class UpdateDescriptorHandler
    extends XMLParser.TextHandler {
        private final String[] requiredSimple;
        private final String[] optionalSimple;
        private final String[] requiredComplex;
        private final String[] optionalComplex;
        private IUpdateDescriptor descriptor;

        public UpdateDescriptorHandler(XMLParser.AbstractHandler parentHandler, Attributes attributes) {
            int severity;
            String description;
            int severityIdx;
            String[] values;
            boolean simple;
            super((XMLParser)MetadataParser.this, parentHandler, "unit");
            this.requiredSimple = new String[]{"id", "range"};
            this.optionalSimple = new String[]{"severity", "description"};
            this.requiredComplex = new String[]{"match"};
            this.optionalComplex = new String[]{"severity", "description", "matchParameters"};
            boolean bl = simple = attributes.getIndex("id") >= 0;
            if (simple) {
                values = this.parseAttributes(attributes, this.requiredSimple, this.optionalSimple);
                severityIdx = 2;
                description = values[3];
            } else {
                values = this.parseAttributes(attributes, this.requiredComplex, this.optionalComplex);
                severityIdx = 1;
                description = values[2];
            }
            try {
                severity = Integer.parseInt(values[severityIdx]);
            }
            catch (NumberFormatException e) {
                MetadataParser.this.invalidAttributeValue("update", "severity", values[severityIdx]);
                severity = 0;
            }
            URI location = this.parseURIAttribute(attributes, false);
            if (simple) {
                VersionRange range = MetadataParser.this.checkVersionRange("required", "range", values[1]);
                this.descriptor = MetadataFactory.createUpdateDescriptor((String)values[0], (VersionRange)range, (int)severity, (String)description, (URI)location);
            } else {
                IMatchExpression<IInstallableUnit> r = MetadataParser.createMatchExpression(values[0], values[3]);
                this.descriptor = MetadataFactory.createUpdateDescriptor(Collections.singleton(r), (int)severity, (String)description, (URI)location);
            }
        }

        public IUpdateDescriptor getUpdateDescriptor() {
            return this.descriptor;
        }
    }
}

