/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.chi.runtime;

import org.eclipse.escet.chi.runtime.SvgModification;
import org.eclipse.escet.common.java.Strings;
import org.eclipse.escet.common.java.exceptions.InputOutputException;
import org.eclipse.escet.common.svg.SvgUtils;
import org.eclipse.escet.common.svg.SvgVisualizer;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class SvgTextModification
extends SvgModification {
    public String value;

    @Override
    public void apply(SvgVisualizer svgVis) {
        Element element = svgVis.getDocument().getElementById(this.nodeName);
        if (element == null) {
            String msg = Strings.fmt((String)"Failed to find SVG element \"%s\".", (Object[])new Object[]{this.nodeName});
            throw new InputOutputException(msg);
        }
        Text text = SvgUtils.getTextNode((Element)element);
        if (text == null) {
            String msg = Strings.fmt((String)"Failed to find SVG text element \"%s\".", (Object[])new Object[]{this.nodeName});
            throw new InputOutputException(msg);
        }
        text.setNodeValue(this.value);
    }

    public static SvgTextModification decode(String line, String svgPath) {
        if (!line.startsWith("text")) {
            return null;
        }
        SvgTextModification std = new SvgTextModification();
        std.svgPath = svgPath;
        int j = line.indexOf(61);
        if (j < 0) {
            String msg = Strings.fmt((String)"Missing \"=\" in text command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        std.nodeName = SvgTextModification.getWord(line, 4, j);
        if (std.nodeName.isEmpty()) {
            String msg = Strings.fmt((String)"Node name is empty in text command \"%s\".", (Object[])new Object[]{line});
            throw new InputOutputException(msg);
        }
        std.value = SvgTextModification.getWord(line, j + 1, line.length());
        return std;
    }
}

