/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.escet.cif.eventbased.analysis;

import java.util.List;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.ReportText;
import org.eclipse.escet.cif.eventbased.analysis.reporttext.SimpleText;
import org.eclipse.escet.cif.eventbased.apps.SynthesisAnalysisEditor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class AnalysisReportHandler
implements Listener {
    private SynthesisAnalysisEditor app = null;
    private StyledText reportWidget;

    public AnalysisReportHandler(Composite root) {
        SimpleText reportText = new SimpleText("Initializing...");
        this.reportWidget = new StyledText(root, 2634);
        this.reportWidget.setSize(600, 500);
        this.setResult(reportText);
        GridData gridData = new GridData(4, 4, true, true);
        this.reportWidget.setLayoutData((Object)gridData);
        this.reportWidget.addListener(8, (Listener)this);
    }

    public void setApplication(SynthesisAnalysisEditor app) {
        this.app = app;
        int numPl = app.data.getNumberPlants();
        int numRq = app.data.getNumberAutomata() - numPl;
        int created = app.data.states.size();
        int removed = app.data.getRemovedCount();
        int remain = created - removed;
        SimpleText reportText = new SimpleText("Synthesis analysis tool\r\n" + SynthesisAnalysisEditor.makeCountText(numPl, "%d plant %s.\r\n", "automaton", "automata") + SynthesisAnalysisEditor.makeCountText(numRq, "%d requirement %s.\r\n", "automaton", "automata") + SynthesisAnalysisEditor.makeCountText(created, "Synthesis created %d %s, ", "state", "states") + SynthesisAnalysisEditor.makeCountText(removed, "removed %d %s, ", "state", "states") + SynthesisAnalysisEditor.makeCountText(remain, "giving %d %s in the result.\r\n", "state", "states") + "\r\nSelect a combination of locations at the left, and press 'search state' to analyse the state.\r\n");
        this.setResult(reportText);
    }

    public void setResult(ReportText text) {
        this.reportWidget.setStyleRange(null);
        this.reportWidget.setText("");
        text.addText(this.reportWidget, 0);
    }

    public void setResult(List<ReportText> texts) {
        this.reportWidget.setStyleRange(null);
        this.reportWidget.setText("");
        int length = 0;
        for (ReportText text : texts) {
            length = text.addText(this.reportWidget, length);
        }
    }

    public void addResult(ReportText text) {
        int length = this.reportWidget.getContent().getCharCount();
        text.addText(this.reportWidget, length);
    }

    public void addResult(List<ReportText> texts) {
        int length = this.reportWidget.getContent().getCharCount();
        for (ReportText text : texts) {
            length = text.addText(this.reportWidget, length);
        }
    }

    private static int digitValue(String reportText, int offset) {
        if (offset < 0 || offset >= reportText.length()) {
            return -1;
        }
        char k = reportText.charAt(offset);
        if (k >= '0' && k <= '9') {
            return k - 48;
        }
        return -1;
    }

    public void handleEvent(Event event) {
        if (this.app == null) {
            return;
        }
        int offset = this.reportWidget.getOffsetAtPoint(new Point(event.x, event.y));
        if (offset == -1) {
            return;
        }
        String reportText = this.reportWidget.getText();
        int count = 0;
        while (count < 10 && offset >= 0) {
            if (offset < reportText.length() && reportText.charAt(offset) == '#') break;
            ++count;
            --offset;
        }
        if (count >= 10 || offset < 0) {
            return;
        }
        if (AnalysisReportHandler.digitValue(reportText, ++offset) < 0) {
            return;
        }
        int value = AnalysisReportHandler.digitValue(reportText, offset);
        while (true) {
            int digit;
            if (value < 0) {
                return;
            }
            if ((digit = AnalysisReportHandler.digitValue(reportText, ++offset)) < 0) break;
            value = value * 10 + digit;
        }
        this.app.setSelectedState(value);
    }
}

