/*
 * generated by Xtext
 */
package org.eclipse.etrice.core.fsm.scoping

import com.google.inject.Inject
import java.util.HashMap
import java.util.List
import org.eclipse.emf.ecore.EObject
import org.eclipse.emf.ecore.EReference
import org.eclipse.etrice.core.fsm.fSM.ChoicepointTerminal
import org.eclipse.etrice.core.fsm.fSM.RefinedState
import org.eclipse.etrice.core.fsm.fSM.SimpleState
import org.eclipse.etrice.core.fsm.fSM.State
import org.eclipse.etrice.core.fsm.fSM.StateGraph
import org.eclipse.etrice.core.fsm.fSM.StateTerminal
import org.eclipse.etrice.core.fsm.fSM.SubStateTrPointTerminal
import org.eclipse.etrice.core.fsm.fSM.TrPointTerminal
import org.eclipse.etrice.core.fsm.util.FSMHelpers
import org.eclipse.xtext.naming.QualifiedName
import org.eclipse.xtext.resource.EObjectDescription
import org.eclipse.xtext.resource.IEObjectDescription
import org.eclipse.xtext.scoping.IScope
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider
import org.eclipse.xtext.scoping.impl.SimpleScope
import org.eclipse.etrice.core.fsm.fSM.ModelComponent
import java.util.HashSet
import java.util.ArrayList
import org.eclipse.etrice.core.fsm.fSM.RefinedTransition
import org.eclipse.xtext.naming.IQualifiedNameProvider
import org.eclipse.etrice.core.fsm.fSM.Transition

/**
 * This class contains custom scoping description.
 * 
 * see : http://www.eclipse.org/Xtext/documentation.html#scoping
 * on how and when to use it 
 *
 */
class FSMScopeProvider extends AbstractDeclarativeScopeProvider {
	
	@Inject extension FSMHelpers

	@Inject extension IQualifiedNameProvider

	/**
	 * returns a flat list of State scopes for a {@link StateTerminal}
	 * @param st - the transition endpoint or terminal
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_StateTerminal_state(StateTerminal st, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList

		// first state graph in container hierarchy
		val parent = getStateGraph(st)
		getStateScopes(parent, scopes)

		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}

	/**
	 * returns a flat list of TransitionPoint scopes for a {@link TrPointTerminal}
	 * @param ep - the transition endpoint or terminal
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_TrPointTerminal_trPoint(TrPointTerminal ep, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList
		
		val parent = getStateGraph(ep)
		val tps = parent.allTrPoints
		for (tp : tps) {
			scopes.add(EObjectDescription.create(tp.name, tp))
		}
		
		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}

	/**
	 * returns a flat list of TransitionPoint scopes for a {@link SubStateTrPointTerminal}
	 * @param ep - the transition endpoint or terminal
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_SubStateTrPointTerminal_trPoint(SubStateTrPointTerminal ep, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList
		
		val parent = getStateGraph(ep)
		if (ep.state!==null) {
			var epState = ep.state
			
			// check if there is a refined state for this state
			epState = parent.getRefinedStateFor(epState)
			
			if (epState.getSubgraph()!==null) {
				val tps = epState.subgraph.getAllTrPoints
				for (tp : tps) {
					scopes.add(EObjectDescription.create(tp.name, tp))
				}
			}
		}
		
		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}

	/**
	 * returns a flat list of State scopes for a {@link SubStateTrPointTerminal}
	 * @param st - the transition endpoint or terminal
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_SubStateTrPointTerminal_state(SubStateTrPointTerminal st, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList
		
		val parent = getStateGraph(st)
		getStateScopes(parent, scopes)
		
		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}

	/**
	 * returns a flat list of Choicepoint scopes for a {@link SubStateTrPointTerminal}
	 * @param ct - the transition endpoint or terminal
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_ChoicepointTerminal_cp(ChoicepointTerminal ct, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList
		
		val parent = getStateGraph(ct)
		val choicePoints = parent.allChoicePoints
		for (cp : choicePoints) {
			scopes.add(EObjectDescription.create(cp.name, cp))
		}
		
		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}
	
	/**
	 * returns a flat list of BaseState scopes for a {@link RefinedState}
	 * @param rs - the refined state
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_RefinedState_target(RefinedState rs, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList
		
		var sg = getStateGraph(rs)
		if (sg.eContainer instanceof ModelComponent) {
			var comp = sg.eContainer as ModelComponent
			if (comp.base !== null && !comp.isCircularClassHierarchy) {
				comp = comp.base
				val HashSet<State> covered = newHashSet
				val ArrayList<State> states = newArrayList
				while (comp!==null) {
					recursivelyAddStates(comp.stateMachine, covered, states)
					comp = comp.base
				}
				for (s : states) {
					scopes.add(EObjectDescription.create(s.statePath, s))
				}
			}
		}
		else if (sg.eContainer instanceof RefinedState) {
			sg = (sg.eContainer as RefinedState).target.subgraph
			if (sg!==null)
				for (s : sg.states) {
					scopes.add(EObjectDescription.create(s.name, s))
				}
		}
		
		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}
	
	/**
	 * returns a flat list of Transition scopes for a {@link RefinedTransition}
	 * @param trans - the refined transition
	 * @param ref - not used
	 * @return a list of scopes
	 */
	def IScope scope_RefinedTransition_target(RefinedTransition trans, EReference ref) {
		val List<IEObjectDescription> scopes = newArrayList
		
		var comp = trans.eContainer.eContainer as ModelComponent
		if(!comp.isCircularClassHierarchy){
			comp = comp.base
			while (comp!==null) {
				if (comp.stateMachine!==null) {
					val acNameSegments = comp.fullyQualifiedName.segmentCount
					val iter = comp.stateMachine.eAllContents
					while (iter.hasNext) {
						val EObject obj = iter.next
						if (obj instanceof Transition) {
							// use qualified name but skip ac FQN and also omit state machine name 'sm'
							scopes.add(EObjectDescription.create(obj.fullyQualifiedName.skipFirst(acNameSegments+1), obj))
						}
					}
				}
				comp = comp.base
			}
		}
		return new SimpleScope(IScope.NULLSCOPE, scopes)
	}
	
	/**
	 * @param sg
	 * @param covered
	 * @param states
	 */
	def private void recursivelyAddStates(StateGraph sg, HashSet<State> covered, ArrayList<State> states) {
		for (s : sg.states) {
			if (s instanceof SimpleState && !covered.contains(s)) {
				states.add(s)
			}
			else if (s instanceof RefinedState && !covered.contains(s)) {
				states.add(s)
				covered.add((s as RefinedState).target)
			}
		}
		
		// recursion
		for (s : sg.states) {
			if (s.getSubgraph()!==null)
				recursivelyAddStates(s.getSubgraph(), covered, states)
		}
	}
	
	/**
	 * first container of type {@link StateGraph} ({@link State}, {@link StateMachine})
	 * @param obj
	 * @return StateGraph Container
	 */
	def private StateGraph getStateGraph(EObject obj) {
		var EObject ctx = obj.eContainer
		while (!(ctx instanceof StateGraph) && ctx.eContainer!==null) {
			ctx = ctx.eContainer
		}
		if (ctx instanceof StateGraph)
			return ctx
		
		return null
	}

	/**
	 * compute the path of a {@link BaseState}
	 * @param bs
	 * @return the path
	 */
	def private QualifiedName getStatePath(State bs) {
		val EObject parent = bs.eContainer.eContainer
		if (parent instanceof SimpleState)
			return getStatePath(parent).append(bs.name)
		else if (parent instanceof RefinedState) {
			val State target = parent.target
			if (target!==null)
				return getStatePath(target).append(bs.name)
		}
		return QualifiedName.create(bs.name)
	}

	/**
	 * @param parent
	 * @param scopes
	 */
	def private void getStateScopes(StateGraph parent, List<IEObjectDescription> scopes) {
		val states = parent.allStates
		val HashMap<String, SimpleState> name2state = newHashMap
		for (s : states) {
			// returning SimpleStates only simplifies the relocation task in the generator model:
			// there we shuffle RefinedState contents to SimpleStates and remove the RefinedStates.
			// If we had references to RefinedStates we had to redirect those
			name2state.put(s.getName(), s.baseState)
		}
		for (entry : name2state.entrySet) {
			scopes.add(EObjectDescription.create(entry.key, entry.value))
		}
	}

}
