/*
 * Decompiled with CFR 0.152.
 */
package org.commonmark.internal;

import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.commonmark.internal.Bracket;
import org.commonmark.internal.Delimiter;
import org.commonmark.internal.StaggeredDelimiterProcessor;
import org.commonmark.internal.inline.AsteriskDelimiterProcessor;
import org.commonmark.internal.inline.UnderscoreDelimiterProcessor;
import org.commonmark.internal.util.Escaping;
import org.commonmark.internal.util.Html5Entities;
import org.commonmark.internal.util.LinkScanner;
import org.commonmark.internal.util.Parsing;
import org.commonmark.node.Code;
import org.commonmark.node.HardLineBreak;
import org.commonmark.node.HtmlInline;
import org.commonmark.node.Image;
import org.commonmark.node.Link;
import org.commonmark.node.LinkReferenceDefinition;
import org.commonmark.node.Node;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.parser.InlineParser;
import org.commonmark.parser.InlineParserContext;
import org.commonmark.parser.delimiter.DelimiterProcessor;

public class InlineParserImpl
implements InlineParser {
    private static final String HTMLCOMMENT = "<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->";
    private static final String PROCESSINGINSTRUCTION = "[<][?].*?[?][>]";
    private static final String DECLARATION = "<![A-Z]+\\s+[^>]*>";
    private static final String CDATA = "<!\\[CDATA\\[[\\s\\S]*?\\]\\]>";
    private static final String HTMLTAG = "(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>]|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|[<][?].*?[?][>]|<![A-Z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)";
    private static final String ASCII_PUNCTUATION = "!\"#\\$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~";
    private static final Pattern PUNCTUATION = Pattern.compile("^[!\"#\\$%&'\\(\\)\\*\\+,\\-\\./:;<=>\\?@\\[\\\\\\]\\^_`\\{\\|\\}~\\p{Pc}\\p{Pd}\\p{Pe}\\p{Pf}\\p{Pi}\\p{Po}\\p{Ps}]");
    private static final Pattern HTML_TAG = Pattern.compile("^(?:<[A-Za-z][A-Za-z0-9-]*(?:\\s+[a-zA-Z_:][a-zA-Z0-9:._-]*(?:\\s*=\\s*(?:[^\"'=<>`\\x00-\\x20]+|'[^']*'|\"[^\"]*\"))?)*\\s*/?>|</[A-Za-z][A-Za-z0-9-]*\\s*[>]|<!---->|<!--(?:-?[^>-])(?:-?[^-])*-->|[<][?].*?[?][>]|<![A-Z]+\\s+[^>]*>|<!\\[CDATA\\[[\\s\\S]*?\\]\\]>)", 2);
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");
    private static final Pattern ENTITY_HERE = Pattern.compile("^&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern TICKS = Pattern.compile("`+");
    private static final Pattern TICKS_HERE = Pattern.compile("^`+");
    private static final Pattern EMAIL_AUTOLINK = Pattern.compile("^<([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)>");
    private static final Pattern AUTOLINK = Pattern.compile("^<[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*>");
    private static final Pattern SPNL = Pattern.compile("^ *(?:\n *)?");
    private static final Pattern UNICODE_WHITESPACE_CHAR = Pattern.compile("^[\\p{Zs}\t\r\n\f]");
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern FINAL_SPACE = Pattern.compile(" *$");
    private final BitSet specialCharacters;
    private final BitSet delimiterCharacters;
    private final Map<Character, DelimiterProcessor> delimiterProcessors;
    private final InlineParserContext context;
    private String input;
    private int index;
    private Delimiter lastDelimiter;
    private Bracket lastBracket;

    public InlineParserImpl(InlineParserContext inlineParserContext) {
        this.delimiterProcessors = InlineParserImpl.calculateDelimiterProcessors(inlineParserContext.getCustomDelimiterProcessors());
        this.delimiterCharacters = InlineParserImpl.calculateDelimiterCharacters(this.delimiterProcessors.keySet());
        this.specialCharacters = InlineParserImpl.calculateSpecialCharacters(this.delimiterCharacters);
        this.context = inlineParserContext;
    }

    public static BitSet calculateDelimiterCharacters(Set<Character> characters) {
        BitSet bitSet = new BitSet();
        for (Character character : characters) {
            bitSet.set(character.charValue());
        }
        return bitSet;
    }

    public static BitSet calculateSpecialCharacters(BitSet delimiterCharacters) {
        BitSet bitSet = new BitSet();
        bitSet.or(delimiterCharacters);
        bitSet.set(10);
        bitSet.set(96);
        bitSet.set(91);
        bitSet.set(93);
        bitSet.set(92);
        bitSet.set(33);
        bitSet.set(60);
        bitSet.set(38);
        return bitSet;
    }

    public static Map<Character, DelimiterProcessor> calculateDelimiterProcessors(List<DelimiterProcessor> delimiterProcessors) {
        HashMap<Character, DelimiterProcessor> map = new HashMap<Character, DelimiterProcessor>();
        InlineParserImpl.addDelimiterProcessors(Arrays.asList(new AsteriskDelimiterProcessor(), new UnderscoreDelimiterProcessor()), map);
        InlineParserImpl.addDelimiterProcessors(delimiterProcessors, map);
        return map;
    }

    private static void addDelimiterProcessors(Iterable<DelimiterProcessor> delimiterProcessors, Map<Character, DelimiterProcessor> map) {
        for (DelimiterProcessor delimiterProcessor : delimiterProcessors) {
            char closing;
            char opening = delimiterProcessor.getOpeningCharacter();
            if (opening == (closing = delimiterProcessor.getClosingCharacter())) {
                DelimiterProcessor old = map.get(Character.valueOf(opening));
                if (old != null && old.getOpeningCharacter() == old.getClosingCharacter()) {
                    StaggeredDelimiterProcessor s;
                    if (old instanceof StaggeredDelimiterProcessor) {
                        s = (StaggeredDelimiterProcessor)old;
                    } else {
                        s = new StaggeredDelimiterProcessor(opening);
                        s.add(old);
                    }
                    s.add(delimiterProcessor);
                    map.put(Character.valueOf(opening), s);
                    continue;
                }
                InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
                continue;
            }
            InlineParserImpl.addDelimiterProcessorForChar(opening, delimiterProcessor, map);
            InlineParserImpl.addDelimiterProcessorForChar(closing, delimiterProcessor, map);
        }
    }

    private static void addDelimiterProcessorForChar(char delimiterChar, DelimiterProcessor toAdd, Map<Character, DelimiterProcessor> delimiterProcessors) {
        DelimiterProcessor existing = delimiterProcessors.put(Character.valueOf(delimiterChar), toAdd);
        if (existing != null) {
            throw new IllegalArgumentException("Delimiter processor conflict with delimiter char '" + delimiterChar + "'");
        }
    }

    @Override
    public void parse(String content, Node block) {
        this.reset(content.trim());
        Node previous = null;
        while (true) {
            Node node;
            previous = node = this.parseInline(previous);
            if (node == null) break;
            block.appendChild(node);
        }
        this.processDelimiters(null);
        this.mergeChildTextNodes(block);
    }

    void reset(String content) {
        this.input = content;
        this.index = 0;
        this.lastDelimiter = null;
        this.lastBracket = null;
    }

    private Text text(String text, int beginIndex, int endIndex) {
        return new Text(text.substring(beginIndex, endIndex));
    }

    private Text text(String text) {
        return new Text(text);
    }

    private Node parseInline(Node previous) {
        Node node;
        char c = this.peek();
        if (c == '\u0000') {
            return null;
        }
        switch (c) {
            case '\n': {
                node = this.parseNewline(previous);
                break;
            }
            case '\\': {
                node = this.parseBackslash();
                break;
            }
            case '`': {
                node = this.parseBackticks();
                break;
            }
            case '[': {
                node = this.parseOpenBracket();
                break;
            }
            case '!': {
                node = this.parseBang();
                break;
            }
            case ']': {
                node = this.parseCloseBracket();
                break;
            }
            case '<': {
                node = this.parseAutolink();
                if (node != null) break;
                node = this.parseHtmlInline();
                break;
            }
            case '&': {
                node = this.parseEntity();
                break;
            }
            default: {
                boolean isDelimiter = this.delimiterCharacters.get(c);
                if (isDelimiter) {
                    DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(c));
                    node = this.parseDelimiters(delimiterProcessor, c);
                    break;
                }
                node = this.parseString();
            }
        }
        if (node != null) {
            return node;
        }
        ++this.index;
        String literal = String.valueOf(c);
        return this.text(literal);
    }

    private String match(Pattern re) {
        if (this.index >= this.input.length()) {
            return null;
        }
        try {
            Matcher matcher = re.matcher(this.input);
            matcher.region(this.index, this.input.length());
            boolean m = matcher.find();
            if (m) {
                this.index = matcher.end();
                return matcher.group();
            }
            return null;
        }
        catch (StackOverflowError e) {
            return null;
        }
    }

    private char peek() {
        if (this.index < this.input.length()) {
            return this.input.charAt(this.index);
        }
        return '\u0000';
    }

    private void spnl() {
        this.match(SPNL);
    }

    private Node parseNewline(Node previous) {
        ++this.index;
        if (previous instanceof Text && ((Text)previous).getLiteral().endsWith(" ")) {
            int spaces;
            Text text = (Text)previous;
            String literal = text.getLiteral();
            Matcher matcher = FINAL_SPACE.matcher(literal);
            int n = spaces = matcher.find() ? matcher.end() - matcher.start() : 0;
            if (spaces > 0) {
                text.setLiteral(literal.substring(0, literal.length() - spaces));
            }
            if (spaces >= 2) {
                return new HardLineBreak();
            }
            return new SoftLineBreak();
        }
        return new SoftLineBreak();
    }

    private Node parseBackslash() {
        Node node;
        ++this.index;
        if (this.peek() == '\n') {
            node = new HardLineBreak();
            ++this.index;
        } else if (this.index < this.input.length() && ESCAPABLE.matcher(this.input.substring(this.index, this.index + 1)).matches()) {
            node = this.text(this.input, this.index, this.index + 1);
            ++this.index;
        } else {
            node = this.text("\\");
        }
        return node;
    }

    private Node parseBackticks() {
        String matched;
        String ticks = this.match(TICKS_HERE);
        if (ticks == null) {
            return null;
        }
        int afterOpenTicks = this.index;
        while ((matched = this.match(TICKS)) != null) {
            if (!matched.equals(ticks)) continue;
            Code node = new Code();
            String content = this.input.substring(afterOpenTicks, this.index - ticks.length());
            if ((content = content.replace('\n', ' ')).length() >= 3 && content.charAt(0) == ' ' && content.charAt(content.length() - 1) == ' ' && Parsing.hasNonSpace(content)) {
                content = content.substring(1, content.length() - 1);
            }
            node.setLiteral(content);
            return node;
        }
        this.index = afterOpenTicks;
        return this.text(ticks);
    }

    private Node parseDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        DelimiterData res = this.scanDelimiters(delimiterProcessor, delimiterChar);
        if (res == null) {
            return null;
        }
        int length = res.count;
        int startIndex = this.index;
        this.index += length;
        Text node = this.text(this.input, startIndex, this.index);
        this.lastDelimiter = new Delimiter(node, delimiterChar, res.canOpen, res.canClose, this.lastDelimiter);
        this.lastDelimiter.length = length;
        this.lastDelimiter.originalLength = length;
        if (this.lastDelimiter.previous != null) {
            this.lastDelimiter.previous.next = this.lastDelimiter;
        }
        return node;
    }

    private Node parseOpenBracket() {
        int startIndex = this.index++;
        Text node = this.text("[");
        this.addBracket(Bracket.link(node, startIndex, this.lastBracket, this.lastDelimiter));
        return node;
    }

    private Node parseBang() {
        int startIndex = this.index++;
        if (this.peek() == '[') {
            ++this.index;
            Text node = this.text("![");
            this.addBracket(Bracket.image(node, startIndex + 1, this.lastBracket, this.lastDelimiter));
            return node;
        }
        return this.text("!");
    }

    private Node parseCloseBracket() {
        ++this.index;
        int startIndex = this.index++;
        Bracket opener = this.lastBracket;
        if (opener == null) {
            return this.text("]");
        }
        if (!opener.allowed) {
            this.removeLastBracket();
            return this.text("]");
        }
        String dest = null;
        String title = null;
        boolean isLinkOrImage = false;
        if (this.peek() == '(') {
            this.spnl();
            dest = this.parseLinkDestination();
            if (dest != null) {
                this.spnl();
                if (WHITESPACE.matcher(this.input.substring(this.index - 1, this.index)).matches()) {
                    title = this.parseLinkTitle();
                    this.spnl();
                }
                if (this.peek() == ')') {
                    ++this.index;
                    isLinkOrImage = true;
                } else {
                    this.index = startIndex;
                }
            }
        }
        if (!isLinkOrImage) {
            String label;
            LinkReferenceDefinition definition;
            int beforeLabel = this.index;
            this.parseLinkLabel();
            int labelLength = this.index - beforeLabel;
            String ref = null;
            if (labelLength > 2) {
                ref = this.input.substring(beforeLabel, beforeLabel + labelLength);
            } else if (!opener.bracketAfter) {
                ref = this.input.substring(opener.index, startIndex);
            }
            if (ref != null && (definition = this.context.getLinkReferenceDefinition(label = Escaping.normalizeReference(ref))) != null) {
                dest = definition.getDestination();
                title = definition.getTitle();
                isLinkOrImage = true;
            }
        }
        if (isLinkOrImage) {
            Node linkOrImage = opener.image ? new Image(dest, title) : new Link(dest, title);
            Node node = opener.node.getNext();
            while (node != null) {
                Node next = node.getNext();
                linkOrImage.appendChild(node);
                node = next;
            }
            this.processDelimiters(opener.previousDelimiter);
            this.mergeChildTextNodes(linkOrImage);
            opener.node.unlink();
            this.removeLastBracket();
            if (!opener.image) {
                Bracket bracket = this.lastBracket;
                while (bracket != null) {
                    if (!bracket.image) {
                        bracket.allowed = false;
                    }
                    bracket = bracket.previous;
                }
            }
            return linkOrImage;
        }
        this.index = startIndex;
        this.removeLastBracket();
        return this.text("]");
    }

    private void addBracket(Bracket bracket) {
        if (this.lastBracket != null) {
            this.lastBracket.bracketAfter = true;
        }
        this.lastBracket = bracket;
    }

    private void removeLastBracket() {
        this.lastBracket = this.lastBracket.previous;
    }

    private String parseLinkDestination() {
        int afterDest = LinkScanner.scanLinkDestination(this.input, this.index);
        if (afterDest == -1) {
            return null;
        }
        String dest = this.peek() == '<' ? this.input.substring(this.index + 1, afterDest - 1) : this.input.substring(this.index, afterDest);
        this.index = afterDest;
        return Escaping.unescapeString(dest);
    }

    private String parseLinkTitle() {
        int afterTitle = LinkScanner.scanLinkTitle(this.input, this.index);
        if (afterTitle == -1) {
            return null;
        }
        String title = this.input.substring(this.index + 1, afterTitle - 1);
        this.index = afterTitle;
        return Escaping.unescapeString(title);
    }

    int parseLinkLabel() {
        if (this.index >= this.input.length() || this.input.charAt(this.index) != '[') {
            return 0;
        }
        int startContent = this.index + 1;
        int endContent = LinkScanner.scanLinkLabelContent(this.input, startContent);
        int contentLength = endContent - startContent;
        if (endContent == -1 || contentLength > 999) {
            return 0;
        }
        if (endContent >= this.input.length() || this.input.charAt(endContent) != ']') {
            return 0;
        }
        this.index = endContent + 1;
        return contentLength + 2;
    }

    private Node parseAutolink() {
        String m = this.match(EMAIL_AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node = new Link("mailto:" + dest, null);
            node.appendChild(new Text(dest));
            return node;
        }
        m = this.match(AUTOLINK);
        if (m != null) {
            String dest = m.substring(1, m.length() - 1);
            Link node = new Link(dest, null);
            node.appendChild(new Text(dest));
            return node;
        }
        return null;
    }

    private Node parseHtmlInline() {
        String m = this.match(HTML_TAG);
        if (m != null) {
            HtmlInline node = new HtmlInline();
            node.setLiteral(m);
            return node;
        }
        return null;
    }

    private Node parseEntity() {
        String m = this.match(ENTITY_HERE);
        if (m != null) {
            return this.text(Html5Entities.entityToString(m));
        }
        return null;
    }

    private Node parseString() {
        int begin = this.index;
        int length = this.input.length();
        while (this.index != length && !this.specialCharacters.get(this.input.charAt(this.index))) {
            ++this.index;
        }
        if (begin != this.index) {
            return this.text(this.input, begin, this.index);
        }
        return null;
    }

    private DelimiterData scanDelimiters(DelimiterProcessor delimiterProcessor, char delimiterChar) {
        boolean canClose;
        boolean canOpen;
        boolean rightFlanking;
        int startIndex = this.index;
        int delimiterCount = 0;
        while (this.peek() == delimiterChar) {
            ++delimiterCount;
            ++this.index;
        }
        if (delimiterCount < delimiterProcessor.getMinLength()) {
            this.index = startIndex;
            return null;
        }
        String before = startIndex == 0 ? "\n" : this.input.substring(startIndex - 1, startIndex);
        char charAfter = this.peek();
        String after = charAfter == '\u0000' ? "\n" : String.valueOf(charAfter);
        boolean beforeIsPunctuation = PUNCTUATION.matcher(before).matches();
        boolean beforeIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(before).matches();
        boolean afterIsPunctuation = PUNCTUATION.matcher(after).matches();
        boolean afterIsWhitespace = UNICODE_WHITESPACE_CHAR.matcher(after).matches();
        boolean leftFlanking = !afterIsWhitespace && (!afterIsPunctuation || beforeIsWhitespace || beforeIsPunctuation);
        boolean bl = rightFlanking = !beforeIsWhitespace && (!beforeIsPunctuation || afterIsWhitespace || afterIsPunctuation);
        if (delimiterChar == '_') {
            canOpen = leftFlanking && (!rightFlanking || beforeIsPunctuation);
            canClose = rightFlanking && (!leftFlanking || afterIsPunctuation);
        } else {
            canOpen = leftFlanking && delimiterChar == delimiterProcessor.getOpeningCharacter();
            canClose = rightFlanking && delimiterChar == delimiterProcessor.getClosingCharacter();
        }
        this.index = startIndex;
        return new DelimiterData(delimiterCount, canOpen, canClose);
    }

    private void processDelimiters(Delimiter stackBottom) {
        HashMap<Character, Delimiter> openersBottom = new HashMap<Character, Delimiter>();
        Delimiter closer = this.lastDelimiter;
        while (closer != null && closer.previous != stackBottom) {
            closer = closer.previous;
        }
        while (closer != null) {
            char delimiterChar = closer.delimiterChar;
            DelimiterProcessor delimiterProcessor = this.delimiterProcessors.get(Character.valueOf(delimiterChar));
            if (!closer.canClose || delimiterProcessor == null) {
                closer = closer.next;
                continue;
            }
            char openingDelimiterChar = delimiterProcessor.getOpeningCharacter();
            int useDelims = 0;
            boolean openerFound = false;
            boolean potentialOpenerFound = false;
            Delimiter opener = closer.previous;
            while (opener != null && opener != stackBottom && opener != openersBottom.get(Character.valueOf(delimiterChar))) {
                if (opener.canOpen && opener.delimiterChar == openingDelimiterChar) {
                    potentialOpenerFound = true;
                    useDelims = delimiterProcessor.getDelimiterUse(opener, closer);
                    if (useDelims > 0) {
                        openerFound = true;
                        break;
                    }
                }
                opener = opener.previous;
            }
            if (!openerFound) {
                if (!potentialOpenerFound) {
                    openersBottom.put(Character.valueOf(delimiterChar), closer.previous);
                    if (!closer.canOpen) {
                        this.removeDelimiterKeepNode(closer);
                    }
                }
                closer = closer.next;
                continue;
            }
            Text openerNode = opener.node;
            Text closerNode = closer.node;
            opener.length -= useDelims;
            closer.length -= useDelims;
            openerNode.setLiteral(openerNode.getLiteral().substring(0, openerNode.getLiteral().length() - useDelims));
            closerNode.setLiteral(closerNode.getLiteral().substring(0, closerNode.getLiteral().length() - useDelims));
            this.removeDelimitersBetween(opener, closer);
            this.mergeTextNodesBetweenExclusive(openerNode, closerNode);
            delimiterProcessor.process(openerNode, closerNode, useDelims);
            if (opener.length == 0) {
                this.removeDelimiterAndNode(opener);
            }
            if (closer.length != 0) continue;
            Delimiter next = closer.next;
            this.removeDelimiterAndNode(closer);
            closer = next;
        }
        while (this.lastDelimiter != null && this.lastDelimiter != stackBottom) {
            this.removeDelimiterKeepNode(this.lastDelimiter);
        }
    }

    private void removeDelimitersBetween(Delimiter opener, Delimiter closer) {
        Delimiter delimiter = closer.previous;
        while (delimiter != null && delimiter != opener) {
            Delimiter previousDelimiter = delimiter.previous;
            this.removeDelimiterKeepNode(delimiter);
            delimiter = previousDelimiter;
        }
    }

    private void removeDelimiterAndNode(Delimiter delim) {
        Text node = delim.node;
        node.unlink();
        this.removeDelimiter(delim);
    }

    private void removeDelimiterKeepNode(Delimiter delim) {
        this.removeDelimiter(delim);
    }

    private void removeDelimiter(Delimiter delim) {
        if (delim.previous != null) {
            delim.previous.next = delim.next;
        }
        if (delim.next == null) {
            this.lastDelimiter = delim.previous;
        } else {
            delim.next.previous = delim.previous;
        }
    }

    private void mergeTextNodesBetweenExclusive(Node fromNode, Node toNode) {
        if (fromNode == toNode || fromNode.getNext() == toNode) {
            return;
        }
        this.mergeTextNodesInclusive(fromNode.getNext(), toNode.getPrevious());
    }

    private void mergeChildTextNodes(Node node) {
        if (node.getFirstChild() == node.getLastChild()) {
            return;
        }
        this.mergeTextNodesInclusive(node.getFirstChild(), node.getLastChild());
    }

    private void mergeTextNodesInclusive(Node fromNode, Node toNode) {
        Text first = null;
        Text last = null;
        int length = 0;
        for (Node node = fromNode; node != null; node = node.getNext()) {
            if (node instanceof Text) {
                Text text = (Text)node;
                if (first == null) {
                    first = text;
                }
                length += text.getLiteral().length();
                last = text;
            } else {
                this.mergeIfNeeded(first, last, length);
                first = null;
                last = null;
                length = 0;
            }
            if (node == toNode) break;
        }
        this.mergeIfNeeded(first, last, length);
    }

    private void mergeIfNeeded(Text first, Text last, int textLength) {
        if (first != null && last != null && first != last) {
            StringBuilder sb = new StringBuilder(textLength);
            sb.append(first.getLiteral());
            Node stop = last.getNext();
            for (Node node = first.getNext(); node != stop; node = node.getNext()) {
                sb.append(((Text)node).getLiteral());
                Node unlink = node;
                unlink.unlink();
            }
            String literal = sb.toString();
            first.setLiteral(literal);
        }
    }

    private static class DelimiterData {
        final int count;
        final boolean canClose;
        final boolean canOpen;

        DelimiterData(int count, boolean canOpen, boolean canClose) {
            this.count = count;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }
    }
}

