/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.config.util;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.etrice.core.common.base.LiteralType;
import org.eclipse.etrice.core.config.ActorInstanceConfig;
import org.eclipse.etrice.core.config.PortInstanceConfig;
import org.eclipse.etrice.core.config.RefPath;
import org.eclipse.etrice.core.config.RefSegment;
import org.eclipse.etrice.core.config.SubSystemConfig;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.ActorContainerRef;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.DataClass;
import org.eclipse.etrice.core.room.DataType;
import org.eclipse.etrice.core.room.EnumerationType;
import org.eclipse.etrice.core.room.ExternalPort;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortClass;
import org.eclipse.etrice.core.room.PrimitiveType;
import org.eclipse.etrice.core.room.ProtocolClass;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.StructureClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.core.room.util.RoomHelpers;

public class ConfigUtil {
    @Inject
    private RoomHelpers roomHelpers;

    public LiteralType getLiteralType(Attribute attr) {
        DataType type;
        if (attr == null) {
            return null;
        }
        if (attr.getType() != null && (type = attr.getType().getType()) instanceof PrimitiveType) {
            return ((PrimitiveType)type).getType();
        }
        return null;
    }

    public ActorClass resolve(ActorContainerClass root, RefPath path) {
        if (path.getRefs().isEmpty()) {
            return null;
        }
        ActorContainerClass result = root;
        for (RefSegment ref : path.getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : this.roomHelpers.getRefs((StructureClass)result, true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref.getRef())) continue;
                match = (ActorRef)actor;
                if (!(match.getMultiplicity() == 1 ? ref.getIdx() != -1 : ref.getIdx() < 0 || ref.getIdx() >= match.getMultiplicity())) break;
                return null;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
        }
        return (ActorClass)result;
    }

    public ActorRef getLastActorRef(ActorContainerClass root, RefPath path) {
        if (path.getRefs().isEmpty()) {
            return null;
        }
        ActorRef lastMatch = null;
        ActorContainerClass result = root;
        for (RefSegment ref : path.getRefs()) {
            ActorRef match = null;
            for (ActorContainerRef actor : this.roomHelpers.getRefs((StructureClass)result, true)) {
                if (!(actor instanceof ActorRef) || !actor.getName().equals(ref.getRef())) continue;
                match = (ActorRef)actor;
                break;
            }
            if (match == null) {
                return null;
            }
            result = match.getType();
            lastMatch = match;
        }
        return lastMatch;
    }

    public String checkPath(ActorContainerClass root, RefPath path) {
        if (path == null) {
            return null;
        }
        ActorContainerClass last = root;
        Iterator it = path.getRefs().iterator();
        while (it.hasNext()) {
            RefSegment ref = (RefSegment)it.next();
            ActorRef match = null;
            for (ActorRef actor : last.getActorRefs()) {
                if (!actor.getName().equals(ref.getRef())) continue;
                match = actor;
                break;
            }
            ArrayList ifs = new ArrayList();
            ifs.addAll(last.getServiceProvisionPoints());
            if (last instanceof ActorClass) {
                ActorClass actor = (ActorClass)last;
                ifs.addAll(actor.getInterfacePorts());
                ifs.addAll(actor.getInternalPorts());
            }
            if (last instanceof SubSystemClass) {
                ifs.addAll(((SubSystemClass)last).getRelayPorts());
            }
            for (InterfaceItem item : ifs) {
                if (!item.getName().equals(ref.getRef()) || it.hasNext()) continue;
                return null;
            }
            if (match == null) {
                return ref.getRef();
            }
            if (match.getMultiplicity() == 1) {
                if (ref.getIdx() != -1) {
                    return String.valueOf(ref.toString()) + " (ref not indexed )";
                }
            } else {
                if (ref.getIdx() < 0) {
                    return String.valueOf(ref.toString()) + " (ref needs index)";
                }
                if (ref.getIdx() >= match.getMultiplicity()) {
                    return String.valueOf(ref.toString()) + " (index out of bounds)";
                }
            }
            last = match.getType();
        }
        return null;
    }

    public PortClass getPortClass(PortInstanceConfig config) {
        ProtocolClass protocol;
        InterfaceItem item = config.getItem();
        PortClass portClass = null;
        if (item instanceof Port) {
            Port port = (Port)item;
            if (port.getProtocol() instanceof ProtocolClass) {
                ProtocolClass protocol2 = port.getProtocol();
                portClass = port.isConjugated() ? protocol2.getConjugated() : protocol2.getRegular();
            }
        } else if (item instanceof SAP && (protocol = ((SAP)item).getProtocol()).getConjugated() != null) {
            portClass = protocol.getConjugated();
        }
        return portClass;
    }

    public List<InterfaceItem> getConfigurableInterfaceItems(ActorContainerClass acc, boolean includeInherited) {
        ArrayList<InterfaceItem> result = new ArrayList<InterfaceItem>();
        if (acc instanceof ActorClass) {
            ActorClass ac = (ActorClass)acc;
            do {
                result.addAll((Collection<InterfaceItem>)ac.getInternalPorts());
                result.addAll((Collection<InterfaceItem>)ac.getServiceAccessPoints());
                for (ExternalPort ext : ac.getExternalPorts()) {
                    result.add((InterfaceItem)ext.getInterfacePort());
                }
                ac = ac.getActorBase();
            } while (includeInherited && ac != null);
        } else {
            boolean cfr_ignored_0 = acc instanceof SubSystemClass;
        }
        return result;
    }

    public String getPath(ActorInstanceConfig config) {
        String path = "/" + config.getRoot().getName() + "/" + config.getSubSystem().getName();
        for (RefSegment s : config.getPath().getRefs()) {
            path = String.valueOf(path) + "/" + s;
        }
        return path;
    }

    public String getPath(SubSystemConfig config) {
        return "/" + config.getRoot().getName() + "/" + config.getSubSystem().getName();
    }

    public List<Attribute> filterConfigurableAttributes(List<Attribute> attributes) {
        ArrayList<Attribute> result = new ArrayList<Attribute>();
        for (Attribute a : attributes) {
            DataType type;
            if (a.getType().isRef() || !((type = a.getType().getType()) instanceof PrimitiveType) && !(type instanceof EnumerationType) && (!(type instanceof DataClass) || a.getSize() != 0)) continue;
            result.add(a);
        }
        return result;
    }
}

