/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.ui.behavior.fsm.editor;

import java.io.File;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ModelComponent;
import org.eclipse.etrice.core.fsm.fSM.State;
import org.eclipse.etrice.core.fsm.fSM.StateGraph;
import org.eclipse.etrice.core.fsm.naming.FSMQualifiedNameProvider;
import org.eclipse.etrice.ui.behavior.fsm.editor.AbstractFSMEditor;
import org.eclipse.etrice.ui.behavior.fsm.support.util.FSMSupportUtil;
import org.eclipse.etrice.ui.common.base.editor.DiagramEditorBase;
import org.eclipse.etrice.ui.common.base.export.DiagramExporter;
import org.eclipse.etrice.ui.common.base.export.IBulkDiagramExporter;
import org.eclipse.etrice.ui.common.base.support.DiagramAccessBase;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class BehaviorExporter
implements IBulkDiagramExporter {
    private static final String SUFFIX = "_behavior";
    private DiagramAccessBase da;

    public BehaviorExporter(DiagramAccessBase da) {
        this.da = da;
    }

    public void export(EObject roomClass, String folder) {
        boolean wasOpen = false;
        AbstractFSMEditor editor = (AbstractFSMEditor)this.da.findDiagramEditor(roomClass);
        if (editor != null) {
            wasOpen = true;
        } else {
            editor = (AbstractFSMEditor)this.da.openDiagramEditor(roomClass);
        }
        ModelComponent mc = editor.getModelComponent();
        if (editor != null) {
            FSMQualifiedNameProvider nameProvider = FSMSupportUtil.getInstance().getFSMQualifiedNameProvider();
            String basepath = String.valueOf(folder) + File.separatorChar + nameProvider.getFullyQualifiedName((EObject)mc);
            String filename = String.valueOf(basepath) + SUFFIX;
            DiagramExporter.export((DiagramEditorBase)editor, (String)filename);
            this.exportSubGraphsRecursively(mc.getStateMachine(), editor, basepath);
            if (!wasOpen) {
                PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)editor, false);
            }
        }
    }

    private void exportSubGraphsRecursively(StateGraph sg, AbstractFSMEditor editor, String basename) {
        if (sg == null) {
            return;
        }
        for (State state : sg.getStates()) {
            if (!FSMSupportUtil.getInstance().getFSMHelpers().hasDirectSubStructure(state)) continue;
            if (editor.showStateGraph(state.getSubgraph())) {
                String filename = String.valueOf(basename) + "." + FSMSupportUtil.getInstance().getFSMNameProvider().getStatePathName(state) + SUFFIX;
                DiagramExporter.export((DiagramEditorBase)editor, (String)filename);
            }
            this.exportSubGraphsRecursively(state.getSubgraph(), editor, basename);
        }
    }
}

