/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.c.gen;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.etrice.core.fsm.fSM.ComponentCommunicationType;
import org.eclipse.etrice.core.genmodel.etricegen.ExpandedActorClass;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.fsm.FsmGenExtensions;
import org.eclipse.etrice.core.genmodel.fsm.fsmgen.Graph;
import org.eclipse.etrice.core.room.ActorClass;
import org.eclipse.etrice.core.room.ActorContainerClass;
import org.eclipse.etrice.core.room.Attribute;
import org.eclipse.etrice.core.room.CommunicationType;
import org.eclipse.etrice.core.room.InterfaceItem;
import org.eclipse.etrice.core.room.Message;
import org.eclipse.etrice.core.room.MessageData;
import org.eclipse.etrice.core.room.Operation;
import org.eclipse.etrice.core.room.Port;
import org.eclipse.etrice.core.room.PortOperation;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.RoomElement;
import org.eclipse.etrice.core.room.RoomModel;
import org.eclipse.etrice.core.room.SAP;
import org.eclipse.etrice.core.room.ServiceImplementation;
import org.eclipse.etrice.core.room.StandardOperation;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.base.logging.ILogger;
import org.eclipse.etrice.generator.c.gen.CExtensions;
import org.eclipse.etrice.generator.c.gen.StateMachineGen;
import org.eclipse.etrice.generator.c.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.generic.GenericActorClassGenerator;
import org.eclipse.etrice.generator.generic.ILanguageExtension;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class ActorClassGen
extends GenericActorClassGenerator {
    @Inject
    @Extension
    protected CExtensions _cExtensions;
    @Inject
    @Extension
    protected ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    protected StateMachineGen _stateMachineGen;
    @Inject
    @Extension
    protected GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    protected ILanguageExtension langExt;
    @Inject
    protected IGeneratorFileIO fileIO;
    @Inject
    protected ILogger logger;

    public void doGenerate(Root root) {
        Functions.Function1 function1 = it -> {
            boolean bl = this._roomHelpers.isDeprecatedGeneration((RoomElement)it);
            return !bl;
        };
        Functions.Function1 function12 = it -> root.getExpandedActorClass(it);
        Consumer<ExpandedActorClass> consumer = xpac -> {
            String path = this._roomExtensions.getPath((RoomClass)xpac.getActorClass());
            String file = this._cExtensions.getCHeaderFileName((RoomClass)xpac.getActorClass());
            this.fileIO.generateFile("generating ActorClass header", path + file, this.generateHeaderFile(root, (ExpandedActorClass)xpac));
            file = this._cExtensions.getCUtilsFileName((RoomClass)xpac.getActorClass());
            this.fileIO.generateFile("generating ActorClass utils", path + file, this.generateUtilsFile(root, (ExpandedActorClass)xpac));
            boolean bl = this._roomHelpers.isBehaviorAnnotationPresent(xpac.getActorClass(), "BehaviorManual");
            if (bl) {
                String string = xpac.getActorClass().getName();
                String string2 = "omitting ActorClass source for '" + string;
                String string3 = string2 + "' since @BehaviorManual is specified";
                this.logger.logInfo(string3);
            } else {
                file = this._cExtensions.getCSourceFileName((RoomClass)xpac.getActorClass());
                this.fileIO.generateFile("generating ActorClass source", path + file, this.generateSourceFile(root, (ExpandedActorClass)xpac));
            }
        };
        IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)root.getActorClasses(), (Functions.Function1)function1), (Functions.Function1)function12).forEach(consumer);
    }

    protected CharSequence generateHeaderFile(Root root, ExpandedActorClass xpac) {
        Object object;
        CharSequence charSequence;
        String string;
        String string2;
        String string3;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1 function1 = it -> {
            CommunicationType communicationType = it.getProtocol().getCommType();
            return Objects.equals(communicationType, CommunicationType.EVENT_DRIVEN);
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function1);
        Functions.Function1 function12 = it -> Objects.equals(it.getProtocol().getCommType(), CommunicationType.DATA_DRIVEN) && it.isConjugated();
        Iterable sendPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function12);
        Functions.Function1 function13 = it -> Objects.equals(it.getProtocol().getCommType(), CommunicationType.DATA_DRIVEN) && !it.isConjugated();
        Iterable recvPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function13);
        ComponentCommunicationType componentCommunicationType = ac.getCommType();
        boolean dataDriven = Objects.equals(componentCommunicationType, ComponentCommunicationType.DATA_DRIVEN);
        ComponentCommunicationType componentCommunicationType2 = ac.getCommType();
        boolean async = Objects.equals(componentCommunicationType2, ComponentCommunicationType.ASYNCHRONOUS);
        boolean hasConstData = !IterableExtensions.isEmpty((Iterable)eventPorts) || !IterableExtensions.isEmpty((Iterable)recvPorts) || !this._roomHelpers.getAllSAPs(ac).isEmpty() || !this._roomHelpers.getAllServiceImplementations(ac).isEmpty();
        boolean isEmptyStateGraph = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of ActorClass ");
        String string4 = ac.getName();
        stringConcatenation2.append(string4, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence2 = this._cExtensions.generateIncludeGuardBegin((RoomClass)ac);
        stringConcatenation2.append((Object)charSequence2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"modelbase/etActor.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* include all referenced room classes */");
        stringConcatenation2.newLine();
        Object object2 = root.getReferencedDataClasses((RoomClass)ac);
        Object object3 = root.getReferencedEnumClasses((RoomClass)ac);
        Object object4 = Iterables.concat((Iterable)object2, (Iterable)object3);
        Object object5 = root.getReferencedProtocolClasses((RoomClass)ac);
        Functions.Function1 function14 = it -> this._cExtensions.getIncludePath((RoomClass)it);
        Object object6 = IterableExtensions.sort((Iterable)IterableExtensions.map((Iterable)Iterables.concat((Iterable)object4, (Iterable)object5), (Functions.Function1)function14));
        Object object7 = object6.iterator();
        while (object7.hasNext()) {
            String path = (String)object7.next();
            stringConcatenation2.append("#include ");
            stringConcatenation2.append(path);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object2 = this._procedureHelpers.userCode((ActorContainerClass)ac, 1, true);
        stringConcatenation2.append(object2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("typedef struct ");
        object3 = ac.getName();
        stringConcatenation2.append((String)object3);
        stringConcatenation2.append(" ");
        object4 = ac.getName();
        stringConcatenation2.append((String)object4);
        stringConcatenation2.append(";");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* const part of ActorClass (ROM) */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("typedef struct ");
        object5 = ac.getName();
        stringConcatenation2.append((String)object5);
        stringConcatenation2.append("_const {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#ifdef ET_MSC_LOGGER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("const char* instName;");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        boolean bl = xpac.isTracingEnabled();
        if (bl) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#if defined ET_MSC_TRACER_ACTIVATE || defined ET_MSC_LOGGER_ACTIVATE");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("etInt16 objId;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        if (!hasConstData) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#if !defined(ET_MSC_LOGGER_ACTIVATE) ");
            bl = xpac.isTracingEnabled();
            if (bl) {
                stringConcatenation2.append("&& !defined(ET_MSC_TRACER_ACTIVATE)");
            }
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("/* This actor class has no const data. To keep this case simple we introduce this dummy variable. */");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("int dummy;");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("#endif");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* simple ports */");
        stringConcatenation2.newLine();
        for (Port ep : eventPorts) {
            boolean bl2;
            int n = ep.getMultiplicity();
            boolean bl3 = bl2 = n == 1;
            if (!bl2) continue;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const ");
            string3 = this._roomExtensions.getPortClassName((RoomElement)ep);
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(" ");
            string2 = ep.getName();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* data receive ports */");
        stringConcatenation2.newLine();
        for (Port ep_1 : recvPorts) {
            boolean bl4;
            int n = ep_1.getMultiplicity();
            boolean bl5 = bl4 = n == 1;
            if (!bl4) continue;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const ");
            string3 = this._roomExtensions.getPortClassName((RoomElement)ep_1);
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(" ");
            string2 = ep_1.getName();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* saps */");
        stringConcatenation2.newLine();
        Object object8 = this._roomHelpers.getAllSAPs(ac);
        Object object9 = object8.iterator();
        while (object9.hasNext()) {
            SAP sap = (SAP)object9.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const ");
            object7 = this._roomExtensions.getPortClassName((RoomElement)sap);
            stringConcatenation2.append((String)object7, "\t");
            stringConcatenation2.append(" ");
            string3 = sap.getName();
            stringConcatenation2.append(string3, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* replicated ports */");
        stringConcatenation2.newLine();
        object8 = this._roomHelpers.getAllEndPorts(ac);
        object9 = object8.iterator();
        while (object9.hasNext()) {
            boolean bl6;
            Port ep_2 = (Port)object9.next();
            int n = ep_2.getMultiplicity();
            boolean bl7 = bl6 = n != 1;
            if (!bl6) continue;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const etReplPort ");
            string2 = ep_2.getName();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* services */");
        stringConcatenation2.newLine();
        object8 = this._roomHelpers.getAllServiceImplementations(ac);
        object9 = object8.iterator();
        while (object9.hasNext()) {
            ServiceImplementation svc = (ServiceImplementation)object9.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("const etReplPort ");
            String string5 = svc.getSpp().getName();
            stringConcatenation2.append(string5, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("} ");
        object8 = ac.getName();
        stringConcatenation2.append((String)object8);
        stringConcatenation2.append("_const;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (!isEmptyStateGraph) {
            stringConcatenation2.newLine();
            object6 = this._stateMachineGen.genHeaderConstants(xpac);
            stringConcatenation2.append(object6);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* variable part of ActorClass (RAM) */");
        stringConcatenation2.newLine();
        stringConcatenation2.append("struct ");
        object6 = ac.getName();
        stringConcatenation2.append((String)object6);
        stringConcatenation2.append(" {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("const ");
        object9 = ac.getName();
        stringConcatenation2.append((String)object9, "\t");
        stringConcatenation2.append("_const* ET_CONST_MEMBER constData;");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("/* data send ports */");
        stringConcatenation2.newLine();
        for (Port ep_3 : sendPorts) {
            boolean bl8;
            int n = ep_3.getMultiplicity();
            boolean bl9 = bl8 = n == 1;
            if (!bl8) continue;
            stringConcatenation2.append("\t");
            string = this._roomExtensions.getPortClassName((RoomElement)ep_3);
            stringConcatenation2.append(string, "\t");
            stringConcatenation2.append(" ");
            charSequence = ep_3.getName();
            stringConcatenation2.append(charSequence, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        CharSequence charSequence3 = this._procedureHelpers.attributes(this._roomHelpers.getAllAttributes(ac));
        stringConcatenation2.append((Object)charSequence3, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (!isEmptyStateGraph) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            object = this._stateMachineGen.genDataMembers(xpac);
            stringConcatenation2.append(object, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        object = ac.getName();
        stringConcatenation2.append((String)object);
        stringConcatenation2.append("_init(");
        String string6 = ac.getName();
        stringConcatenation2.append(string6);
        stringConcatenation2.append("* self);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        String string7 = ac.getName();
        stringConcatenation2.append(string7);
        stringConcatenation2.append("_receiveMessage(void* self, const void* ifitem, const etMessage* msg);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (dataDriven || async) {
            stringConcatenation2.append("void ");
            string = ac.getName();
            stringConcatenation2.append(string);
            stringConcatenation2.append("_execute(");
            charSequence = ac.getName();
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append("* self);");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        string = this._procedureHelpers.userStructorsDeclaration((RoomClass)ac);
        stringConcatenation2.append(string);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        charSequence = this._procedureHelpers.operationsDeclaration(this._roomHelpers.getLatestOperations(ac), ac.getName());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence4 = this._procedureHelpers.userCode((ActorContainerClass)ac, 2, true);
        stringConcatenation2.append((Object)charSequence4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence5 = this._cExtensions.generateIncludeGuardEnd((RoomClass)ac);
        stringConcatenation2.append((Object)charSequence5);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    protected CharSequence generateUtilsFile(Root root, ExpandedActorClass xpac) {
        String params;
        CharSequence charSequence;
        String string;
        String string2;
        String string3;
        String string4;
        Object object;
        String string5;
        boolean sap2;
        String string6;
        Object object2;
        Object ep_42;
        EList eList;
        CharSequence charSequence2;
        CharSequence charSequence3;
        CharSequence charSequence4;
        String string7;
        String string8;
        Object object3;
        String string9;
        String string10;
        Object object4;
        boolean bl;
        boolean bl2;
        Object object5;
        String string11;
        Object msg;
        Object object6;
        Object object7;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        Functions.Function1 function1 = it -> {
            CommunicationType communicationType = it.getProtocol().getCommType();
            return Objects.equals(communicationType, CommunicationType.EVENT_DRIVEN);
        };
        Iterable eventPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function1);
        Functions.Function1 function12 = it -> {
            int n = it.getMultiplicity();
            return n != 1;
        };
        Iterable replEventPorts = IterableExtensions.filter((Iterable)eventPorts, (Functions.Function1)function12);
        Functions.Function1 function13 = it -> Objects.equals(it.getProtocol().getCommType(), CommunicationType.DATA_DRIVEN) && it.isConjugated() && it.getMultiplicity() == 1;
        Iterable sendPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function13);
        Functions.Function1 function14 = it -> Objects.equals(it.getProtocol().getCommType(), CommunicationType.DATA_DRIVEN) && !it.isConjugated() && it.getMultiplicity() == 1;
        Iterable recvPorts = IterableExtensions.filter((Iterable)this._roomHelpers.getAllEndPorts(ac), (Functions.Function1)function14);
        Functions.Function1 function15 = p -> this._roomHelpers.getPortClass(p) != null && this._roomHelpers.getPortClass(p).getOperations().size() > 0;
        Iterable portsWithOperations = IterableExtensions.filter((Iterable)this._roomHelpers.getAllInterfaceItems(ac), (Functions.Function1)function15);
        EObject eObject = ac.eContainer();
        String string12 = ((RoomModel)eObject).getName().replaceAll("\\.", "_");
        String string13 = string12 + "_";
        String string14 = ac.getName();
        String string15 = string13 + string14;
        String filename = string15 + "_Utils";
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Utils File of ActorClass ");
        String string16 = ac.getName();
        stringConcatenation2.append(string16, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence5 = this._cExtensions.generateIncludeGuardBegin(filename);
        stringConcatenation2.append((Object)charSequence5);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include ");
        String string17 = this._cExtensions.getIncludePath((RoomClass)ac);
        stringConcatenation2.append(string17);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* access macros for ports, operations and attributes");
        stringConcatenation2.newLine();
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* simple event ports */");
        stringConcatenation2.newLine();
        Functions.Function1 function16 = it -> {
            int n = it.getMultiplicity();
            return n == 1;
        };
        Iterator iterator = IterableExtensions.filter((Iterable)eventPorts, (Functions.Function1)function16);
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Port ep = (Port)iterator2.next();
            object7 = this._roomHelpers.getOutgoing((InterfaceItem)ep);
            object6 = object7.iterator();
            while (object6.hasNext()) {
                msg = (Message)object6.next();
                string11 = null;
                object5 = msg.getData();
                boolean bl3 = bl2 = object5 != null;
                if (bl2) {
                    string11 = "data";
                }
                String data1 = string11;
                stringConcatenation2.newLineIfNotEmpty();
                String string18 = null;
                MessageData messageData = msg.getData();
                boolean bl4 = bl = messageData != null;
                if (bl) {
                    string18 = ", data";
                }
                String data2 = string18;
                stringConcatenation2.newLineIfNotEmpty();
                object4 = new StringConcatenation();
                string10 = ep.getName();
                object4.append(string10);
                object4.append("_");
                string9 = msg.getName();
                object4.append(string9);
                object4.append("(");
                object4.append(data1);
                object4.append(")");
                object3 = new StringConcatenation();
                string8 = this._roomExtensions.getPortClassName((RoomElement)ep);
                object3.append(string8);
                object3.append("_");
                string7 = msg.getName();
                object3.append(string7);
                object3.append("(&self->constData->");
                charSequence4 = ep.getName();
                object3.append(charSequence4);
                object3.append(data2);
                object3.append(")");
                charSequence3 = this.tracingCall(xpac, (InterfaceItem)ep, false, (Message)msg, false);
                charSequence2 = this.generateDefine(object4.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{object3.toString(), charSequence3})));
                stringConcatenation2.append((Object)charSequence2);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data receive ports */");
        stringConcatenation2.newLine();
        for (Port ep_1 : recvPorts) {
            eList = this._roomHelpers.getIncoming((InterfaceItem)ep_1);
            for (Message msg_1 : eList) {
                stringConcatenation2.append("#define ");
                msg = ep_1.getName();
                stringConcatenation2.append((String)msg);
                stringConcatenation2.append("_");
                object6 = msg_1.getName();
                stringConcatenation2.append((String)object6);
                stringConcatenation2.append(" ");
                string11 = this._roomExtensions.getPortClassName((RoomElement)ep_1);
                stringConcatenation2.append(string11);
                stringConcatenation2.append("_");
                object5 = msg_1.getName();
                stringConcatenation2.append((String)object5);
                stringConcatenation2.append("_get(&self->constData->");
                String string19 = ep_1.getName();
                stringConcatenation2.append(string19);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* data send ports */");
        stringConcatenation2.newLine();
        for (Object ep_42 : sendPorts) {
            eList = this._roomHelpers.getOutgoing((InterfaceItem)ep_42);
            for (Object msg_2 : eList) {
                boolean bl5;
                boolean bl6;
                msg = null;
                object6 = msg_2.getData();
                boolean bl7 = bl6 = object6 != null;
                if (bl6) {
                    msg = "data";
                }
                Object data1_1 = msg;
                stringConcatenation2.newLineIfNotEmpty();
                String string20 = null;
                object2 = msg_2.getData();
                boolean bl8 = bl5 = object2 != null;
                if (bl5) {
                    string20 = ", data";
                }
                String data2_1 = string20;
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                String string21 = ep_42.getName();
                stringConcatenation2.append(string21);
                stringConcatenation2.append("_");
                string6 = msg_2.getName();
                stringConcatenation2.append(string6);
                stringConcatenation2.append("(");
                stringConcatenation2.append((String)data1_1);
                stringConcatenation2.append(") ");
                object4 = this._roomExtensions.getPortClassName((RoomElement)ep_42);
                stringConcatenation2.append((String)object4);
                stringConcatenation2.append("_");
                string10 = msg_2.getName();
                stringConcatenation2.append(string10);
                stringConcatenation2.append("_set(&self->");
                string9 = ep_42.getName();
                stringConcatenation2.append(string9);
                stringConcatenation2.append(data2_1);
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* saps */");
        stringConcatenation2.newLine();
        ep_42 = this._roomHelpers.getAllSAPs(ac);
        eList = ep_42.iterator();
        while (eList.hasNext()) {
            Object msg_2;
            SAP sap2 = (SAP)eList.next();
            msg_2 = this._roomHelpers.getOutgoing((InterfaceItem)sap2);
            msg = msg_2.iterator();
            while (msg.hasNext()) {
                boolean data2_1;
                boolean data1_1;
                Message msg_3 = (Message)msg.next();
                object6 = null;
                MessageData messageData = msg_3.getData();
                boolean bl9 = data1_1 = messageData != null;
                if (data1_1) {
                    object6 = "data";
                }
                Object data1_2 = object6;
                stringConcatenation2.newLineIfNotEmpty();
                object2 = null;
                MessageData messageData2 = msg_3.getData();
                boolean bl10 = data2_1 = messageData2 != null;
                if (data2_1) {
                    object2 = ", data";
                }
                MessageData data2_2 = object2;
                stringConcatenation2.newLineIfNotEmpty();
                string6 = new StringConcatenation();
                object4 = sap2.getName();
                string6.append((String)object4);
                string6.append("_");
                string10 = msg_3.getName();
                string6.append(string10);
                string6.append("(");
                string6.append((String)data1_2);
                string6.append(")");
                string9 = new StringConcatenation();
                object3 = this._roomExtensions.getPortClassName((RoomElement)sap2);
                string9.append((String)object3);
                string9.append("_");
                string8 = msg_3.getName();
                string9.append(string8);
                string9.append("(&self->constData->");
                string7 = sap2.getName();
                string9.append(string7);
                string9.append((String)data2_2);
                string9.append(")");
                charSequence4 = this.tracingCall(xpac, (InterfaceItem)sap2, false, msg_3, false);
                charSequence3 = this.generateDefine(string6.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{string9.toString(), charSequence4})));
                stringConcatenation2.append((Object)charSequence3);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* replicated event ports */");
        stringConcatenation2.newLine();
        boolean ep_42 = IterableExtensions.isEmpty((Iterable)replEventPorts);
        boolean bl11 = sap2 = !ep_42;
        if (sap2) {
            stringConcatenation2.append("#define ifitem_index (((etReplSubPort*)ifitem)->index)");
            stringConcatenation2.newLine();
        }
        for (Port ep_3 : replEventPorts) {
            eList = this._roomHelpers.getOutgoing((InterfaceItem)ep_3);
            for (Object msg_4 : eList) {
                boolean bl12;
                boolean bl13;
                msg = null;
                object6 = msg_4.getData();
                boolean bl14 = bl13 = object6 != null;
                if (bl13) {
                    msg = "data";
                }
                Object data1_3 = msg;
                stringConcatenation2.newLineIfNotEmpty();
                String data1_2 = null;
                object2 = msg_4.getData();
                boolean bl15 = bl12 = object2 != null;
                if (bl12) {
                    data1_2 = ", data";
                }
                String data2_3 = data1_2;
                stringConcatenation2.newLineIfNotEmpty();
                StringConcatenation data2_2 = new StringConcatenation();
                string6 = ep_3.getName();
                data2_2.append(string6);
                data2_2.append("_");
                object4 = msg_4.getName();
                data2_2.append((String)object4);
                data2_2.append("_broadcast(");
                data2_2.append((String)data1_3);
                data2_2.append(")");
                string10 = new StringConcatenation();
                string9 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                string10.append(string9);
                string10.append("_");
                object3 = msg_4.getName();
                string10.append((String)object3);
                string10.append("_broadcast(&self->constData->");
                string8 = ep_3.getName();
                string10.append(string8);
                string10.append(data2_3);
                string10.append(")");
                string7 = this.tracingCall(xpac, (InterfaceItem)ep_3, false, (Message)msg_4, true);
                charSequence4 = this.generateDefine(data2_2.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{string10.toString(), string7})));
                stringConcatenation2.append((Object)charSequence4);
                stringConcatenation2.newLineIfNotEmpty();
                charSequence3 = new StringConcatenation();
                charSequence2 = ep_3.getName();
                charSequence3.append((String)charSequence2);
                charSequence3.append("_");
                string5 = msg_4.getName();
                charSequence3.append(string5);
                charSequence3.append("(idx");
                charSequence3.append(data2_3);
                charSequence3.append(")");
                object = new StringConcatenation();
                string4 = this._roomExtensions.getPortClassName((RoomElement)ep_3);
                object.append(string4);
                object.append("_");
                string3 = msg_4.getName();
                object.append(string3);
                object.append("(&self->constData->");
                string2 = ep_3.getName();
                object.append(string2);
                object.append(", idx");
                object.append(data2_3);
                object.append(")");
                string = this.tracingCall(xpac, (InterfaceItem)ep_3, true, (Message)msg_4, false);
                charSequence = this.generateDefine(charSequence3.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{object.toString(), string})));
                stringConcatenation2.append((Object)charSequence);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* services */");
        stringConcatenation2.newLine();
        List ep_3 = this._roomHelpers.getAllServiceImplementations(ac);
        for (ServiceImplementation svc : ep_3) {
            Object msg_4;
            msg_4 = this._roomHelpers.getOutgoing((InterfaceItem)svc.getSpp());
            msg = msg_4.iterator();
            while (msg.hasNext()) {
                boolean bl16;
                boolean bl17;
                Message msg_5 = (Message)msg.next();
                object6 = null;
                MessageData messageData = msg_5.getData();
                boolean bl18 = bl17 = messageData != null;
                if (bl17) {
                    object6 = "data";
                }
                Object data1_4 = object6;
                stringConcatenation2.newLineIfNotEmpty();
                object2 = null;
                MessageData messageData3 = msg_5.getData();
                boolean bl19 = bl16 = messageData3 != null;
                if (bl16) {
                    object2 = ", data";
                }
                Object data2_4 = object2;
                stringConcatenation2.newLineIfNotEmpty();
                string6 = new StringConcatenation();
                object4 = svc.getSpp().getName();
                string6.append((String)object4);
                string6.append("_");
                string10 = msg_5.getName();
                string6.append(string10);
                string6.append("_broadcast(");
                string6.append((String)data1_4);
                string6.append(")");
                string9 = new StringConcatenation();
                object3 = this._roomExtensions.getPortClassName((RoomElement)svc.getSpp());
                string9.append((String)object3);
                string9.append("_");
                string8 = msg_5.getName();
                string9.append(string8);
                string9.append("_broadcast(&self->constData->");
                string7 = svc.getSpp().getName();
                string9.append(string7);
                string9.append((String)data2_4);
                string9.append(")");
                charSequence4 = this.tracingCall(xpac, (InterfaceItem)svc.getSpp(), false, msg_5, true);
                charSequence3 = this.generateDefine(string6.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{string9.toString(), charSequence4})));
                stringConcatenation2.append((Object)charSequence3);
                stringConcatenation2.newLineIfNotEmpty();
                charSequence2 = new StringConcatenation();
                string5 = svc.getSpp().getName();
                charSequence2.append(string5);
                charSequence2.append("_");
                object = msg_5.getName();
                charSequence2.append((String)object);
                charSequence2.append("(idx");
                charSequence2.append((String)data2_4);
                charSequence2.append(")");
                string4 = new StringConcatenation();
                string3 = this._roomExtensions.getPortClassName((RoomElement)svc.getSpp());
                string4.append(string3);
                string4.append("_");
                string2 = msg_5.getName();
                string4.append(string2);
                string4.append("(&self->constData->");
                string = svc.getSpp().getName();
                string4.append(string);
                string4.append(", idx");
                string4.append((String)data2_4);
                string4.append(")");
                charSequence = this.tracingCall(xpac, (InterfaceItem)svc.getSpp(), true, msg_5, false);
                CharSequence charSequence6 = this.generateDefine(charSequence2.toString(), Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{string4.toString(), charSequence})));
                stringConcatenation2.append((Object)charSequence6);
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* operations */");
        stringConcatenation2.newLine();
        ep_3 = this._roomHelpers.getLatestOperations(ac);
        for (StandardOperation op : ep_3) {
            params = this.operationParams((Operation)op);
            stringConcatenation2.newLineIfNotEmpty();
            String args = this.operationArgs((Operation)op);
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("#define ");
            msg = op.getName();
            stringConcatenation2.append((String)msg);
            stringConcatenation2.append("(");
            stringConcatenation2.append(params);
            stringConcatenation2.append(") ");
            object6 = ac.getName();
            stringConcatenation2.append((String)object6);
            stringConcatenation2.append("_");
            String string22 = op.getName();
            stringConcatenation2.append(string22);
            stringConcatenation2.append("(self");
            boolean bl20 = op.getArguments().isEmpty();
            boolean bl21 = bl2 = !bl20;
            if (bl2) {
                stringConcatenation2.append(", ");
                stringConcatenation2.append(args);
            }
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* attributes */");
        stringConcatenation2.newLine();
        ep_3 = this._roomHelpers.getAllAttributes(ac);
        for (Attribute a : ep_3) {
            stringConcatenation2.append("#define ");
            params = a.getName();
            stringConcatenation2.append(params);
            stringConcatenation2.append(" (self->");
            object7 = a.getName();
            stringConcatenation2.append((String)object7);
            stringConcatenation2.append(")");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* port operations */");
        stringConcatenation2.newLine();
        for (InterfaceItem p2 : portsWithOperations) {
            eList = this._roomHelpers.getPortClass(p2).getOperations();
            for (PortOperation op_1 : eList) {
                String params_1 = this.operationParams((Operation)op_1);
                stringConcatenation2.newLineIfNotEmpty();
                String args_1 = this.operationArgs((Operation)op_1);
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("#define ");
                String string23 = p2.getName();
                stringConcatenation2.append(string23);
                stringConcatenation2.append("_");
                String string24 = op_1.getName();
                stringConcatenation2.append(string24);
                stringConcatenation2.append("(");
                stringConcatenation2.append(params_1);
                stringConcatenation2.append(") ");
                String string25 = this._roomExtensions.getPortClassName((RoomElement)p2);
                stringConcatenation2.append(string25);
                stringConcatenation2.append("_");
                object2 = op_1.getName();
                stringConcatenation2.append((String)object2);
                stringConcatenation2.append("(&self->constData->");
                String string26 = p2.getName();
                stringConcatenation2.append(string26);
                boolean bl22 = op_1.getArguments().isEmpty();
                boolean bl23 = bl = !bl22;
                if (bl) {
                    stringConcatenation2.append(", ");
                    stringConcatenation2.append(args_1);
                }
                stringConcatenation2.append(")");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        CharSequence charSequence7 = this._cExtensions.generateIncludeGuardEnd(filename);
        stringConcatenation2.append((Object)charSequence7);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private CharSequence generateDefine(String sig, Iterable<String> lines) {
        String string;
        StringConcatenation stringConcatenation;
        boolean bl;
        StringConcatenation stringConcatenation2 = null;
        List filteredLines = IterableExtensions.toList((Iterable)IterableExtensions.filterNull(lines));
        StringConcatenation stringConcatenation3 = null;
        boolean bl2 = false;
        int n = filteredLines.size();
        boolean bl3 = bl = n > 1;
        if (bl) {
            boolean bl4;
            bl2 = true;
            stringConcatenation = new StringConcatenation();
            stringConcatenation.append("#define ");
            stringConcatenation.append(sig);
            stringConcatenation.append(" { ");
            string = (String)IterableExtensions.head((Iterable)filteredLines);
            stringConcatenation.append(string);
            int n2 = filteredLines.size();
            boolean bl5 = bl4 = n2 > 1;
            if (bl4) {
                stringConcatenation.append("; \\");
            }
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation.append("\t\t\t\t");
            String string2 = IterableExtensions.join((Iterable)IterableExtensions.tail((Iterable)filteredLines), (CharSequence)"; \\\n");
            stringConcatenation.append(string2, "\t\t\t\t");
            stringConcatenation.append(" }");
            stringConcatenation.newLineIfNotEmpty();
            stringConcatenation3 = stringConcatenation;
        }
        if (!bl2) {
            stringConcatenation = new StringConcatenation();
            stringConcatenation.append("#define ");
            stringConcatenation.append(sig);
            stringConcatenation.append(" ");
            string = (String)IterableExtensions.head((Iterable)filteredLines);
            stringConcatenation.append(string);
            stringConcatenation3 = stringConcatenation;
        }
        stringConcatenation2 = stringConcatenation3;
        return stringConcatenation2;
    }

    private String tracingCall(ExpandedActorClass xpac, InterfaceItem item, boolean idx, Message msg, boolean broadcast) {
        boolean bl = xpac.isTracingEnabled();
        if (bl) {
            String string;
            String string2;
            StringConcatenation stringConcatenation;
            String string3 = null;
            boolean bl2 = this._roomHelpers.isConjugated(item);
            string3 = bl2 ? "IN_" : "OUT_";
            String dir = string3;
            String string4 = null;
            boolean bl3 = false;
            if (idx) {
                bl3 = true;
                stringConcatenation = new StringConcatenation();
                stringConcatenation.append("((self->constData->");
                string2 = item.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(".size>(etInt16)idx) ? self->constData->");
                string = item.getName();
                stringConcatenation.append(string);
                stringConcatenation.append(".ports[idx].port.peerAddress : 1)");
                string4 = stringConcatenation.toString();
            }
            if (!bl3 && broadcast) {
                bl3 = true;
                stringConcatenation = new StringConcatenation();
                stringConcatenation.append("((self->constData->");
                string2 = item.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(".size > 0) ? self->constData->");
                string = item.getName();
                stringConcatenation.append(string);
                stringConcatenation.append(".ports[0].port.peerAddress : 1)");
                string4 = stringConcatenation.toString();
            }
            if (!bl3) {
                stringConcatenation = new StringConcatenation();
                stringConcatenation.append("self->constData->");
                string2 = item.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append(".peerAddress");
                string4 = stringConcatenation.toString();
            }
            String peerAddress = string4;
            string2 = null;
            string2 = broadcast ? "ET_MSC_TRACER_ASYNC_BCAST" : "ET_MSC_TRACER_ASYNC_OUT";
            String traceMacro = string2;
            StringConcatenation stringConcatenation2 = new StringConcatenation();
            stringConcatenation2.append(traceMacro);
            stringConcatenation2.append("(");
            stringConcatenation2.append(peerAddress);
            stringConcatenation2.append(", ");
            String string5 = item.getProtocol().getName();
            String string6 = msg.getName();
            String string7 = dir + string6;
            String string8 = this._cExtensions.memberInUse(string5, string7);
            stringConcatenation2.append(string8);
            stringConcatenation2.append(");");
            return stringConcatenation2.toString();
        }
        return null;
    }

    private String operationParams(Operation op) {
        Functions.Function1 function1 = it -> {
            String string = null;
            boolean bl = false;
            boolean bl2 = it.isVarargs();
            if (bl2) {
                bl = true;
                string = "...";
            }
            if (!bl) {
                string = it.getName();
            }
            return string;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    private String operationArgs(Operation op) {
        Functions.Function1 function1 = it -> {
            String string = null;
            boolean bl = false;
            boolean bl2 = it.isVarargs();
            if (bl2) {
                bl = true;
                string = "__VA_ARGS__";
            }
            if (!bl) {
                string = it.getName();
            }
            return string;
        };
        return IterableExtensions.join((Iterable)ListExtensions.map((List)op.getArguments(), (Functions.Function1)function1), (CharSequence)", ");
    }

    protected CharSequence generateSourceFile(Root root, ExpandedActorClass xpac) {
        CharSequence charSequence;
        String string;
        CharSequence charSequence2;
        StringConcatenation stringConcatenation = null;
        ActorClass ac = xpac.getActorClass();
        ComponentCommunicationType componentCommunicationType = ac.getCommType();
        boolean async = Objects.equals(componentCommunicationType, ComponentCommunicationType.ASYNCHRONOUS);
        ComponentCommunicationType componentCommunicationType2 = ac.getCommType();
        boolean eventDriven = Objects.equals(componentCommunicationType2, ComponentCommunicationType.EVENT_DRIVEN);
        ComponentCommunicationType componentCommunicationType3 = ac.getCommType();
        boolean dataDriven = Objects.equals(componentCommunicationType3, ComponentCommunicationType.DATA_DRIVEN);
        boolean handleEvents = async || eventDriven;
        boolean isEmptyStateGraph = FsmGenExtensions.isEmpty((Graph)xpac.getGraphContainer().getGraph());
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of ActorClass ");
        String string2 = ac.getName();
        stringConcatenation2.append(string2, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string3 = this._cExtensions.getCHeaderFileName((RoomClass)ac);
        stringConcatenation2.append(string3);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"debugging/etMSCLogger.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"etUnit/etUnit.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"base/etMemory.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#ifdef ET_MSC_TRACER_ACTIVATE");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("#include \"debugging/etMSCTracer.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#endif");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        Object object = it -> this._cExtensions.getIncludePath((RoomClass)it);
        Object object2 = IterableExtensions.sort((Iterable)ListExtensions.map((List)root.getReferencedProtocolClasses((RoomClass)ac), (Functions.Function1)object));
        Object object3 = object2.iterator();
        while (object3.hasNext()) {
            String path = (String)object3.next();
            stringConcatenation2.append("#include ");
            stringConcatenation2.append(path);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        object = this._cExtensions.getCUtilsFileName((RoomClass)ac);
        stringConcatenation2.append((String)object);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        object2 = this._procedureHelpers.userCode((ActorContainerClass)ac, 3, true);
        stringConcatenation2.append(object2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("/* interface item IDs */");
        stringConcatenation2.newLine();
        String string4 = this.genInterfaceItemConstants(xpac);
        stringConcatenation2.append(string4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        if (!isEmptyStateGraph) {
            object3 = this._stateMachineGen.genStateMachine(xpac.getGraphContainer());
            stringConcatenation2.append(object3);
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        object3 = ac.getName();
        stringConcatenation2.append((String)object3);
        stringConcatenation2.append("_init(");
        String string5 = ac.getName();
        stringConcatenation2.append(string5);
        stringConcatenation2.append("* self){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String string6 = ac.getName();
        stringConcatenation2.append(string6, "\t");
        stringConcatenation2.append("\", \"init\")");
        stringConcatenation2.newLineIfNotEmpty();
        if (!isEmptyStateGraph) {
            stringConcatenation2.append("\t");
            charSequence2 = this._stateMachineGen.genInitialization(xpac);
            stringConcatenation2.append((Object)charSequence2, "\t");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        charSequence2 = ac.getName();
        stringConcatenation2.append((String)charSequence2);
        stringConcatenation2.append("_receiveMessage(void* self, const void* ifitem, const etMessage* msg){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
        String string7 = ac.getName();
        stringConcatenation2.append(string7, "\t");
        stringConcatenation2.append("\", \"_receiveMessage\")");
        stringConcatenation2.newLineIfNotEmpty();
        if (!isEmptyStateGraph) {
            if (handleEvents) {
                stringConcatenation2.append("\t");
                boolean bl = xpac.isTracingEnabled();
                if (bl) {
                    stringConcatenation2.append("ET_MSC_TRACER_ASYNC_IN(((etPort*)ifitem)->peerAddress, msg->evtID);");
                }
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                string = this.langExt.operationScope(ac.getName(), false);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append("receiveEvent((");
                charSequence = ac.getName();
                stringConcatenation2.append(charSequence, "\t");
                stringConcatenation2.append("*) self, (etPort*)ifitem, msg->evtID, (void*)(((char*)msg)+MEM_CEIL(sizeof(etMessage))));");
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                stringConcatenation2.append("\t");
                string = this.langExt.operationScope(ac.getName(), false);
                stringConcatenation2.append(string, "\t");
                stringConcatenation2.append("receiveEventInternal((");
                charSequence = ac.getName();
                stringConcatenation2.append(charSequence, "\t");
                stringConcatenation2.append("*) self);");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
        stringConcatenation2.newLine();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        if (dataDriven || async) {
            stringConcatenation2.append("void ");
            string = ac.getName();
            stringConcatenation2.append(string);
            stringConcatenation2.append("_execute(");
            charSequence = ac.getName();
            stringConcatenation2.append(charSequence);
            stringConcatenation2.append("* self) {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_ENTRY(\"");
            String string8 = ac.getName();
            stringConcatenation2.append(string8, "\t");
            stringConcatenation2.append("\", \"_execute\")");
            stringConcatenation2.newLineIfNotEmpty();
            if (!isEmptyStateGraph) {
                stringConcatenation2.newLine();
                if (handleEvents) {
                    stringConcatenation2.append("\t");
                    String string9 = this.langExt.operationScope(ac.getName(), false);
                    stringConcatenation2.append(string9, "\t");
                    stringConcatenation2.append("receiveEvent(self, NULL, 0, NULL);");
                    stringConcatenation2.newLineIfNotEmpty();
                } else {
                    stringConcatenation2.append("\t");
                    String string10 = this.langExt.operationScope(ac.getName(), false);
                    stringConcatenation2.append(string10, "\t");
                    stringConcatenation2.append("receiveEventInternal(self);");
                    stringConcatenation2.newLineIfNotEmpty();
                }
            }
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("ET_MSC_LOGGER_SYNC_EXIT");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        string = this._procedureHelpers.userStructorsImplementation((RoomClass)ac);
        stringConcatenation2.append(string);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        charSequence = this._procedureHelpers.operationsImplementation(this._roomHelpers.getLatestOperations(ac), ac.getName());
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

