/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.doc;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.etrice.core.common.ui.hover.IKeywordHoverContentProvider;
import org.eclipse.etrice.doc.ETriceHelp;
import org.eclipse.xtext.util.Files;

public class KeywordHoverContentProvider
implements IKeywordHoverContentProvider {
    private static final String ROOM_LANGUAGE_REFERENCE = "docs/reference/room-language.md";
    private static final String KEYWORD_HOVER_FOLDER = "keyword-hover/";
    private final Map<String, String> keywordMdCache = new HashMap<String, String>();
    private String documentMdCache = null;

    public String getMdContent(String name) {
        if (this.keywordMdCache.containsKey(name)) {
            return this.keywordMdCache.get(name);
        }
        String result = null;
        try {
            URL fileURL = ETriceHelp.getDefault().getBundle().getEntry(KEYWORD_HOVER_FOLDER + name + ".md");
            if (fileURL != null) {
                result = Files.readStreamIntoString((InputStream)fileURL.openStream()).replace("\r\n", "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (result == null) {
            String documentation = this.getReferenceDocument();
            Pattern headingPattern = Pattern.compile("^ *(#+) +" + Pattern.quote(name) + "\\s+(.*)", 42);
            Matcher startMatcher = headingPattern.matcher(documentation);
            if (startMatcher.find()) {
                String content;
                int headingLevel = startMatcher.group(1).length();
                Pattern endPattern = Pattern.compile("(.*?)^ *#{1," + headingLevel + "}+\\s+", 40);
                Matcher endMatcher = endPattern.matcher(content = startMatcher.group(2).trim());
                result = endMatcher.find() ? endMatcher.group(1).trim() : content;
            }
        }
        this.keywordMdCache.put(name, result);
        return result;
    }

    private String getReferenceDocument() {
        if (this.documentMdCache == null) {
            try {
                URL fileURL = ETriceHelp.getDefault().getBundle().getEntry(ROOM_LANGUAGE_REFERENCE);
                this.documentMdCache = Files.readStreamIntoString((InputStream)fileURL.openStream()).replace("\r\n", "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
                this.documentMdCache = "";
            }
        }
        return this.documentMdCache;
    }
}

