/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.mgmt.framework.internal;

import java.io.IOException;
import java.util.HashMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.osgi.jmx.framework.FrameworkMBean;

public final class BundleBatchInstallResult {
    private Long[] completed;
    private String errorMessage;
    private boolean success = true;
    private String bundleInError;
    private String[] remaining;

    public BundleBatchInstallResult(Long[] completed) {
        this.success = true;
        this.completed = completed;
    }

    public BundleBatchInstallResult(String errorMessage, Long[] completed, String bundleInError, String[] remaining) {
        this.success = false;
        this.errorMessage = errorMessage;
        this.completed = completed;
        this.bundleInError = bundleInError;
        this.remaining = remaining;
    }

    public CompositeData asCompositeData() throws IOException {
        HashMap<String, Object> items = new HashMap<String, Object>();
        items.put("Success", this.success);
        items.put("Error", this.errorMessage);
        items.put("Completed", this.completed);
        items.put("BundleInError", this.bundleInError);
        items.put("Remaining", this.remaining);
        try {
            return new CompositeDataSupport(FrameworkMBean.BATCH_INSTALL_RESULT_TYPE, items);
        }
        catch (OpenDataException e) {
            IOException iox = new IOException("Cannot form batch result open data");
            iox.initCause(e);
            throw iox;
        }
    }
}

