/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.spi.DirObjectFactory;
import javax.naming.spi.DirectoryManager;
import javax.naming.spi.NamingManager;
import javax.naming.spi.ObjectFactory;
import javax.naming.spi.ObjectFactoryBuilder;
import org.eclipse.gemini.naming.BuilderUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.jndi.JNDIProviderAdmin;

class TraditionalObjectFactoryBuilder
implements ObjectFactoryBuilder {
    private static final String JNDI_PROVIDER_ADMIN_INTERFACE = JNDIProviderAdmin.class.getName();
    private static final String NAMING_MANAGER_CLASSNAME = NamingManager.class.getName();
    private static final String DIRECTORY_MANAGER_CLASSNAME = DirectoryManager.class.getName();

    public ObjectFactory createObjectFactory(Object obj, Hashtable environment) throws NamingException {
        BundleContext clientBundleContext = BuilderUtils.getBundleContext(environment, NAMING_MANAGER_CLASSNAME);
        if (clientBundleContext == null) {
            clientBundleContext = BuilderUtils.getBundleContext(environment, DIRECTORY_MANAGER_CLASSNAME);
        }
        return new TraditionalObjectFactory(clientBundleContext);
    }

    private static class DirectoryManagerAction
    extends NamingManagerAction {
        private final Attributes m_attributes;

        DirectoryManagerAction(Object refInfo, Name name, Context context, Hashtable environment, Attributes attributes) {
            super(refInfo, name, context, environment);
            this.m_attributes = attributes;
        }

        @Override
        public Object runProviderAdminAction(JNDIProviderAdmin providerAdmin) throws Exception {
            return providerAdmin.getObjectInstance(this.m_refInfo, this.m_name, this.m_context, this.m_environment, this.m_attributes);
        }
    }

    private static class NamingManagerAction
    implements ProviderAdminAction {
        protected final Object m_refInfo;
        protected final Name m_name;
        protected final Context m_context;
        protected final Hashtable m_environment;

        NamingManagerAction(Object refInfo, Name name, Context context, Hashtable environment) {
            this.m_refInfo = refInfo;
            this.m_name = name;
            this.m_context = context;
            this.m_environment = environment;
        }

        @Override
        public Object runProviderAdminAction(JNDIProviderAdmin providerAdmin) throws Exception {
            return providerAdmin.getObjectInstance(this.m_refInfo, this.m_name, this.m_context, this.m_environment);
        }
    }

    private static interface ProviderAdminAction {
        public Object runProviderAdminAction(JNDIProviderAdmin var1) throws Exception;
    }

    private static class TraditionalObjectFactory
    implements DirObjectFactory {
        private final BundleContext m_clientBundleContext;

        TraditionalObjectFactory(BundleContext clientBundleContext) {
            this.m_clientBundleContext = clientBundleContext;
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment) throws Exception {
            NamingManagerAction providerAdminAction = new NamingManagerAction(refInfo, name, context, environment);
            return this.resolveObjectWithProviderAdmin(providerAdminAction);
        }

        public Object getObjectInstance(Object refInfo, Name name, Context context, Hashtable environment, Attributes attributes) throws Exception {
            DirectoryManagerAction providerAdminAction = new DirectoryManagerAction(refInfo, name, context, environment, attributes);
            return this.resolveObjectWithProviderAdmin(providerAdminAction);
        }

        private Object resolveObjectWithProviderAdmin(ProviderAdminAction providerAdminAction) throws Exception {
            if (this.m_clientBundleContext == null) {
                throw new NamingException("Error in obtaining client's BundleContext");
            }
            ServiceReference serviceReference = this.m_clientBundleContext.getServiceReference(JNDI_PROVIDER_ADMIN_INTERFACE);
            if (serviceReference == null) {
                throw new NamingException("JNDIProviderAdmin service not available, cannot resolve object at this time");
            }
            JNDIProviderAdmin providerAdmin = (JNDIProviderAdmin)this.m_clientBundleContext.getService(serviceReference);
            if (providerAdmin == null) {
                throw new NamingException("JNDIProviderAdmin service not available, cannot resolve object at this time");
            }
            Object resolvedObject = providerAdminAction.runProviderAdminAction(providerAdmin);
            this.m_clientBundleContext.ungetService(serviceReference);
            return resolvedObject;
        }
    }
}

