/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.store.pop3;

import java.util.Vector;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.MethodNotSupportedException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.geronimo.javamail.store.pop3.POP3CommandFactory;
import org.apache.geronimo.javamail.store.pop3.POP3Connection;
import org.apache.geronimo.javamail.store.pop3.message.POP3Message;
import org.apache.geronimo.javamail.store.pop3.message.POP3MessageFactory;
import org.apache.geronimo.javamail.store.pop3.response.POP3ResponseFactory;
import org.apache.geronimo.javamail.store.pop3.response.POP3StatusResponse;

public class POP3Folder
extends Folder {
    private boolean isFolderOpen = false;
    private int mode;
    private POP3Connection pop3Con;
    private int msgCount;
    private Session session;
    private Vector msgCache;

    protected POP3Folder(Store store, URLName url) {
        super(store);
    }

    protected POP3Folder(Store store, Session session, POP3Connection pop3Con) {
        super(store);
        this.pop3Con = pop3Con;
        this.session = session;
    }

    public String getName() {
        return "INBOX";
    }

    public String getFullName() {
        return "INBOX";
    }

    public Folder getParent() throws MessagingException {
        throw new MethodNotSupportedException("INBOX is the root folder");
    }

    public boolean exists() throws MessagingException {
        return true;
    }

    public Folder[] list(String pattern) throws MessagingException {
        throw new MethodNotSupportedException("Only INBOX is supported in POP3, no sub folders");
    }

    public char getSeparator() throws MessagingException {
        throw new MethodNotSupportedException("Only INBOX is supported in POP3, no sub folders");
    }

    public int getType() throws MessagingException {
        return 1;
    }

    public boolean create(int type) throws MessagingException {
        throw new MethodNotSupportedException("Only INBOX is supported in POP3, no sub folders");
    }

    public boolean hasNewMessages() throws MessagingException {
        throw new MethodNotSupportedException("POP3 doesn't support this operation");
    }

    public Folder getFolder(String name) throws MessagingException {
        throw new MethodNotSupportedException("Only INBOX is supported in POP3, no sub folders");
    }

    public boolean delete(boolean recurse) throws MessagingException {
        throw new MethodNotSupportedException("Only INBOX is supported in POP3 and INBOX cannot be deleted");
    }

    public boolean renameTo(Folder f) throws MessagingException {
        throw new MethodNotSupportedException("Only INBOX is supported in POP3 and INBOX cannot be renamed");
    }

    public void open(int mode) throws MessagingException {
        this.checkClosed();
        try {
            POP3StatusResponse res = (POP3StatusResponse)POP3ResponseFactory.getStatusResponse(this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_STAT()));
            this.mode = mode;
            this.isFolderOpen = true;
            this.msgCount = res.getNumMessages();
            this.msgCache = new Vector(this.msgCount + 1);
            this.msgCache.setSize(this.msgCount + 1);
        }
        catch (Exception e) {
            throw new MessagingException("Unable to execute STAT command", e);
        }
        this.notifyConnectionListeners(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean expunge) throws MessagingException {
        this.checkOpen();
        try {
            if (this.mode == 2) {
                for (int i = 1; i < this.msgCache.size(); ++i) {
                    POP3Message m = (POP3Message)this.msgCache.elementAt(i);
                    if (m == null || !m.isSet(Flags.Flag.DELETED)) continue;
                    try {
                        this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_DELE(i + 1));
                        continue;
                    }
                    catch (Exception e) {
                        throw new MessagingException("Exception deleting message no [" + (i + 1) + "] during close", e);
                    }
                }
            }
            try {
                this.pop3Con.sendCommand(POP3CommandFactory.getCOMMAND_QUIT());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        finally {
            try {
                this.pop3Con.close();
            }
            catch (Exception e) {
                this.pop3Con = null;
            }
            this.msgCache = null;
            this.isFolderOpen = false;
            this.notifyConnectionListeners(3);
        }
    }

    public boolean isOpen() {
        return this.isFolderOpen;
    }

    public Flags getPermanentFlags() {
        return new Flags();
    }

    public int getMessageCount() throws MessagingException {
        return this.msgCount;
    }

    public Message getMessage(int msgNum) throws MessagingException {
        this.checkOpen();
        if (msgNum < 1 || msgNum > this.getMessageCount()) {
            throw new MessagingException("Invalid Message number");
        }
        Message msg = null;
        try {
            msg = (Message)this.msgCache.elementAt(msgNum);
        }
        catch (RuntimeException e) {
            this.session.getDebugOut().println("Message not in cache");
        }
        if (msg == null) {
            msg = POP3MessageFactory.createMessage(this, this.session, this.pop3Con, msgNum);
            this.msgCache.setElementAt(msg, msgNum);
        }
        return msg;
    }

    public void appendMessages(Message[] msgs) throws MessagingException {
        throw new MethodNotSupportedException("Message appending is not supported in POP3");
    }

    public Message[] expunge() throws MessagingException {
        throw new MethodNotSupportedException("Expunge is not supported in POP3");
    }

    public int getMode() throws IllegalStateException {
        this.checkOpen();
        return this.mode;
    }

    public void fetch(Message[] msgs, FetchProfile fp) throws MessagingException {
        this.checkOpen();
        for (int i = 0; i < msgs.length; ++i) {
            Message msg = msgs[i];
            if (msg == null) {
                msg = POP3MessageFactory.createMessage(this, this.session, this.pop3Con, i);
            }
            if (fp.contains(FetchProfile.Item.ENVELOPE)) {
                msg = POP3MessageFactory.createMessageWithEvelope((POP3Message)msg);
            }
            if (fp.contains(FetchProfile.Item.CONTENT_INFO)) {
                msg = POP3MessageFactory.createMessageWithContentInfo((POP3Message)msg);
            }
            if (fp.contains(FetchProfile.Item.FLAGS)) {
                msg = POP3MessageFactory.createMessageWithFlags((POP3Message)msg);
            }
            msgs[i] = msg;
        }
    }

    private void checkOpen() throws IllegalStateException {
        if (!this.isFolderOpen) {
            throw new IllegalStateException("Folder is not Open");
        }
    }

    private void checkClosed() throws IllegalStateException {
        if (this.isFolderOpen) {
            throw new IllegalStateException("Folder is Open");
        }
    }

    public void notifyMessageChangedListeners(int type, Message m) {
        super.notifyMessageChangedListeners(type, m);
    }
}

