/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.graph.impl;

import java.util.Collection;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.elk.graph.EMapPropertyHolder;
import org.eclipse.elk.graph.KGraphFactory;
import org.eclipse.elk.graph.KGraphPackage;
import org.eclipse.elk.graph.PersistentEntry;
import org.eclipse.elk.graph.impl.IPropertyToObjectMapImpl;
import org.eclipse.elk.graph.properties.IProperty;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.IPropertyValueProxy;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EObjectImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreEMap;
import org.eclipse.emf.ecore.util.InternalEList;

public abstract class EMapPropertyHolderImpl
extends EObjectImpl
implements EMapPropertyHolder {
    protected EMap<IProperty<?>, Object> properties;
    protected EList<PersistentEntry> persistentEntries;

    protected EMapPropertyHolderImpl() {
    }

    protected EClass eStaticClass() {
        return KGraphPackage.Literals.EMAP_PROPERTY_HOLDER;
    }

    @Override
    public EMap<IProperty<?>, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new EcoreEMap(KGraphPackage.Literals.IPROPERTY_TO_OBJECT_MAP, IPropertyToObjectMapImpl.class, (InternalEObject)this, 0);
        }
        return this.properties;
    }

    @Override
    public EList<PersistentEntry> getPersistentEntries() {
        if (this.persistentEntries == null) {
            this.persistentEntries = new EObjectContainmentEList(PersistentEntry.class, (InternalEObject)this, 1);
        }
        return this.persistentEntries;
    }

    @Override
    public void makePersistent() {
        boolean deliver = this.eDeliver();
        this.eSetDeliver(false);
        int i = 0;
        EList<PersistentEntry> persisEntries = this.getPersistentEntries();
        for (Map.Entry entry : this.getProperties()) {
            PersistentEntry persisEntry;
            IProperty key = (IProperty)entry.getKey();
            Object value = entry.getValue();
            if (key == null || value == null) continue;
            if (i >= persisEntries.size()) {
                persisEntry = KGraphFactory.eINSTANCE.createPersistentEntry();
                persisEntries.add(persisEntry);
                ++i;
            } else {
                persisEntry = (PersistentEntry)persisEntries.get(i++);
            }
            boolean pEdeliver = persisEntry.eDeliver();
            persisEntry.eSetDeliver(false);
            persisEntry.setKey(key.getId());
            persisEntry.setValue(value.toString());
            persisEntry.eSetDeliver(pEdeliver);
        }
        ListIterator peIt = persisEntries.listIterator(i);
        while (peIt.hasNext()) {
            peIt.next();
            peIt.remove();
        }
        this.eSetDeliver(deliver);
    }

    @Override
    public <T> IPropertyHolder setProperty(IProperty<? super T> property, T value) {
        if (value == null) {
            this.getProperties().removeKey(property);
        } else {
            this.getProperties().put(property, value);
        }
        return this;
    }

    @Override
    public <T> T getProperty(IProperty<T> property) {
        T defaultValue;
        Object value = this.getProperties().get(property);
        if (value instanceof IPropertyValueProxy) {
            if ((value = ((IPropertyValueProxy)value).resolveValue(property)) != null) {
                this.getProperties().put(property, value);
                return (T)value;
            }
        } else if (value != null) {
            return (T)value;
        }
        if ((defaultValue = property.getDefault()) instanceof Cloneable) {
            this.setProperty(property, defaultValue);
        }
        return defaultValue;
    }

    @Override
    public IPropertyHolder copyProperties(IPropertyHolder holder) {
        if (holder == null) {
            return this;
        }
        if (holder instanceof EMapPropertyHolder) {
            EMapPropertyHolder other = (EMapPropertyHolder)holder;
            EMap<IProperty<?>, Object> ourProps = this.getProperties();
            for (Map.Entry entry : other.getProperties()) {
                IPropertyValueProxy proxy;
                Object newValue;
                Object value = entry.getValue();
                if (value instanceof IPropertyValueProxy && (newValue = (proxy = (IPropertyValueProxy)value).resolveValue((IProperty)entry.getKey())) != null) {
                    entry.setValue(newValue);
                    value = newValue;
                }
                ourProps.put((Object)((IProperty)entry.getKey()), value);
            }
        } else {
            this.getProperties().putAll(holder.getAllProperties());
        }
        return this;
    }

    @Override
    public Map<IProperty<?>, Object> getAllProperties() {
        EMap<IProperty<?>, Object> props = this.getProperties();
        for (Map.Entry entry : props) {
            IPropertyValueProxy proxy;
            Object value;
            if (!(entry.getValue() instanceof IPropertyValueProxy) || (value = (proxy = (IPropertyValueProxy)entry.getValue()).resolveValue((IProperty)entry.getKey())) == null) continue;
            entry.setValue(value);
        }
        return props.map();
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return ((InternalEList)this.getProperties()).basicRemove((Object)otherEnd, msgs);
            }
            case 1: {
                return ((InternalEList)this.getPersistentEntries()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                if (coreType) {
                    return this.getProperties();
                }
                return this.getProperties().map();
            }
            case 1: {
                return this.getPersistentEntries();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                ((EStructuralFeature.Setting)this.getProperties()).set(newValue);
                return;
            }
            case 1: {
                this.getPersistentEntries().clear();
                this.getPersistentEntries().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.getProperties().clear();
                return;
            }
            case 1: {
                this.getPersistentEntries().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.properties != null && !this.properties.isEmpty();
            }
            case 1: {
                return this.persistentEntries != null && !this.persistentEntries.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }
}

