/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.properties.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.core.api.LockStatusChangeEvent;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.logger.RuntimeLogger;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.internal.logger.RuntimeLoggerManagerImpl;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.LockStatus;
import org.eclipse.sirius.ecore.extender.business.api.permission.exception.LockedInstanceException;
import org.eclipse.sirius.tools.internal.ui.RefreshHelper;
import org.eclipse.sirius.ui.properties.internal.Messages;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public class TransactionalEditingDomainContextAdapter
implements EditingContextAdapter {
    private static final String FORCE_REFRESH_SYSTEM_FLAG = "org.eclipse.sirius.properties.forceRefreshOnRepresentationsChange";
    private static final NotificationFilter FILTER = NotificationFilter.NOT_TOUCH.and(NotificationFilter.createNotifierTypeFilter(EObject.class));
    protected Consumer<List<Notification>> onModelChanged;
    private final TransactionalEditingDomain ted;
    private final ResourceSetListener postCommitListener = new PostCommitListener();
    private RuntimeLoggerSpy spy = new RuntimeLoggerSpy(RuntimeLoggerManager.INSTANCE);
    private IPermissionAuthority auth;
    private IAuthorityListener authListener;
    private List<Consumer<Collection<LockStatusChangeEvent>>> lockStatusListeners = new CopyOnWriteArrayList<Consumer<Collection<LockStatusChangeEvent>>>();

    public TransactionalEditingDomainContextAdapter(TransactionalEditingDomain ted) {
        this.ted = Objects.requireNonNull(ted);
        ModelAccessor ma = SiriusPlugin.getDefault().getModelAccessorRegistry().getModelAccessor(ted.getResourceSet());
        this.auth = ma.getPermissionAuthority();
        this.authListener = new PermissionsListener();
    }

    public IStatus performModelChange(final Runnable effect) {
        IStatus result;
        block6: {
            RecordingCommand cmd = new RecordingCommand(this.ted){

                protected void doExecute() {
                    effect.run();
                }
            };
            result = Status.OK_STATUS;
            this.spy.enable();
            try {
                try {
                    this.ted.getCommandStack().execute((Command)cmd);
                    if (!this.spy.hasSeenErrors()) break block6;
                    IStatus[] errors = this.spy.getErrors();
                    if (errors.length > 1) {
                        result = new MultiStatus("org.eclipse.sirius.ui.properties", 0, errors, Messages.TransactionalEditingDomainContextAdapter_errorDuringCommand, null);
                        break block6;
                    }
                    result = errors[0];
                }
                catch (Throwable th) {
                    result = new Status(4, "org.eclipse.sirius.ui.properties", Messages.TransactionalEditingDomainContextAdapter_errorDuringCommand, th);
                    this.spy.disable();
                }
            }
            finally {
                this.spy.disable();
            }
        }
        return result;
    }

    public void registerModelChangeListener(Consumer<List<Notification>> listener) {
        if (this.onModelChanged == null) {
            this.ted.addResourceSetListener(this.postCommitListener);
        }
        this.onModelChanged = listener;
    }

    public void unregisterModelChangeListener() {
        this.onModelChanged = null;
        this.ted.removeResourceSetListener(this.postCommitListener);
    }

    public EditingDomain getEditingDomain() {
        return this.ted;
    }

    public void addLockStatusChangedListener(Consumer<Collection<LockStatusChangeEvent>> listener) {
        if (this.lockStatusListeners.isEmpty()) {
            this.auth.addAuthorityListener(this.authListener);
        }
        this.lockStatusListeners.add(listener);
    }

    public void removeLockStatusChangedListener(Consumer<Collection<LockStatusChangeEvent>> listener) {
        this.lockStatusListeners.remove(listener);
        if (this.lockStatusListeners.isEmpty()) {
            this.auth.removeAuthorityListener(this.authListener);
        }
    }

    public LockStatusChangeEvent.LockStatus getLockStatus(EObject obj) {
        LockStatusChangeEvent.LockStatus result = this.convertLockStatus(this.auth.getLockStatus(obj));
        if (result == LockStatusChangeEvent.LockStatus.UNLOCKED && !this.auth.canEditInstance(obj)) {
            result = LockStatusChangeEvent.LockStatus.LOCKED_PERMISSION;
        }
        return result;
    }

    protected static boolean forceRefreshOnRepresentationChanges() {
        return Boolean.TRUE.toString().equals(System.getProperty(FORCE_REFRESH_SYSTEM_FLAG, Boolean.FALSE.toString()));
    }

    private LockStatusChangeEvent.LockStatus convertLockStatus(LockStatus siriusStatus) {
        LockStatusChangeEvent.LockStatus result = null;
        switch (siriusStatus) {
            case LOCKED_BY_ME: {
                result = LockStatusChangeEvent.LockStatus.LOCKED_BY_ME;
                break;
            }
            case LOCKED_BY_OTHER: {
                result = LockStatusChangeEvent.LockStatus.LOCKED_BY_OTHER;
                break;
            }
            case NOT_LOCKED: {
                result = LockStatusChangeEvent.LockStatus.UNLOCKED;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return result;
    }

    protected boolean isLockedByMe(EObject lockedElement) {
        LockStatusChangeEvent.LockStatus status = this.getLockStatus(lockedElement);
        return status == LockStatusChangeEvent.LockStatus.LOCKED_BY_ME;
    }

    private final class PermissionsListener
    implements IAuthorityListener {
        private PermissionsListener() {
        }

        public void notifyIsReleased(Collection<EObject> instances) {
            ArrayList<LockStatusChangeEvent> events = new ArrayList<LockStatusChangeEvent>();
            for (EObject o : instances) {
                events.add(new LockStatusChangeEvent(o, LockStatusChangeEvent.LockStatus.UNLOCKED));
            }
            this.notifyListeners(events);
        }

        public void notifyIsReleased(EObject instance) {
            this.notifyIsReleased(Collections.singleton(instance));
        }

        public void notifyIsLocked(Collection<EObject> instances) {
            ArrayList<LockStatusChangeEvent> events = new ArrayList<LockStatusChangeEvent>();
            Iterator<EObject> iterator = instances.iterator();
            while (iterator.hasNext()) {
                EObject o;
                boolean lockedByMe = TransactionalEditingDomainContextAdapter.this.isLockedByMe(o = iterator.next());
                events.add(new LockStatusChangeEvent(o, lockedByMe ? LockStatusChangeEvent.LockStatus.LOCKED_BY_ME : LockStatusChangeEvent.LockStatus.LOCKED_BY_OTHER));
            }
            this.notifyListeners(events);
        }

        public void notifyIsLocked(EObject instance) {
            this.notifyIsLocked(Collections.singleton(instance));
        }

        private void notifyListeners(Collection<LockStatusChangeEvent> events) {
            for (Consumer l : TransactionalEditingDomainContextAdapter.this.lockStatusListeners) {
                l.accept(events);
            }
        }
    }

    private class PostCommitListener
    extends ResourceSetListenerImpl {
        PostCommitListener() {
            super(FILTER);
        }

        public boolean isPostcommitOnly() {
            return true;
        }

        public void resourceSetChanged(ResourceSetChangeEvent event) {
            if (TransactionalEditingDomainContextAdapter.this.onModelChanged != null && (TransactionalEditingDomainContextAdapter.forceRefreshOnRepresentationChanges() || RefreshHelper.isImpactingNotification((Collection)event.getNotifications()))) {
                TransactionalEditingDomainContextAdapter.this.onModelChanged.accept(new ArrayList(event.getNotifications()));
            }
        }
    }

    private static final class RuntimeLoggerSpy
    implements RuntimeLogger {
        private final List<IStatus> errors = new ArrayList<IStatus>();
        private RuntimeLoggerManager manager;
        private ILogListener platformSpy = new ILogListener(){

            public void logging(IStatus status, String plugin) {
                Throwable cause = Optional.ofNullable(status).map(IStatus::getException).map(this::getRootCause).orElse(null);
                if (cause instanceof LockedInstanceException || cause instanceof SecurityException) {
                    if (status.getSeverity() < 4) {
                        errors.add(new Status(4, status.getPlugin(), status.getCode(), status.getMessage(), status.getException()));
                    } else {
                        errors.add(status);
                    }
                }
            }

            private Throwable getRootCause(Throwable throwable) {
                Throwable rootCause = throwable;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                return rootCause;
            }
        };

        RuntimeLoggerSpy(RuntimeLoggerManager instance) {
            this.manager = instance;
        }

        public void enable() {
            if (this.manager instanceof RuntimeLoggerManagerImpl) {
                ((RuntimeLoggerManagerImpl)this.manager).add((RuntimeLogger)this);
            }
            Platform.addLogListener((ILogListener)this.platformSpy);
        }

        public void disable() {
            Platform.removeLogListener((ILogListener)this.platformSpy);
            if (this.manager instanceof RuntimeLoggerManagerImpl) {
                ((RuntimeLoggerManagerImpl)this.manager).remove((RuntimeLogger)this);
            }
            this.errors.clear();
        }

        public boolean hasSeenErrors() {
            return !this.errors.isEmpty();
        }

        public IStatus[] getErrors() {
            return this.errors.toArray(new IStatus[this.errors.size()]);
        }

        public void info(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        }

        public void info(EObject odesignObject, EStructuralFeature feature, String message) {
        }

        public void warning(EObject odesignObject, EStructuralFeature feature, String message) {
        }

        public void warning(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
        }

        public void error(EObject odesignObject, EStructuralFeature feature, Throwable exception) {
            this.errors.add((IStatus)new Status(4, "org.eclipse.sirius.ui.properties", exception.getMessage(), exception));
        }

        public void error(EObject odesignObject, EStructuralFeature feature, String message) {
            this.errors.add((IStatus)new Status(4, "org.eclipse.sirius.ui.properties", message));
        }

        public void clearAll() {
        }

        public void clear(EObject eObject) {
        }
    }
}

