/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.modelunfolding;

import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockConstraintSystem;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.ExpressionLibrary;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.Library;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDeclaration;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationDefinition;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.CCSLModel.ClockExpressionAndRelation.RelationLibrary;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.ImportStatement;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.NamedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.EqualitySolver;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiatedElement;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.InstantiationTree;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.ModelClockUnfoldingPassOne;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.ModelClockUnfoldingPassTwo;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.ModelUnfoldingPassOne;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.ModelUnfoldingPassTwo;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.ExceptionWrapper;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.NoModelImportTreeRoot;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.QualifiedNameCollision;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class UnfoldModel {
    private InstantiationTree<InstantiatedElement> instantiationTree;
    private ClockConstraintSystem model;
    private boolean unfoldDone;
    private List<UnfoldModel> importedModels;
    private String importedAsAlias;
    private List<Library> librairies;
    private List<RelationDefinition> allRelationDefinitions;
    private List<ExpressionDefinition> allExpressionDefinitions;
    private Map<RelationDeclaration, RelationDefinition> usedRelationDefinitions;
    private Map<ExpressionDeclaration, ExpressionDefinition> usedExpressionDefinitions;
    private EqualitySolver<InstantiatedElement> equalityRegistry;
    private static HashMap<ClockConstraintSystem, UnfoldModel> modelCache = new HashMap();
    public static boolean isCoordinationLoad = false;

    public List<UnfoldModel> getImportedModels() {
        return this.importedModels;
    }

    public String getImportedAsAlias() {
        return this.importedAsAlias;
    }

    public void setImportedAsAlias(String importedAsAlias) {
        this.importedAsAlias = importedAsAlias;
    }

    private void init() {
        this.unfoldDone = false;
        this.instantiationTree = new InstantiationTree();
        this.importedModels = new ArrayList<UnfoldModel>();
        this.librairies = new ArrayList<Library>();
        this.allRelationDefinitions = new ArrayList<RelationDefinition>();
        this.allExpressionDefinitions = new ArrayList<ExpressionDefinition>();
        this.usedExpressionDefinitions = new HashMap<ExpressionDeclaration, ExpressionDefinition>();
        this.usedRelationDefinitions = new HashMap<RelationDeclaration, RelationDefinition>();
    }

    protected UnfoldModel(ClockConstraintSystem model) throws IOException, UnfoldingException {
        assert (model != null) : "Null model to unfold";
        this.init();
        this.model = model;
    }

    public static UnfoldModel unfoldModel(URI uri) throws IOException, UnfoldingException {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource modelResource = resourceSet.createResource(uri);
            modelResource.load(null);
            return UnfoldModel.unfoldModels((ResourceSet)resourceSet);
        }
        catch (IOException ioe) {
            System.out.println("UnfoldModel-Failed to read " + uri);
            throw ioe;
        }
    }

    public static UnfoldModel unfoldModel(Resource resource) throws IOException, UnfoldingException {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            resourceSet = new ResourceSetImpl();
            resourceSet.getResources().add((Object)resource);
        }
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        return UnfoldModel.unfoldModels(resourceSet);
    }

    public static UnfoldModel unfoldModels(ResourceSet resourceSet) throws IOException, UnfoldingException {
        EcoreUtil.resolveAll((ResourceSet)resourceSet);
        return UnfoldModel.unfoldAllModels(resourceSet);
    }

    private static UnfoldModel unfoldAllModels(ResourceSet resourceSet) throws IOException, UnfoldingException {
        modelCache.clear();
        for (Resource resource : resourceSet.getResources()) {
            if (resource.getContents().size() <= 0 || !(resource.getContents().get(0) instanceof ClockConstraintSystem)) continue;
            UnfoldModel.createModelImportTree(resource, resourceSet);
        }
        ArrayList<UnfoldModel> candidates = new ArrayList<UnfoldModel>(modelCache.values());
        for (UnfoldModel unfoldModel : modelCache.values()) {
            candidates.removeAll(unfoldModel.importedModels);
        }
        if (candidates.isEmpty()) {
            throw new NoModelImportTreeRoot("There is no model that is the root of the import tree");
        }
        candidates.size();
        UnfoldModel importTreeRoot = null;
        importTreeRoot = (UnfoldModel)candidates.get(0);
        UnfoldModel.unfoldModelTree(importTreeRoot, false);
        return importTreeRoot;
    }

    private static UnfoldModel createModelImportTree(Resource resource, ResourceSet resourceSet) throws IOException, UnfoldingException {
        ClockConstraintSystem model = (ClockConstraintSystem)resource.getContents().get(0);
        if (modelCache.containsKey(model)) {
            return modelCache.get(model);
        }
        UnfoldModel unfoldModel = new UnfoldModel(model);
        modelCache.put(model, unfoldModel);
        for (ImportStatement importStatement : model.getImports()) {
            URI uri = URI.createURI((String)importStatement.getImportURI());
            String importAlias = importStatement.getAlias();
            Resource importedResource = resourceSet.getResource(uri.resolve(resource.getURI(), false), false);
            if (importedResource == null) continue;
            if (importedResource.getContents().get(0) instanceof ClockConstraintSystem) {
                UnfoldModel importedUnfoldModel = UnfoldModel.createModelImportTree(importedResource, resourceSet);
                unfoldModel.importedModels.add(importedUnfoldModel);
                importedUnfoldModel.setImportedAsAlias(importAlias);
                continue;
            }
            if (!(importedResource.getContents().get(0) instanceof Library)) continue;
            unfoldModel.librairies.add((Library)importedResource.getContents().get(0));
        }
        if (resource.getContents().size() > 1) {
            int i = 1;
            while (i < resource.getContents().size()) {
                if (resource.getContents().get(i) instanceof Library) {
                    unfoldModel.librairies.add((Library)resource.getContents().get(i));
                }
                ++i;
            }
        }
        return unfoldModel;
    }

    private static UnfoldModel unfoldModelTree(UnfoldModel root, boolean doPartialLoad) throws UnfoldingException {
        for (UnfoldModel imported : root.importedModels) {
            UnfoldModel res = UnfoldModel.unfoldModelTree(imported, isCoordinationLoad);
            root.instantiationTree.mergeWith(res.instantiationTree);
            if (UnfoldModel.validateInstantiationTree(root.instantiationTree)) continue;
            throw new QualifiedNameCollision("");
        }
        if (!root.unfoldDone) {
            root.collectDefinitions();
            if (doPartialLoad) {
                root.doNoConstraintUnfold();
            } else {
                root.doFullUnfold();
            }
        }
        return root;
    }

    private static boolean validateInstantiationTree(InstantiationTree<InstantiatedElement> tree) {
        Vector keys = new Vector(tree.keySet());
        if (keys.isEmpty()) {
            return true;
        }
        ArrayList<NamedElement> nonUniqueNameElements = new ArrayList<NamedElement>();
        int i = 0;
        while (i < keys.size()) {
            NamedElement current = (NamedElement)keys.elementAt(i);
            String name = current.getName();
            boolean foundWithSameName = false;
            int j = i + 1;
            while (j < keys.size()) {
                if (((NamedElement)keys.elementAt(j)).getName().compareTo(name) == 0) {
                    nonUniqueNameElements.add((NamedElement)keys.elementAt(j));
                    foundWithSameName = true;
                }
                ++j;
            }
            if (foundWithSameName) {
                nonUniqueNameElements.add(current);
            }
            ++i;
        }
        if (nonUniqueNameElements.isEmpty()) {
            return true;
        }
        for (NamedElement key : nonUniqueNameElements) {
            InstantiationTree subTree = (InstantiationTree)tree.get(key);
            if (UnfoldModel.validateInstantiationTree(subTree)) continue;
            return false;
        }
        return true;
    }

    public ClockConstraintSystem getModel() {
        return this.model;
    }

    public InstantiationTree<InstantiatedElement> getInstantiationTree() {
        return this.instantiationTree;
    }

    private void collectDefinitions() {
        for (Library lib : this.librairies) {
            for (ExpressionLibrary eLib : lib.getExpressionLibraries()) {
                this.allExpressionDefinitions.addAll((Collection<ExpressionDefinition>)eLib.getExpressionDefinitions());
            }
            for (RelationLibrary rLib : lib.getRelationLibraries()) {
                this.allRelationDefinitions.addAll((Collection<RelationDefinition>)rLib.getRelationDefinitions());
            }
        }
    }

    public RelationDefinition lookupRelationDefinition(RelationDeclaration decl) {
        for (RelationDefinition def : this.allRelationDefinitions) {
            if (!def.getDeclaration().equals(decl)) continue;
            return def;
        }
        return null;
    }

    public ExpressionDefinition lookupExpressionDefinition(ExpressionDeclaration decl) {
        for (ExpressionDefinition def : this.allExpressionDefinitions) {
            if (!def.getDeclaration().equals(decl)) continue;
            return def;
        }
        return null;
    }

    public void recordRelationDefinitionUse(RelationDeclaration declaration, RelationDefinition definition) {
        this.usedRelationDefinitions.put(declaration, definition);
    }

    public void recordExpressionDefinitionUse(ExpressionDeclaration declaration, ExpressionDefinition definition) {
        this.usedExpressionDefinitions.put(declaration, definition);
    }

    public ExpressionDefinition getUsedExpressionDefinition(ExpressionDeclaration declaration) {
        return this.usedExpressionDefinitions.get(declaration);
    }

    public RelationDefinition getUsedRelationDefinition(RelationDeclaration declaration) {
        return this.usedRelationDefinitions.get(declaration);
    }

    public EqualitySolver<InstantiatedElement> getEqualityRegistry() {
        return this.equalityRegistry;
    }

    protected void doNoConstraintUnfold() throws UnfoldingException {
        ModelClockUnfoldingPassOne pass1 = new ModelClockUnfoldingPassOne(this);
        try {
            pass1.visit((EObject)this.getModel());
        }
        catch (ExceptionWrapper e) {
            throw (UnfoldingException)e.getCause();
        }
        ModelClockUnfoldingPassTwo pass2 = new ModelClockUnfoldingPassTwo(this);
        try {
            pass2.visit((EObject)this.getModel());
        }
        catch (ExceptionWrapper e) {
            throw (UnfoldingException)e.getCause();
        }
        this.equalityRegistry = pass2.getEqualitySolver();
        this.unfoldDone = true;
    }

    private void doUnfold() throws UnfoldingException {
        if (isCoordinationLoad) {
            this.doNoConstraintUnfold();
        } else {
            this.doFullUnfold();
        }
    }

    private void doFullUnfold() throws UnfoldingException {
        ModelUnfoldingPassOne pass1 = new ModelUnfoldingPassOne(this);
        try {
            pass1.visit((EObject)this.getModel());
        }
        catch (ExceptionWrapper e) {
            throw (UnfoldingException)e.getCause();
        }
        ModelUnfoldingPassTwo pass2 = new ModelUnfoldingPassTwo(this);
        try {
            pass2.visit((EObject)this.getModel());
        }
        catch (ExceptionWrapper e) {
            throw (UnfoldingException)e.getCause();
        }
        this.equalityRegistry = pass2.getEqualitySolver();
        this.unfoldDone = true;
    }
}

