/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.aoste.timesquare.ccslkernel.runtime.expressions;

import fr.inria.aoste.timesquare.ccslkernel.runtime.ICCSLConstraint;
import fr.inria.aoste.timesquare.ccslkernel.runtime.elements.RuntimeClock;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.expressions.AbstractRuntimeExpression;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractSemanticHelper;
import fr.inria.aoste.timesquare.ccslkernel.runtime.helpers.AbstractUpdateHelper;

public class RuntimeIntersection
extends AbstractRuntimeExpression {
    private RuntimeClock clock1;
    private RuntimeClock clock2;

    public RuntimeIntersection(RuntimeClock iClock, RuntimeClock clock1, RuntimeClock clock2) {
        super(iClock);
        this.clock1 = clock1;
        this.clock2 = clock2;
    }

    @Override
    public void semantic(AbstractSemanticHelper helper) throws SimulationException {
        if (this.clock1 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock1)).semantic(helper);
        }
        if (this.clock2 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock2)).semantic(helper);
        }
        if (!this.canCallSemantic()) {
            return;
        }
        super.semantic(helper);
        if (this.isDead()) {
            helper.inhibitClock(this.getExpressionClock());
        } else {
            helper.semanticBDDAnd(helper.createEqual(this.getExpressionClock(), helper.createIntersection(this.clock1, this.clock2)));
        }
        helper.registerClockUse(new RuntimeClock[]{this.getExpressionClock(), this.clock1, this.clock2});
    }

    @Override
    public void update(AbstractUpdateHelper helper) throws SimulationException {
        super.update(helper);
        if (this.clock1 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock1)).update(helper);
        }
        if (this.clock2 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock2)).update(helper);
        }
    }

    @Override
    public void deathSemantic(AbstractSemanticHelper helper) throws SimulationException {
        super.deathSemantic(helper);
        if (this.clock1 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock1)).deathSemantic(helper);
        }
        if (this.clock2 instanceof ICCSLConstraint) {
            ((ICCSLConstraint)((Object)this.clock2)).deathSemantic(helper);
        }
        helper.registerDeathConjunctionImplies(this.clock1, this.clock2, this.getExpressionClock());
    }
}

