/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename;

import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedQuery;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoPositionedQueryLabelProvider;
import org.eclipse.acceleo.internal.ide.ui.editors.template.actions.refactor.rename.AcceleoRenameQueryRefactoring;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AcceleoRenameQueryInputWizardPage
extends UserInputWizardPage {
    private Text fNameField;
    private ComboViewer fComboViewer;

    public AcceleoRenameQueryInputWizardPage(String name) {
        super(name);
    }

    public void createControl(Composite parent) {
        Composite result = new Composite(parent, 0);
        this.setControl((Control)result);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        result.setLayout((Layout)layout);
        Label label = new Label(result, 0);
        label.setText(AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.NewName"));
        this.fNameField = this.createNameField(result);
        label = new Label(result, 0);
        label.setText(AcceleoUIMessages.getString("AcceleoEditorRenameQueryRefactoring.QueriesAvailable"));
        Composite composite = new Composite(result, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fComboViewer = this.createComboViewer(composite);
        this.fComboViewer.getCombo().setLayoutData((Object)new GridData(768));
        final Button referenceButton = new Button(result, 32);
        referenceButton.setText(AcceleoUIMessages.getString("AcceleoEditorRenameRefactoring.UpdateReferences"));
        GridData data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 2;
        referenceButton.setLayoutData((Object)data);
        final AcceleoRenameQueryRefactoring refactoring = this.getRenameQueryRefactoring();
        this.fNameField.setText(refactoring.getQuery().getQueryName());
        this.fComboViewer.getCombo().setText(refactoring.getQuery().getQueryName());
        if (refactoring.getQuery() != null) {
            this.fComboViewer.setSelection((ISelection)new StructuredSelection((Object)refactoring.getQuery()));
        } else if (AcceleoPositionedQuery.getInput().length > 0) {
            this.fComboViewer.setSelection((ISelection)new StructuredSelection((Object)AcceleoPositionedQuery.getInput()[0]));
        }
        this.fNameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                AcceleoRenameQueryInputWizardPage.this.handleInputChanged();
            }
        });
        referenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                refactoring.setUpdateReferences(referenceButton.getSelection());
            }
        });
        this.fComboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AcceleoRenameQueryInputWizardPage.this.handleInputChanged();
            }
        });
        referenceButton.setSelection(true);
        this.fNameField.setFocus();
        this.fNameField.selectAll();
        this.handleInputChanged();
    }

    private Text createNameField(Composite result) {
        Text field = new Text(result, 18436);
        field.setLayoutData((Object)new GridData(768));
        return field;
    }

    private ComboViewer createComboViewer(Composite composite) {
        ComboViewer combo = new ComboViewer(composite, 2060);
        combo.setLabelProvider((IBaseLabelProvider)new AcceleoPositionedQueryLabelProvider());
        combo.setContentProvider((IContentProvider)new ArrayContentProvider());
        combo.setInput((Object)AcceleoPositionedQuery.getInput());
        return combo;
    }

    private AcceleoRenameQueryRefactoring getRenameQueryRefactoring() {
        return (AcceleoRenameQueryRefactoring)this.getRefactoring();
    }

    protected void handleInputChanged() {
        Object obj;
        RefactoringStatus status = new RefactoringStatus();
        AcceleoRenameQueryRefactoring refactoring = this.getRenameQueryRefactoring();
        status.merge(refactoring.setNewQueryName(this.fNameField.getText()));
        IStructuredSelection selection = (IStructuredSelection)this.fComboViewer.getSelection();
        if (!selection.isEmpty() && (obj = selection.getFirstElement()) instanceof AcceleoPositionedQuery) {
            refactoring.setQuery((AcceleoPositionedQuery)obj);
        }
        this.setPageComplete(!status.hasError());
        int severity = status.getSeverity();
        String message = status.getMessageMatchingSeverity(severity);
        if (severity >= 1) {
            this.setMessage(message, severity);
        } else {
            this.setMessage("", 0);
        }
    }
}

