/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.util.ResourceUtil;
import org.eclipse.egit.core.synchronize.GitRemoteFile;
import org.eclipse.egit.core.synchronize.GitRemoteFolder;
import org.eclipse.egit.core.synchronize.GitRemoteResource;
import org.eclipse.egit.core.synchronize.GitSyncCache;
import org.eclipse.egit.core.synchronize.GitSyncObjectCache;
import org.eclipse.egit.core.synchronize.ThreeWayDiffEntry;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeData;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariant;
import org.eclipse.team.core.variants.ResourceVariantByteStore;
import org.eclipse.team.core.variants.ResourceVariantTree;

abstract class GitResourceVariantTree
extends ResourceVariantTree {
    private final GitSyncCache gitCache;
    private final Map<IResource, IResourceVariant> cache = Collections.synchronizedMap(new WeakHashMap());
    protected final GitSynchronizeDataSet gsds;

    GitResourceVariantTree(ResourceVariantByteStore store, GitSyncCache gitCache, GitSynchronizeDataSet gsds) {
        super(store);
        this.gsds = gsds;
        this.gitCache = gitCache;
    }

    public IResource[] roots() {
        HashSet<IProject> roots = new HashSet<IProject>();
        for (GitSynchronizeData gsd : this.gsds) {
            if (gsd.getPathFilter() == null) {
                roots.addAll(gsd.getProjects());
                continue;
            }
            for (IResource resource : gsd.getIncludedResources()) {
                roots.add(resource.getProject());
            }
        }
        return roots.toArray(new IResource[roots.size()]);
    }

    public void dispose() {
        if (this.gsds != null) {
            this.gsds.dispose();
        }
        this.cache.clear();
    }

    protected IResourceVariant fetchVariant(IResource resource, int depth, IProgressMonitor monitor) throws TeamException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        if (resource == null || ResourceUtil.isNonWorkspace(resource)) {
            subMonitor.done();
            return null;
        }
        subMonitor.beginTask(NLS.bind((String)CoreText.GitResourceVariantTree_fetchingVariant, (Object)resource.getName()), -1);
        try {
            IResourceVariant iResourceVariant = this.fetchVariant(resource);
            return iResourceVariant;
        }
        finally {
            subMonitor.done();
        }
    }

    private IResourceVariant fetchVariant(IResource resource) {
        if (this.gitCache == null) {
            return null;
        }
        IResourceVariant cachedVariant = this.cache.get(resource);
        if (cachedVariant != null) {
            return cachedVariant;
        }
        GitSynchronizeData gsd = this.gsds.getData(resource.getProject());
        if (gsd == null) {
            return null;
        }
        Repository repo = gsd.getRepository();
        String path = this.getPath(resource, repo);
        GitSyncObjectCache syncCache = this.gitCache.get(repo);
        GitSyncObjectCache cachedData = syncCache.get(path);
        if (cachedData == null) {
            return null;
        }
        GitRemoteResource variant = null;
        ObjectId objectId = this.getObjectId(cachedData.getDiffEntry());
        if (!objectId.equals((AnyObjectId)ObjectId.zeroId())) {
            variant = resource.getType() == 1 ? new GitRemoteFile(repo, this.getCommitId(gsd), objectId, path, cachedData.getDiffEntry().getMetadata()) : new GitRemoteFolder(repo, cachedData, this.getCommitId(gsd), objectId, path);
            this.cache.put(resource, (IResourceVariant)variant);
        }
        return variant;
    }

    protected abstract ObjectId getObjectId(ThreeWayDiffEntry var1);

    protected abstract RevCommit getCommitId(GitSynchronizeData var1);

    protected IResourceVariant[] fetchMembers(IResourceVariant variant, IProgressMonitor progress) throws TeamException {
        if (variant == null || !(variant instanceof GitRemoteFolder)) {
            return new IResourceVariant[0];
        }
        GitRemoteFolder gitVariant = (GitRemoteFolder)variant;
        try {
            GitRemoteResource[] gitRemoteResourceArray = gitVariant.members(progress);
            return gitRemoteResourceArray;
        }
        finally {
            progress.done();
        }
    }

    public IResourceVariant getResourceVariant(IResource resource) throws TeamException {
        return this.fetchVariant(resource, 0, null);
    }

    private String getPath(IResource resource, Repository repo) {
        return Repository.stripWorkDir((File)repo.getWorkTree(), (File)resource.getLocation().toFile());
    }
}

