/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.structures.endo;

import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.structures.common.FLinkedList;
import org.eclipse.emf.diffmerge.structures.endo.AbstractEndorelationIterator;
import org.eclipse.emf.diffmerge.structures.endo.IRecursivelyDefinedEndorelation;

public class BreadthFirstIterator<T>
extends AbstractEndorelationIterator<T> {
    protected Iterator<T> _nextCandidateIterator;
    protected T _last;
    protected Deque<T> _uncoveredPreviousDepth;
    protected Deque<T> _uncoveredCurrentDepth;

    public BreadthFirstIterator(IRecursivelyDefinedEndorelation<T> endorelation_p) {
        super(endorelation_p);
        this._uncoveredPreviousDepth = new FLinkedList<T>(this._endorelation.getEqualityTester());
        this._uncoveredCurrentDepth = new FLinkedList<T>(this._endorelation.getEqualityTester());
        this._nextCandidateIterator = this._endorelation.getOrigins().iterator();
        this._last = null;
        if (this._nextCandidateIterator.hasNext()) {
            ++this._nextDepth;
        }
        this.update();
    }

    @Override
    public List<T> lastPath() {
        throw new UnsupportedOperationException();
    }

    @Override
    public T next() {
        Object result = super.next();
        this._last = result;
        return result;
    }

    @Override
    public List<T> nextPath() {
        throw new UnsupportedOperationException();
    }

    public void prune() {
        boolean removed = this._uncoveredCurrentDepth.remove(this._last);
        if (!removed) {
            this._uncoveredPreviousDepth.remove(this._last);
        }
        if (!removed) {
            this._nextCandidateIterator = this.emptyIterator();
            this._uncoveredCurrentDepth.remove(this._next);
            this._returnedElementsAndNext.remove(this._next);
            this._next = null;
        }
        this.update();
    }

    @Override
    protected void update() {
        while (!(this._next != null || !this._nextCandidateIterator.hasNext() && this._uncoveredPreviousDepth.isEmpty() && this._uncoveredCurrentDepth.isEmpty())) {
            this._next = this.getNextThrough(this._nextCandidateIterator);
            if (this._next != null) {
                this._uncoveredCurrentDepth.addLast(this._next);
                continue;
            }
            if (this._uncoveredPreviousDepth.isEmpty()) {
                Deque<T> tmp = this._uncoveredPreviousDepth;
                this._uncoveredPreviousDepth = this._uncoveredCurrentDepth;
                this._uncoveredCurrentDepth = tmp;
                ++this._nextDepth;
            }
            if (this._uncoveredPreviousDepth.isEmpty()) continue;
            T currentUncovered = this._uncoveredPreviousDepth.removeFirst();
            Collection<T> targets = this._endorelation.get(currentUncovered);
            this._nextCandidateIterator = targets.iterator();
            if (this._nextCandidateIterator.hasNext()) continue;
            this._maximalElements.add(currentUncovered);
        }
        if (this._next == null) {
            this._nextDepth = -1L;
        }
    }
}

