/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.ale.ide.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecoretools.ale.core.parser.Dsl;
import org.eclipse.emf.ecoretools.ale.core.parser.DslBuilder;
import org.eclipse.emf.ecoretools.ale.core.parser.visitor.ParseResult;
import org.eclipse.emf.ecoretools.ale.ide.WorkbenchDsl;
import org.eclipse.emf.ecoretools.ale.implementation.ModelUnit;

public class AleResource
extends ResourceImpl {
    protected DslBuilder parser;
    protected List<ParseResult<ModelUnit>> parseResult;
    private boolean isNotifyEnabled = true;

    public AleResource(URI uri, DslBuilder parser) {
        super(uri);
        this.parser = parser;
    }

    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        WorkbenchDsl dslFile = new WorkbenchDsl(inputStream);
        List newParseResult = this.parser.parse((Dsl)dslFile);
        if (newParseResult != null) {
            this.unload();
            this.parseResult = newParseResult;
            List newContent = this.parseResult.stream().map(pr -> (ModelUnit)pr.getRoot()).collect(Collectors.toList());
            this.isNotifyEnabled = false;
            this.getContents().addAll(newContent);
            this.isNotifyEnabled = true;
        }
    }

    protected void doUnload() {
        super.doUnload();
    }

    public void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
    }

    public List<ParseResult<ModelUnit>> getParseResult() {
        return this.parseResult;
    }

    public boolean eNotificationRequired() {
        if (this.isNotifyEnabled) {
            return super.eNotificationRequired();
        }
        return false;
    }

    public void save(Map<?, ?> options) throws IOException {
    }
}

