/*******************************************************************************
 * Copyright (c) 2017 Inria and Obeo.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Inria - initial API and implementation
 *
 * generated by Xtext 2.12.0
 *******************************************************************************/
grammar InternalAle;

options {
	superClass=AbstractInternalAntlrParser;
	backtrack=true;
}

@lexer::header {
package org.eclipse.emf.ecoretools.parser.antlr.internal;

// Hack: Use our own Lexer superclass by means of import. 
// Currently there is no other way to specify the superclass for the lexer.
import org.eclipse.xtext.parser.antlr.Lexer;
}

@parser::header {
package org.eclipse.emf.ecoretools.parser.antlr.internal;

import org.eclipse.xtext.*;
import org.eclipse.xtext.parser.*;
import org.eclipse.xtext.parser.impl.*;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.parser.antlr.AbstractInternalAntlrParser;
import org.eclipse.xtext.parser.antlr.XtextTokenStream;
import org.eclipse.xtext.parser.antlr.XtextTokenStream.HiddenTokens;
import org.eclipse.xtext.parser.antlr.AntlrDatatypeRuleToken;
import org.eclipse.emf.ecoretools.services.AleGrammarAccess;

}

@parser::members {

/*
  This grammar contains a lot of empty actions to work around a bug in ANTLR.
  Otherwise the ANTLR tool will create synpreds that cannot be compiled in some rare cases.
*/

 	private AleGrammarAccess grammarAccess;

    public InternalAleParser(TokenStream input, AleGrammarAccess grammarAccess) {
        this(input);
        this.grammarAccess = grammarAccess;
        registerRules(grammarAccess.getGrammar());
    }

    @Override
    protected String getFirstRuleName() {
    	return "rRoot";
   	}

   	@Override
   	protected AleGrammarAccess getGrammarAccess() {
   		return grammarAccess;
   	}

}

@rulecatch {
    catch (RecognitionException re) {
        recover(input,re);
        appendSkippedTokens();
    }
}

// Entry rule entryRulerRoot
entryRulerRoot returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRRootRule()); }
	iv_rulerRoot=rulerRoot
	{ $current=$iv_rulerRoot.current; }
	EOF;

// Rule rRoot
rulerRoot returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='behavior'
		{
			newLeafNode(otherlv_0, grammarAccess.getRRootAccess().getBehaviorKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRRootAccess().getNameRQualifiedParserRuleCall_1_0());
				}
				lv_name_1_0=rulerQualified
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRRootRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.rQualified");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=';'
		{
			newLeafNode(otherlv_2, grammarAccess.getRRootAccess().getSemicolonKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRRootAccess().getImportsRImportParserRuleCall_3_0());
				}
				lv_imports_3_0=rulerImport
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRRootRule());
					}
					add(
						$current,
						"imports",
						lv_imports_3_0,
						"org.eclipse.emf.ecoretools.Ale.rImport");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getRRootAccess().getServicesRServiceParserRuleCall_4_0());
				}
				lv_services_4_0=rulerService
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRRootRule());
					}
					add(
						$current,
						"services",
						lv_services_4_0,
						"org.eclipse.emf.ecoretools.Ale.rService");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getRRootAccess().getXtendedClassesRClassParserRuleCall_5_0());
				}
				lv_xtendedClasses_5_0=rulerClass
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRRootRule());
					}
					add(
						$current,
						"xtendedClasses",
						lv_xtendedClasses_5_0,
						"org.eclipse.emf.ecoretools.Ale.rClass");
					afterParserOrEnumRuleCall();
				}
			)
		)*
	)
;

// Entry rule entryRulerImport
entryRulerImport returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRImportRule()); }
	iv_rulerImport=rulerImport
	{ $current=$iv_rulerImport.current; }
	EOF;

// Rule rImport
rulerImport returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='import'
		{
			newLeafNode(otherlv_0, grammarAccess.getRImportAccess().getImportKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRImportAccess().getNameRQualifiedParserRuleCall_1_0());
				}
				lv_name_1_0=rulerQualified
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRImportRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.rQualified");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2='as'
		{
			newLeafNode(otherlv_2, grammarAccess.getRImportAccess().getAsKeyword_2());
		}
		(
			(
				lv_alias_3_0=RULE_IDENT
				{
					newLeafNode(lv_alias_3_0, grammarAccess.getRImportAccess().getAliasIdentTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRImportRule());
					}
					setWithLastConsumed(
						$current,
						"alias",
						lv_alias_3_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		otherlv_4='\n;'
		{
			newLeafNode(otherlv_4, grammarAccess.getRImportAccess().getControl000aSemicolonKeyword_4());
		}
	)
;

// Entry rule entryRulerService
entryRulerService returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRServiceRule()); }
	iv_rulerService=rulerService
	{ $current=$iv_rulerService.current; }
	EOF;

// Rule rService
rulerService returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='use'
		{
			newLeafNode(otherlv_0, grammarAccess.getRServiceAccess().getUseKeyword_0());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRServiceAccess().getNameRQualifiedParserRuleCall_1_0());
				}
				lv_name_1_0=rulerQualified
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRServiceRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.rQualified");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_2=';'
		{
			newLeafNode(otherlv_2, grammarAccess.getRServiceAccess().getSemicolonKeyword_2());
		}
	)
;

// Entry rule entryRulerClass
entryRulerClass returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRClassRule()); }
	iv_rulerClass=rulerClass
	{ $current=$iv_rulerClass.current; }
	EOF;

// Rule rClass
rulerClass returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRClassAccess().getROpenClassParserRuleCall_0());
		}
		this_rOpenClass_0=rulerOpenClass
		{
			$current = $this_rOpenClass_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRClassAccess().getRNewClassParserRuleCall_1());
		}
		this_rNewClass_1=rulerNewClass
		{
			$current = $this_rNewClass_1.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRulerOpenClass
entryRulerOpenClass returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getROpenClassRule()); }
	iv_rulerOpenClass=rulerOpenClass
	{ $current=$iv_rulerOpenClass.current; }
	EOF;

// Rule rOpenClass
rulerOpenClass returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='open'
		{
			newLeafNode(otherlv_0, grammarAccess.getROpenClassAccess().getOpenKeyword_0());
		}
		otherlv_1='class'
		{
			newLeafNode(otherlv_1, grammarAccess.getROpenClassAccess().getClassKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getROpenClassAccess().getNameRQualifiedParserRuleCall_2_0());
				}
				lv_name_2_0=rulerQualified
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getROpenClassRule());
					}
					set(
						$current,
						"name",
						lv_name_2_0,
						"org.eclipse.emf.ecoretools.Ale.rQualified");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_3='extends'
			{
				newLeafNode(otherlv_3, grammarAccess.getROpenClassAccess().getExtendsKeyword_3_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getROpenClassAccess().getExtendsRQualifiedParserRuleCall_3_1_0());
					}
					lv_extends_4_0=rulerQualified
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getROpenClassRule());
						}
						add(
							$current,
							"extends",
							lv_extends_4_0,
							"org.eclipse.emf.ecoretools.Ale.rQualified");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_5=','
				{
					newLeafNode(otherlv_5, grammarAccess.getROpenClassAccess().getCommaKeyword_3_2_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getROpenClassAccess().getExtendsRQualifiedParserRuleCall_3_2_1_0());
						}
						lv_extends_6_0=rulerQualified
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getROpenClassRule());
							}
							add(
								$current,
								"extends",
								lv_extends_6_0,
								"org.eclipse.emf.ecoretools.Ale.rQualified");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_7='{'
		{
			newLeafNode(otherlv_7, grammarAccess.getROpenClassAccess().getLeftCurlyBracketKeyword_4());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getROpenClassAccess().getAttributesRAttributeParserRuleCall_5_0());
				}
				lv_attributes_8_0=rulerAttribute
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getROpenClassRule());
					}
					add(
						$current,
						"attributes",
						lv_attributes_8_0,
						"org.eclipse.emf.ecoretools.Ale.rAttribute");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getROpenClassAccess().getOperationsROperationParserRuleCall_6_0());
				}
				lv_operations_9_0=rulerOperation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getROpenClassRule());
					}
					add(
						$current,
						"operations",
						lv_operations_9_0,
						"org.eclipse.emf.ecoretools.Ale.rOperation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_10='}'
		{
			newLeafNode(otherlv_10, grammarAccess.getROpenClassAccess().getRightCurlyBracketKeyword_7());
		}
	)
;

// Entry rule entryRulerNewClass
entryRulerNewClass returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRNewClassRule()); }
	iv_rulerNewClass=rulerNewClass
	{ $current=$iv_rulerNewClass.current; }
	EOF;

// Rule rNewClass
rulerNewClass returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='class'
		{
			newLeafNode(otherlv_0, grammarAccess.getRNewClassAccess().getClassKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_IDENT
				{
					newLeafNode(lv_name_1_0, grammarAccess.getRNewClassAccess().getNameIdentTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRNewClassRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		otherlv_2='{'
		{
			newLeafNode(otherlv_2, grammarAccess.getRNewClassAccess().getLeftCurlyBracketKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRNewClassAccess().getAttributesRAttributeParserRuleCall_3_0());
				}
				lv_attributes_3_0=rulerAttribute
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRNewClassRule());
					}
					add(
						$current,
						"attributes",
						lv_attributes_3_0,
						"org.eclipse.emf.ecoretools.Ale.rAttribute");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			(
				{
					newCompositeNode(grammarAccess.getRNewClassAccess().getOperationsROperationParserRuleCall_4_0());
				}
				lv_operations_4_0=rulerOperation
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRNewClassRule());
					}
					add(
						$current,
						"operations",
						lv_operations_4_0,
						"org.eclipse.emf.ecoretools.Ale.rOperation");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		otherlv_5='}'
		{
			newLeafNode(otherlv_5, grammarAccess.getRNewClassAccess().getRightCurlyBracketKeyword_5());
		}
	)
;

// Entry rule entryRulerOperation
entryRulerOperation returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getROperationRule()); }
	iv_rulerOperation=rulerOperation
	{ $current=$iv_rulerOperation.current; }
	EOF;

// Rule rOperation
rulerOperation returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getROperationAccess().getTagRTagParserRuleCall_0_0());
				}
				lv_tag_0_0=rulerTag
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getROperationRule());
					}
					add(
						$current,
						"tag",
						lv_tag_0_0,
						"org.eclipse.emf.ecoretools.Ale.rTag");
					afterParserOrEnumRuleCall();
				}
			)
		)*
		(
			otherlv_1='def'
			{
				newLeafNode(otherlv_1, grammarAccess.getROperationAccess().getDefKeyword_1_0());
			}
			    |
			otherlv_2='override'
			{
				newLeafNode(otherlv_2, grammarAccess.getROperationAccess().getOverrideKeyword_1_1());
			}
		)
		(
			(
				{
					newCompositeNode(grammarAccess.getROperationAccess().getTypeRTypeParserRuleCall_2_0());
				}
				lv_type_3_0=rulerType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getROperationRule());
					}
					set(
						$current,
						"type",
						lv_type_3_0,
						"org.eclipse.emf.ecoretools.Ale.rType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_name_4_0=RULE_IDENT
				{
					newLeafNode(lv_name_4_0, grammarAccess.getROperationAccess().getNameIdentTerminalRuleCall_3_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getROperationRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_4_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		otherlv_5='('
		{
			newLeafNode(otherlv_5, grammarAccess.getROperationAccess().getLeftParenthesisKeyword_4());
		}
		(
			(
				(
					{
						newCompositeNode(grammarAccess.getROperationAccess().getParamsRVariableParserRuleCall_5_0_0());
					}
					lv_params_6_0=rulerVariable
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getROperationRule());
						}
						add(
							$current,
							"params",
							lv_params_6_0,
							"org.eclipse.emf.ecoretools.Ale.rVariable");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_7=','
				{
					newLeafNode(otherlv_7, grammarAccess.getROperationAccess().getCommaKeyword_5_1_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getROperationAccess().getParamsRVariableParserRuleCall_5_1_1_0());
						}
						lv_params_8_0=rulerVariable
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getROperationRule());
							}
							add(
								$current,
								"params",
								lv_params_8_0,
								"org.eclipse.emf.ecoretools.Ale.rVariable");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_9=')'
		{
			newLeafNode(otherlv_9, grammarAccess.getROperationAccess().getRightParenthesisKeyword_6());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getROperationAccess().getBodyRBlockParserRuleCall_7_0());
				}
				lv_body_10_0=rulerBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getROperationRule());
					}
					set(
						$current,
						"body",
						lv_body_10_0,
						"org.eclipse.emf.ecoretools.Ale.rBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerTag
entryRulerTag returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRTagRule()); }
	iv_rulerTag=rulerTag
	{ $current=$iv_rulerTag.current; }
	EOF;

// Rule rTag
rulerTag returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='@'
		{
			newLeafNode(otherlv_0, grammarAccess.getRTagAccess().getCommercialAtKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_IDENT
				{
					newLeafNode(lv_name_1_0, grammarAccess.getRTagAccess().getNameIdentTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRTagRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
	)
;

// Entry rule entryRulerVariable
entryRulerVariable returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRVariableRule()); }
	iv_rulerVariable=rulerVariable
	{ $current=$iv_rulerVariable.current; }
	EOF;

// Rule rVariable
rulerVariable returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRVariableAccess().getTypeRTypeParserRuleCall_0_0());
				}
				lv_type_0_0=rulerType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRVariableRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.emf.ecoretools.Ale.rType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_name_1_0=RULE_IDENT
				{
					newLeafNode(lv_name_1_0, grammarAccess.getRVariableAccess().getNameIdentTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRVariableRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
	)
;

// Entry rule entryRulerAttribute
entryRulerAttribute returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRAttributeRule()); }
	iv_rulerAttribute=rulerAttribute
	{ $current=$iv_rulerAttribute.current; }
	EOF;

// Rule rAttribute
rulerAttribute returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				(
					lv_modifier_0_1='contains'
					{
						newLeafNode(lv_modifier_0_1, grammarAccess.getRAttributeAccess().getModifierContainsKeyword_0_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRAttributeRule());
						}
						setWithLastConsumed($current, "modifier", lv_modifier_0_1, null);
					}
					    |
					lv_modifier_0_2='unique'
					{
						newLeafNode(lv_modifier_0_2, grammarAccess.getRAttributeAccess().getModifierUniqueKeyword_0_0_1());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRAttributeRule());
						}
						setWithLastConsumed($current, "modifier", lv_modifier_0_2, null);
					}
				)
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getRAttributeAccess().getBoundsRCardinalityParserRuleCall_1_0());
				}
				lv_bounds_1_0=rulerCardinality
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRAttributeRule());
					}
					set(
						$current,
						"bounds",
						lv_bounds_1_0,
						"org.eclipse.emf.ecoretools.Ale.rCardinality");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getRAttributeAccess().getOppositeROppositeParserRuleCall_2_0());
				}
				lv_opposite_2_0=rulerOpposite
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRAttributeRule());
					}
					set(
						$current,
						"opposite",
						lv_opposite_2_0,
						"org.eclipse.emf.ecoretools.Ale.rOpposite");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getRAttributeAccess().getTypeRTypeParserRuleCall_3_0());
				}
				lv_type_3_0=rulerType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRAttributeRule());
					}
					set(
						$current,
						"type",
						lv_type_3_0,
						"org.eclipse.emf.ecoretools.Ale.rType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_name_4_0=RULE_IDENT
				{
					newLeafNode(lv_name_4_0, grammarAccess.getRAttributeAccess().getNameIdentTerminalRuleCall_4_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRAttributeRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_4_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		(
			otherlv_5=':='
			{
				newLeafNode(otherlv_5, grammarAccess.getRAttributeAccess().getColonEqualsSignKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRAttributeAccess().getExpRExpressionParserRuleCall_5_1_0());
					}
					lv_exp_6_0=rulerExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRAttributeRule());
						}
						set(
							$current,
							"exp",
							lv_exp_6_0,
							"org.eclipse.emf.ecoretools.Ale.rExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_7=';'
		{
			newLeafNode(otherlv_7, grammarAccess.getRAttributeAccess().getSemicolonKeyword_6());
		}
	)
;

// Entry rule entryRulerCardinality
entryRulerCardinality returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRCardinalityRule()); }
	iv_rulerCardinality=rulerCardinality
	{ $current=$iv_rulerCardinality.current.getText(); }
	EOF;

// Rule rCardinality
rulerCardinality returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_INT_0=RULE_INT
		{
			$current.merge(this_INT_0);
		}
		{
			newLeafNode(this_INT_0, grammarAccess.getRCardinalityAccess().getINTTerminalRuleCall_0());
		}
		kw='..'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getRCardinalityAccess().getFullStopFullStopKeyword_1());
		}
		(
			this_INT_2=RULE_INT
			{
				$current.merge(this_INT_2);
			}
			{
				newLeafNode(this_INT_2, grammarAccess.getRCardinalityAccess().getINTTerminalRuleCall_2_0());
			}
			    |
			this_MultOp_3=RULE_MULTOP
			{
				$current.merge(this_MultOp_3);
			}
			{
				newLeafNode(this_MultOp_3, grammarAccess.getRCardinalityAccess().getMultOpTerminalRuleCall_2_1());
			}
		)
	)
;

// Entry rule entryRulerOpposite
entryRulerOpposite returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getROppositeRule()); }
	iv_rulerOpposite=rulerOpposite
	{ $current=$iv_rulerOpposite.current; }
	EOF;

// Rule rOpposite
rulerOpposite returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='opposite'
		{
			newLeafNode(otherlv_0, grammarAccess.getROppositeAccess().getOppositeKeyword_0());
		}
		(
			(
				lv_name_1_0=RULE_IDENT
				{
					newLeafNode(lv_name_1_0, grammarAccess.getROppositeAccess().getNameIdentTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getROppositeRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
	)
;

// Entry rule entryRulerSimpleStatement
entryRulerSimpleStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRSimpleStatementRule()); }
	iv_rulerSimpleStatement=rulerSimpleStatement
	{ $current=$iv_rulerSimpleStatement.current; }
	EOF;

// Rule rSimpleStatement
rulerSimpleStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRSimpleStatementAccess().getRVarDeclParserRuleCall_0());
		}
		this_rVarDecl_0=rulerVarDecl
		{
			$current = $this_rVarDecl_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRSimpleStatementAccess().getRAssignParserRuleCall_1());
		}
		this_rAssign_1=rulerAssign
		{
			$current = $this_rAssign_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRSimpleStatementAccess().getRInsertParserRuleCall_2());
		}
		this_rInsert_2=rulerInsert
		{
			$current = $this_rInsert_2.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRSimpleStatementAccess().getRRemoveParserRuleCall_3());
		}
		this_rRemove_3=rulerRemove
		{
			$current = $this_rRemove_3.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRSimpleStatementAccess().getRExpressionParserRuleCall_4());
		}
		this_rExpression_4=rulerExpression
		{
			$current = $this_rExpression_4.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRulerBlockStatement
entryRulerBlockStatement returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRBlockStatementRule()); }
	iv_rulerBlockStatement=rulerBlockStatement
	{ $current=$iv_rulerBlockStatement.current; }
	EOF;

// Rule rBlockStatement
rulerBlockStatement returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRBlockStatementAccess().getRForEachParserRuleCall_0());
		}
		this_rForEach_0=rulerForEach
		{
			$current = $this_rForEach_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRBlockStatementAccess().getRWhileParserRuleCall_1());
		}
		this_rWhile_1=rulerWhile
		{
			$current = $this_rWhile_1.current;
			afterParserOrEnumRuleCall();
		}
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRBlockStatementAccess().getRIfParserRuleCall_2());
		}
		this_rIf_2=rulerIf
		{
			$current = $this_rIf_2.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRulerVarDecl
entryRulerVarDecl returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRVarDeclRule()); }
	iv_rulerVarDecl=rulerVarDecl
	{ $current=$iv_rulerVarDecl.current; }
	EOF;

// Rule rVarDecl
rulerVarDecl returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRVarDeclAccess().getTypeRTypeParserRuleCall_0_0());
				}
				lv_type_0_0=rulerType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRVarDeclRule());
					}
					set(
						$current,
						"type",
						lv_type_0_0,
						"org.eclipse.emf.ecoretools.Ale.rType");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			(
				lv_name_1_0=RULE_IDENT
				{
					newLeafNode(lv_name_1_0, grammarAccess.getRVarDeclAccess().getNameIdentTerminalRuleCall_1_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRVarDeclRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		(
			otherlv_2=':='
			{
				newLeafNode(otherlv_2, grammarAccess.getRVarDeclAccess().getColonEqualsSignKeyword_2_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRVarDeclAccess().getExpRExpressionParserRuleCall_2_1_0());
					}
					lv_exp_3_0=rulerExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRVarDeclRule());
						}
						set(
							$current,
							"exp",
							lv_exp_3_0,
							"org.eclipse.emf.ecoretools.Ale.rExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRulerAssign
entryRulerAssign returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRAssignRule()); }
	iv_rulerAssign=rulerAssign
	{ $current=$iv_rulerAssign.current; }
	EOF;

// Rule rAssign
rulerAssign returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRAssignAccess().getTargetExpressionParserRuleCall_0_0());
				}
				lv_target_0_0=ruleexpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRAssignRule());
					}
					set(
						$current,
						"target",
						lv_target_0_0,
						"org.eclipse.emf.ecoretools.Ale.expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1=':='
		{
			newLeafNode(otherlv_1, grammarAccess.getRAssignAccess().getColonEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRAssignAccess().getExpRExpressionParserRuleCall_2_0());
				}
				lv_exp_2_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRAssignRule());
					}
					set(
						$current,
						"exp",
						lv_exp_2_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerInsert
entryRulerInsert returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRInsertRule()); }
	iv_rulerInsert=rulerInsert
	{ $current=$iv_rulerInsert.current; }
	EOF;

// Rule rInsert
rulerInsert returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRInsertAccess().getTargetExpressionParserRuleCall_0_0());
				}
				lv_target_0_0=ruleexpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRInsertRule());
					}
					set(
						$current,
						"target",
						lv_target_0_0,
						"org.eclipse.emf.ecoretools.Ale.expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='+='
		{
			newLeafNode(otherlv_1, grammarAccess.getRInsertAccess().getPlusSignEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRInsertAccess().getExpRExpressionParserRuleCall_2_0());
				}
				lv_exp_2_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRInsertRule());
					}
					set(
						$current,
						"exp",
						lv_exp_2_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerRemove
entryRulerRemove returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRRemoveRule()); }
	iv_rulerRemove=rulerRemove
	{ $current=$iv_rulerRemove.current; }
	EOF;

// Rule rRemove
rulerRemove returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRRemoveAccess().getTargetExpressionParserRuleCall_0_0());
				}
				lv_target_0_0=ruleexpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRRemoveRule());
					}
					set(
						$current,
						"target",
						lv_target_0_0,
						"org.eclipse.emf.ecoretools.Ale.expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_1='-='
		{
			newLeafNode(otherlv_1, grammarAccess.getRRemoveAccess().getHyphenMinusEqualsSignKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRRemoveAccess().getExpRExpressionParserRuleCall_2_0());
				}
				lv_exp_2_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRRemoveRule());
					}
					set(
						$current,
						"exp",
						lv_exp_2_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerForEach
entryRulerForEach returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRForEachRule()); }
	iv_rulerForEach=rulerForEach
	{ $current=$iv_rulerForEach.current; }
	EOF;

// Rule rForEach
rulerForEach returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='for'
		{
			newLeafNode(otherlv_0, grammarAccess.getRForEachAccess().getForKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getRForEachAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				lv_iterator_2_0=RULE_IDENT
				{
					newLeafNode(lv_iterator_2_0, grammarAccess.getRForEachAccess().getIteratorIdentTerminalRuleCall_2_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getRForEachRule());
					}
					setWithLastConsumed(
						$current,
						"iterator",
						lv_iterator_2_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		otherlv_3='in'
		{
			newLeafNode(otherlv_3, grammarAccess.getRForEachAccess().getInKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRForEachAccess().getCollectionRCollectionParserRuleCall_4_0());
				}
				lv_collection_4_0=rulerCollection
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRForEachRule());
					}
					set(
						$current,
						"collection",
						lv_collection_4_0,
						"org.eclipse.emf.ecoretools.Ale.rCollection");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=')'
		{
			newLeafNode(otherlv_5, grammarAccess.getRForEachAccess().getRightParenthesisKeyword_5());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRForEachAccess().getBlockRBlockParserRuleCall_6_0());
				}
				lv_block_6_0=rulerBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRForEachRule());
					}
					set(
						$current,
						"block",
						lv_block_6_0,
						"org.eclipse.emf.ecoretools.Ale.rBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerCollection
entryRulerCollection returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRCollectionRule()); }
	iv_rulerCollection=rulerCollection
	{ $current=$iv_rulerCollection.current; }
	EOF;

// Rule rCollection
rulerCollection returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			otherlv_0='['
			{
				newLeafNode(otherlv_0, grammarAccess.getRCollectionAccess().getLeftSquareBracketKeyword_0_0());
			}
			(
				(
					lv_min_1_0=RULE_INT
					{
						newLeafNode(lv_min_1_0, grammarAccess.getRCollectionAccess().getMinINTTerminalRuleCall_0_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRCollectionRule());
						}
						setWithLastConsumed(
							$current,
							"min",
							lv_min_1_0,
							"org.eclipse.xtext.common.Terminals.INT");
					}
				)
			)
			otherlv_2='..'
			{
				newLeafNode(otherlv_2, grammarAccess.getRCollectionAccess().getFullStopFullStopKeyword_0_2());
			}
			(
				(
					lv_max_3_0=RULE_INT
					{
						newLeafNode(lv_max_3_0, grammarAccess.getRCollectionAccess().getMaxINTTerminalRuleCall_0_3_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRCollectionRule());
						}
						setWithLastConsumed(
							$current,
							"max",
							lv_max_3_0,
							"org.eclipse.xtext.common.Terminals.INT");
					}
				)
			)
			otherlv_4=']'
			{
				newLeafNode(otherlv_4, grammarAccess.getRCollectionAccess().getRightSquareBracketKeyword_0_4());
			}
		)
		    |
		(
			(
				{
					newCompositeNode(grammarAccess.getRCollectionAccess().getExpRExpressionParserRuleCall_1_0());
				}
				lv_exp_5_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRCollectionRule());
					}
					set(
						$current,
						"exp",
						lv_exp_5_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerBlock
entryRulerBlock returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRBlockRule()); }
	iv_rulerBlock=rulerBlock
	{ $current=$iv_rulerBlock.current; }
	EOF;

// Rule rBlock
rulerBlock returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				/* */
			}
			{
				$current = forceCreateModelElement(
					grammarAccess.getRBlockAccess().getBlockAction_0(),
					$current);
			}
		)
		otherlv_1='{'
		{
			newLeafNode(otherlv_1, grammarAccess.getRBlockAccess().getLeftCurlyBracketKeyword_1());
		}
		(
			(
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getRBlockAccess().getStatementsRSimpleStatementParserRuleCall_2_0_0_0_0());
							}
							lv_statements_2_0=rulerSimpleStatement
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getRBlockRule());
								}
								add(
									$current,
									"statements",
									lv_statements_2_0,
									"org.eclipse.emf.ecoretools.Ale.rSimpleStatement");
								afterParserOrEnumRuleCall();
							}
						)
					)
					otherlv_3=';'
					{
						newLeafNode(otherlv_3, grammarAccess.getRBlockAccess().getSemicolonKeyword_2_0_0_1());
					}
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getRBlockAccess().getStatementsRBlockStatementParserRuleCall_2_0_1_0());
						}
						lv_statements_4_0=rulerBlockStatement
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRBlockRule());
							}
							add(
								$current,
								"statements",
								lv_statements_4_0,
								"org.eclipse.emf.ecoretools.Ale.rBlockStatement");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			(
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getRBlockAccess().getStatementsRSimpleStatementParserRuleCall_2_1_0_0_0());
							}
							lv_statements_5_0=rulerSimpleStatement
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getRBlockRule());
								}
								add(
									$current,
									"statements",
									lv_statements_5_0,
									"org.eclipse.emf.ecoretools.Ale.rSimpleStatement");
								afterParserOrEnumRuleCall();
							}
						)
					)
					otherlv_6=';'
					{
						newLeafNode(otherlv_6, grammarAccess.getRBlockAccess().getSemicolonKeyword_2_1_0_1());
					}
				)
				    |
				(
					(
						{
							newCompositeNode(grammarAccess.getRBlockAccess().getStatementsRBlockStatementParserRuleCall_2_1_1_0());
						}
						lv_statements_7_0=rulerBlockStatement
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getRBlockRule());
							}
							add(
								$current,
								"statements",
								lv_statements_7_0,
								"org.eclipse.emf.ecoretools.Ale.rBlockStatement");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
		)?
		otherlv_8='}'
		{
			newLeafNode(otherlv_8, grammarAccess.getRBlockAccess().getRightCurlyBracketKeyword_3());
		}
	)
;

// Entry rule entryRulerIf
entryRulerIf returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRIfRule()); }
	iv_rulerIf=rulerIf
	{ $current=$iv_rulerIf.current; }
	EOF;

// Rule rIf
rulerIf returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='if'
		{
			newLeafNode(otherlv_0, grammarAccess.getRIfAccess().getIfKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getRIfAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRIfAccess().getCondRExpressionParserRuleCall_2_0());
				}
				lv_cond_2_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRIfRule());
					}
					set(
						$current,
						"cond",
						lv_cond_2_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=')'
		{
			newLeafNode(otherlv_3, grammarAccess.getRIfAccess().getRightParenthesisKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRIfAccess().getThenRBlockParserRuleCall_4_0());
				}
				lv_then_4_0=rulerBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRIfRule());
					}
					set(
						$current,
						"then",
						lv_then_4_0,
						"org.eclipse.emf.ecoretools.Ale.rBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
		(
			otherlv_5='else'
			{
				newLeafNode(otherlv_5, grammarAccess.getRIfAccess().getElseKeyword_5_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRIfAccess().getElseRBlockParserRuleCall_5_1_0());
					}
					lv_else_6_0=rulerBlock
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRIfRule());
						}
						set(
							$current,
							"else",
							lv_else_6_0,
							"org.eclipse.emf.ecoretools.Ale.rBlock");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
	)
;

// Entry rule entryRulerWhile
entryRulerWhile returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRWhileRule()); }
	iv_rulerWhile=rulerWhile
	{ $current=$iv_rulerWhile.current; }
	EOF;

// Rule rWhile
rulerWhile returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='while'
		{
			newLeafNode(otherlv_0, grammarAccess.getRWhileAccess().getWhileKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getRWhileAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRWhileAccess().getCondRExpressionParserRuleCall_2_0());
				}
				lv_cond_2_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRWhileRule());
					}
					set(
						$current,
						"cond",
						lv_cond_2_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_3=')'
		{
			newLeafNode(otherlv_3, grammarAccess.getRWhileAccess().getRightParenthesisKeyword_3());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRWhileAccess().getBlockRBlockParserRuleCall_4_0());
				}
				lv_block_4_0=rulerBlock
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRWhileRule());
					}
					set(
						$current,
						"block",
						lv_block_4_0,
						"org.eclipse.emf.ecoretools.Ale.rBlock");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerSwitch
entryRulerSwitch returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRSwitchRule()); }
	iv_rulerSwitch=rulerSwitch
	{ $current=$iv_rulerSwitch.current; }
	EOF;

// Rule rSwitch
rulerSwitch returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		otherlv_0='switch'
		{
			newLeafNode(otherlv_0, grammarAccess.getRSwitchAccess().getSwitchKeyword_0());
		}
		otherlv_1='('
		{
			newLeafNode(otherlv_1, grammarAccess.getRSwitchAccess().getLeftParenthesisKeyword_1());
		}
		(
			(
				(
					lv_paramName_2_0=RULE_IDENT
					{
						newLeafNode(lv_paramName_2_0, grammarAccess.getRSwitchAccess().getParamNameIdentTerminalRuleCall_2_0_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getRSwitchRule());
						}
						setWithLastConsumed(
							$current,
							"paramName",
							lv_paramName_2_0,
							"org.eclipse.emf.ecoretools.Ale.Ident");
					}
				)
			)
			otherlv_3=':'
			{
				newLeafNode(otherlv_3, grammarAccess.getRSwitchAccess().getColonKeyword_2_1());
			}
		)?
		(
			(
				{
					newCompositeNode(grammarAccess.getRSwitchAccess().getParamValRExpressionParserRuleCall_3_0());
				}
				lv_paramVal_4_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRSwitchRule());
					}
					set(
						$current,
						"paramVal",
						lv_paramVal_4_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_5=')'
		{
			newLeafNode(otherlv_5, grammarAccess.getRSwitchAccess().getRightParenthesisKeyword_4());
		}
		otherlv_6='{'
		{
			newLeafNode(otherlv_6, grammarAccess.getRSwitchAccess().getLeftCurlyBracketKeyword_5());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRSwitchAccess().getCasesRCaseParserRuleCall_6_0());
				}
				lv_cases_7_0=rulerCase
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRSwitchRule());
					}
					add(
						$current,
						"cases",
						lv_cases_7_0,
						"org.eclipse.emf.ecoretools.Ale.rCase");
					afterParserOrEnumRuleCall();
				}
			)
		)+
		otherlv_8='default'
		{
			newLeafNode(otherlv_8, grammarAccess.getRSwitchAccess().getDefaultKeyword_7());
		}
		otherlv_9=':'
		{
			newLeafNode(otherlv_9, grammarAccess.getRSwitchAccess().getColonKeyword_8());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRSwitchAccess().getOtherRExpressionParserRuleCall_9_0());
				}
				lv_other_10_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRSwitchRule());
					}
					set(
						$current,
						"other",
						lv_other_10_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
		otherlv_11='}'
		{
			newLeafNode(otherlv_11, grammarAccess.getRSwitchAccess().getRightCurlyBracketKeyword_10());
		}
	)
;

// Entry rule entryRulerCase
entryRulerCase returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRCaseRule()); }
	iv_rulerCase=rulerCase
	{ $current=$iv_rulerCase.current; }
	EOF;

// Rule rCase
rulerCase returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRCaseAccess().getGuardRTypeParserRuleCall_0_0());
				}
				lv_guard_0_0=rulerType
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRCaseRule());
					}
					set(
						$current,
						"guard",
						lv_guard_0_0,
						"org.eclipse.emf.ecoretools.Ale.rType");
					afterParserOrEnumRuleCall();
				}
			)
		)?
		(
			otherlv_1='case'
			{
				newLeafNode(otherlv_1, grammarAccess.getRCaseAccess().getCaseKeyword_1_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getRCaseAccess().getMatchRExpressionParserRuleCall_1_1_0());
					}
					lv_match_2_0=rulerExpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getRCaseRule());
						}
						set(
							$current,
							"match",
							lv_match_2_0,
							"org.eclipse.emf.ecoretools.Ale.rExpression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_3=':'
		{
			newLeafNode(otherlv_3, grammarAccess.getRCaseAccess().getColonKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getRCaseAccess().getValueRExpressionParserRuleCall_3_0());
				}
				lv_value_4_0=rulerExpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRCaseRule());
					}
					set(
						$current,
						"value",
						lv_value_4_0,
						"org.eclipse.emf.ecoretools.Ale.rExpression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerExpression
entryRulerExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRExpressionRule()); }
	iv_rulerExpression=rulerExpression
	{ $current=$iv_rulerExpression.current; }
	EOF;

// Rule rExpression
rulerExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					newCompositeNode(grammarAccess.getRExpressionAccess().getExpRSwitchParserRuleCall_0_0());
				}
				lv_exp_0_1=rulerSwitch
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRExpressionRule());
					}
					set(
						$current,
						"exp",
						lv_exp_0_1,
						"org.eclipse.emf.ecoretools.Ale.rSwitch");
					afterParserOrEnumRuleCall();
				}
				    |
				{
					newCompositeNode(grammarAccess.getRExpressionAccess().getExpExpressionParserRuleCall_0_1());
				}
				lv_exp_0_2=ruleexpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRExpressionRule());
					}
					set(
						$current,
						"exp",
						lv_exp_0_2,
						"org.eclipse.emf.ecoretools.Ale.expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleexpression
entryRuleexpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getExpressionRule()); }
	iv_ruleexpression=ruleexpression
	{ $current=$iv_ruleexpression.current; }
	EOF;

// Rule expression
ruleexpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getExpressionAccess().getNonLeftRecExpressionParserRuleCall_0());
		}
		this_nonLeftRecExpression_0=rulenonLeftRecExpression
		{
			$current = $this_nonLeftRecExpression_0.current;
			afterParserOrEnumRuleCall();
		}
		(
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getCallTargetAction_1_0_0(),
							$current);
					}
				)
				otherlv_2='.'
				{
					newLeafNode(otherlv_2, grammarAccess.getExpressionAccess().getFullStopKeyword_1_0_1());
				}
				(
					(
						lv_name_3_0=RULE_IDENT
						{
							newLeafNode(lv_name_3_0, grammarAccess.getExpressionAccess().getNameIdentTerminalRuleCall_1_0_2_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getExpressionRule());
							}
							setWithLastConsumed(
								$current,
								"name",
								lv_name_3_0,
								"org.eclipse.emf.ecoretools.Ale.Ident");
						}
					)
				)
				otherlv_4='('
				{
					newLeafNode(otherlv_4, grammarAccess.getExpressionAccess().getLeftParenthesisKeyword_1_0_3());
				}
				(
					(
						(
							{
								newCompositeNode(grammarAccess.getExpressionAccess().getParamsExpressionParserRuleCall_1_0_4_0_0());
							}
							lv_params_5_0=ruleexpression
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getExpressionRule());
								}
								add(
									$current,
									"params",
									lv_params_5_0,
									"org.eclipse.emf.ecoretools.Ale.expression");
								afterParserOrEnumRuleCall();
							}
						)
					)
					(
						otherlv_6=','
						{
							newLeafNode(otherlv_6, grammarAccess.getExpressionAccess().getCommaKeyword_1_0_4_1_0());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getExpressionAccess().getParamsExpressionParserRuleCall_1_0_4_1_1_0());
								}
								lv_params_7_0=ruleexpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getExpressionRule());
									}
									add(
										$current,
										"params",
										lv_params_7_0,
										"org.eclipse.emf.ecoretools.Ale.expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
					)*
				)?
				otherlv_8=')'
				{
					newLeafNode(otherlv_8, grammarAccess.getExpressionAccess().getRightParenthesisKeyword_1_0_5());
				}
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getFeatureTargetAction_1_1_0(),
							$current);
					}
				)
				otherlv_10='.'
				{
					newLeafNode(otherlv_10, grammarAccess.getExpressionAccess().getFullStopKeyword_1_1_1());
				}
				(
					(
						lv_feature_11_0=RULE_IDENT
						{
							newLeafNode(lv_feature_11_0, grammarAccess.getExpressionAccess().getFeatureIdentTerminalRuleCall_1_1_2_0());
						}
						{
							if ($current==null) {
								$current = createModelElement(grammarAccess.getExpressionRule());
							}
							setWithLastConsumed(
								$current,
								"feature",
								lv_feature_11_0,
								"org.eclipse.emf.ecoretools.Ale.Ident");
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getApplyTargetAction_1_2_0(),
							$current);
					}
				)
				otherlv_13='->'
				{
					newLeafNode(otherlv_13, grammarAccess.getExpressionAccess().getHyphenMinusGreaterThanSignKeyword_1_2_1());
				}
				(
					(
						(
							(
								{
									newCompositeNode(grammarAccess.getExpressionAccess().getNameCollectionIteratorParserRuleCall_1_2_2_0_0_0());
								}
								lv_name_14_0=rulecollectionIterator
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getExpressionRule());
									}
									set(
										$current,
										"name",
										lv_name_14_0,
										"org.eclipse.emf.ecoretools.Ale.collectionIterator");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_15='('
						{
							newLeafNode(otherlv_15, grammarAccess.getExpressionAccess().getLeftParenthesisKeyword_1_2_2_0_1());
						}
						(
							(
								lv_varName_16_0=RULE_IDENT
								{
									newLeafNode(lv_varName_16_0, grammarAccess.getExpressionAccess().getVarNameIdentTerminalRuleCall_1_2_2_0_2_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getExpressionRule());
									}
									setWithLastConsumed(
										$current,
										"varName",
										lv_varName_16_0,
										"org.eclipse.emf.ecoretools.Ale.Ident");
								}
							)
						)
						(
							otherlv_17=':'
							{
								newLeafNode(otherlv_17, grammarAccess.getExpressionAccess().getColonKeyword_1_2_2_0_3_0());
							}
							(
								(
									{
										newCompositeNode(grammarAccess.getExpressionAccess().getVarTypeTypeLiteralParserRuleCall_1_2_2_0_3_1_0());
									}
									lv_varType_18_0=ruletypeLiteral
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getExpressionRule());
										}
										set(
											$current,
											"varType",
											lv_varType_18_0,
											"org.eclipse.emf.ecoretools.Ale.typeLiteral");
										afterParserOrEnumRuleCall();
									}
								)
							)
						)?
						otherlv_19='|'
						{
							newLeafNode(otherlv_19, grammarAccess.getExpressionAccess().getVerticalLineKeyword_1_2_2_0_4());
						}
						(
							(
								{
									newCompositeNode(grammarAccess.getExpressionAccess().getLambdaExpressionParserRuleCall_1_2_2_0_5_0());
								}
								lv_lambda_20_0=ruleexpression
								{
									if ($current==null) {
										$current = createModelElementForParent(grammarAccess.getExpressionRule());
									}
									set(
										$current,
										"lambda",
										lv_lambda_20_0,
										"org.eclipse.emf.ecoretools.Ale.expression");
									afterParserOrEnumRuleCall();
								}
							)
						)
						otherlv_21=')'
						{
							newLeafNode(otherlv_21, grammarAccess.getExpressionAccess().getRightParenthesisKeyword_1_2_2_0_6());
						}
					)
					    |
					(
						(
							(
								lv_name_22_0=RULE_IDENT
								{
									newLeafNode(lv_name_22_0, grammarAccess.getExpressionAccess().getNameIdentTerminalRuleCall_1_2_2_1_0_0());
								}
								{
									if ($current==null) {
										$current = createModelElement(grammarAccess.getExpressionRule());
									}
									setWithLastConsumed(
										$current,
										"name",
										lv_name_22_0,
										"org.eclipse.emf.ecoretools.Ale.Ident");
								}
							)
						)
						otherlv_23='('
						{
							newLeafNode(otherlv_23, grammarAccess.getExpressionAccess().getLeftParenthesisKeyword_1_2_2_1_1());
						}
						(
							(
								(
									{
										newCompositeNode(grammarAccess.getExpressionAccess().getParamsExpressionParserRuleCall_1_2_2_1_2_0_0());
									}
									lv_params_24_0=ruleexpression
									{
										if ($current==null) {
											$current = createModelElementForParent(grammarAccess.getExpressionRule());
										}
										add(
											$current,
											"params",
											lv_params_24_0,
											"org.eclipse.emf.ecoretools.Ale.expression");
										afterParserOrEnumRuleCall();
									}
								)
							)
							(
								otherlv_25=','
								{
									newLeafNode(otherlv_25, grammarAccess.getExpressionAccess().getCommaKeyword_1_2_2_1_2_1_0());
								}
								(
									(
										{
											newCompositeNode(grammarAccess.getExpressionAccess().getParamsExpressionParserRuleCall_1_2_2_1_2_1_1_0());
										}
										lv_params_26_0=ruleexpression
										{
											if ($current==null) {
												$current = createModelElementForParent(grammarAccess.getExpressionRule());
											}
											add(
												$current,
												"params",
												lv_params_26_0,
												"org.eclipse.emf.ecoretools.Ale.expression");
											afterParserOrEnumRuleCall();
										}
									)
								)
							)*
						)?
						otherlv_27=')'
						{
							newLeafNode(otherlv_27, grammarAccess.getExpressionAccess().getRightParenthesisKeyword_1_2_2_1_3());
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getMultLeftAction_1_3_0(),
							$current);
					}
				)
				this_MultOp_29=RULE_MULTOP
				{
					newLeafNode(this_MultOp_29, grammarAccess.getExpressionAccess().getMultOpTerminalRuleCall_1_3_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_3_2_0());
						}
						lv_right_30_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_30_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getAddLeftAction_1_4_0(),
							$current);
					}
				)
				{
					/* */
				}
				{
					newCompositeNode(grammarAccess.getExpressionAccess().getAddOpParserRuleCall_1_4_1());
				}
				ruleaddOp
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_4_2_0());
						}
						lv_right_33_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_33_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getCompLeftAction_1_5_0(),
							$current);
					}
				)
				{
					/* */
				}
				{
					newCompositeNode(grammarAccess.getExpressionAccess().getCompOpParserRuleCall_1_5_1());
				}
				rulecompOp
				{
					afterParserOrEnumRuleCall();
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_5_2_0());
						}
						lv_right_36_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_36_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getAndLeftAction_1_6_0(),
							$current);
					}
				)
				otherlv_38='and'
				{
					newLeafNode(otherlv_38, grammarAccess.getExpressionAccess().getAndKeyword_1_6_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_6_2_0());
						}
						lv_right_39_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_39_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getOrLeftAction_1_7_0(),
							$current);
					}
				)
				otherlv_41='or'
				{
					newLeafNode(otherlv_41, grammarAccess.getExpressionAccess().getOrKeyword_1_7_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_7_2_0());
						}
						lv_right_42_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_42_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getXorLeftAction_1_8_0(),
							$current);
					}
				)
				otherlv_44='xor'
				{
					newLeafNode(otherlv_44, grammarAccess.getExpressionAccess().getXorKeyword_1_8_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_8_2_0());
						}
						lv_right_45_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_45_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
			    |
			(
				(
					{
						/* */
					}
					{
						$current = forceCreateModelElementAndSet(
							grammarAccess.getExpressionAccess().getImplieLeftAction_1_9_0(),
							$current);
					}
				)
				otherlv_47='implie'
				{
					newLeafNode(otherlv_47, grammarAccess.getExpressionAccess().getImplieKeyword_1_9_1());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getExpressionAccess().getRightExpressionParserRuleCall_1_9_2_0());
						}
						lv_right_48_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getExpressionRule());
							}
							set(
								$current,
								"right",
								lv_right_48_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)
		)*
	)
;

// Entry rule entryRulenonLeftRecExpression
entryRulenonLeftRecExpression returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getNonLeftRecExpressionRule()); }
	iv_rulenonLeftRecExpression=rulenonLeftRecExpression
	{ $current=$iv_rulenonLeftRecExpression.current; }
	EOF;

// Rule nonLeftRecExpression
rulenonLeftRecExpression returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getNonLeftRecExpressionAccess().getNotAction_0_0(),
						$current);
				}
			)
			otherlv_1='not'
			{
				newLeafNode(otherlv_1, grammarAccess.getNonLeftRecExpressionAccess().getNotKeyword_0_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getExpExpressionParserRuleCall_0_2_0());
					}
					lv_exp_2_0=ruleexpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"exp",
							lv_exp_2_0,
							"org.eclipse.emf.ecoretools.Ale.expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getNonLeftRecExpressionAccess().getMinAction_1_0(),
						$current);
				}
			)
			otherlv_4='-'
			{
				newLeafNode(otherlv_4, grammarAccess.getNonLeftRecExpressionAccess().getHyphenMinusKeyword_1_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getExpExpressionParserRuleCall_1_2_0());
					}
					lv_exp_5_0=ruleexpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"exp",
							lv_exp_5_0,
							"org.eclipse.emf.ecoretools.Ale.expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getNonLeftRecExpressionAccess().getVarRefAction_2_0(),
						$current);
				}
			)
			(
				(
					lv_ID_7_0=RULE_IDENT
					{
						newLeafNode(lv_ID_7_0, grammarAccess.getNonLeftRecExpressionAccess().getIDIdentTerminalRuleCall_2_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getNonLeftRecExpressionRule());
						}
						setWithLastConsumed(
							$current,
							"ID",
							lv_ID_7_0,
							"org.eclipse.emf.ecoretools.Ale.Ident");
					}
				)
			)
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getNonLeftRecExpressionAccess().getLitAction_3_0(),
						$current);
				}
			)
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getLiteralLiteralParserRuleCall_3_1_0());
					}
					lv_literal_9_0=ruleliteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"literal",
							lv_literal_9_0,
							"org.eclipse.emf.ecoretools.Ale.literal");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
		    |
		(
			otherlv_10='('
			{
				newLeafNode(otherlv_10, grammarAccess.getNonLeftRecExpressionAccess().getLeftParenthesisKeyword_4_0());
			}
			{
				/* */
			}
			{
				newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getExpressionParserRuleCall_4_1());
			}
			this_expression_11=ruleexpression
			{
				$current = $this_expression_11.current;
				afterParserOrEnumRuleCall();
			}
			otherlv_12=')'
			{
				newLeafNode(otherlv_12, grammarAccess.getNonLeftRecExpressionAccess().getRightParenthesisKeyword_4_2());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getNonLeftRecExpressionAccess().getConditionalAction_5_0(),
						$current);
				}
			)
			otherlv_14='if'
			{
				newLeafNode(otherlv_14, grammarAccess.getNonLeftRecExpressionAccess().getIfKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getCondExpressionParserRuleCall_5_2_0());
					}
					lv_cond_15_0=ruleexpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"cond",
							lv_cond_15_0,
							"org.eclipse.emf.ecoretools.Ale.expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_16='then'
			{
				newLeafNode(otherlv_16, grammarAccess.getNonLeftRecExpressionAccess().getThenKeyword_5_3());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getThenExpressionParserRuleCall_5_4_0());
					}
					lv_then_17_0=ruleexpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"then",
							lv_then_17_0,
							"org.eclipse.emf.ecoretools.Ale.expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_18='else'
			{
				newLeafNode(otherlv_18, grammarAccess.getNonLeftRecExpressionAccess().getElseKeyword_5_5());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getElseExpressionParserRuleCall_5_6_0());
					}
					lv_else_19_0=ruleexpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"else",
							lv_else_19_0,
							"org.eclipse.emf.ecoretools.Ale.expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_20='endif'
			{
				newLeafNode(otherlv_20, grammarAccess.getNonLeftRecExpressionAccess().getEndifKeyword_5_7());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getNonLeftRecExpressionAccess().getLetAction_6_0(),
						$current);
				}
			)
			otherlv_22='let'
			{
				newLeafNode(otherlv_22, grammarAccess.getNonLeftRecExpressionAccess().getLetKeyword_6_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getBindingsBindingParserRuleCall_6_2_0());
					}
					lv_bindings_23_0=rulebinding
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						add(
							$current,
							"bindings",
							lv_bindings_23_0,
							"org.eclipse.emf.ecoretools.Ale.binding");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_24=','
				{
					newLeafNode(otherlv_24, grammarAccess.getNonLeftRecExpressionAccess().getCommaKeyword_6_3_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getBindingsBindingParserRuleCall_6_3_1_0());
						}
						lv_bindings_25_0=rulebinding
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
							}
							add(
								$current,
								"bindings",
								lv_bindings_25_0,
								"org.eclipse.emf.ecoretools.Ale.binding");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_26='in'
			{
				newLeafNode(otherlv_26, grammarAccess.getNonLeftRecExpressionAccess().getInKeyword_6_4());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getNonLeftRecExpressionAccess().getExpExpressionParserRuleCall_6_5_0());
					}
					lv_exp_27_0=ruleexpression
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getNonLeftRecExpressionRule());
						}
						set(
							$current,
							"exp",
							lv_exp_27_0,
							"org.eclipse.emf.ecoretools.Ale.expression");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)
	)
;

// Entry rule entryRulebinding
entryRulebinding returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getBindingRule()); }
	iv_rulebinding=rulebinding
	{ $current=$iv_rulebinding.current; }
	EOF;

// Rule binding
rulebinding returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				lv_name_0_0=RULE_IDENT
				{
					newLeafNode(lv_name_0_0, grammarAccess.getBindingAccess().getNameIdentTerminalRuleCall_0_0());
				}
				{
					if ($current==null) {
						$current = createModelElement(grammarAccess.getBindingRule());
					}
					setWithLastConsumed(
						$current,
						"name",
						lv_name_0_0,
						"org.eclipse.emf.ecoretools.Ale.Ident");
				}
			)
		)
		(
			otherlv_1=':'
			{
				newLeafNode(otherlv_1, grammarAccess.getBindingAccess().getColonKeyword_1_0());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getBindingAccess().getTypeTypeLiteralParserRuleCall_1_1_0());
					}
					lv_type_2_0=ruletypeLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getBindingRule());
						}
						set(
							$current,
							"type",
							lv_type_2_0,
							"org.eclipse.emf.ecoretools.Ale.typeLiteral");
						afterParserOrEnumRuleCall();
					}
				)
			)
		)?
		otherlv_3='='
		{
			newLeafNode(otherlv_3, grammarAccess.getBindingAccess().getEqualsSignKeyword_2());
		}
		(
			(
				{
					newCompositeNode(grammarAccess.getBindingAccess().getExpExpressionParserRuleCall_3_0());
				}
				lv_exp_4_0=ruleexpression
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getBindingRule());
					}
					set(
						$current,
						"exp",
						lv_exp_4_0,
						"org.eclipse.emf.ecoretools.Ale.expression");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRuleaddOp
entryRuleaddOp returns [String current=null]:
	{ newCompositeNode(grammarAccess.getAddOpRule()); }
	iv_ruleaddOp=ruleaddOp
	{ $current=$iv_ruleaddOp.current.getText(); }
	EOF;

// Rule addOp
ruleaddOp returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='+'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getAddOpAccess().getPlusSignKeyword_0());
		}
		    |
		kw='-'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getAddOpAccess().getHyphenMinusKeyword_1());
		}
	)
;

// Entry rule entryRulecompOp
entryRulecompOp returns [String current=null]:
	{ newCompositeNode(grammarAccess.getCompOpRule()); }
	iv_rulecompOp=rulecompOp
	{ $current=$iv_rulecompOp.current.getText(); }
	EOF;

// Rule compOp
rulecompOp returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='<='
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getLessThanSignEqualsSignKeyword_0());
		}
		    |
		kw='>='
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getGreaterThanSignEqualsSignKeyword_1());
		}
		    |
		kw='!='
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getExclamationMarkEqualsSignKeyword_2());
		}
		    |
		kw='<>'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getLessThanSignGreaterThanSignKeyword_3());
		}
		    |
		kw='='
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getEqualsSignKeyword_4());
		}
		    |
		kw='=='
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getEqualsSignEqualsSignKeyword_5());
		}
		    |
		kw='<'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getLessThanSignKeyword_6());
		}
		    |
		kw='>'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCompOpAccess().getGreaterThanSignKeyword_7());
		}
	)
;

// Entry rule entryRulecollectionIterator
entryRulecollectionIterator returns [String current=null]:
	{ newCompositeNode(grammarAccess.getCollectionIteratorRule()); }
	iv_rulecollectionIterator=rulecollectionIterator
	{ $current=$iv_rulecollectionIterator.current.getText(); }
	EOF;

// Rule collectionIterator
rulecollectionIterator returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		kw='select'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getSelectKeyword_0());
		}
		    |
		kw='reject'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getRejectKeyword_1());
		}
		    |
		kw='collect'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getCollectKeyword_2());
		}
		    |
		kw='any'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getAnyKeyword_3());
		}
		    |
		kw='exists'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getExistsKeyword_4());
		}
		    |
		kw='forAll'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getForAllKeyword_5());
		}
		    |
		kw='isUnique'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getIsUniqueKeyword_6());
		}
		    |
		kw='one'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getOneKeyword_7());
		}
		    |
		kw='sortedBy'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getSortedByKeyword_8());
		}
		    |
		kw='closure'
		{
			$current.merge(kw);
			newLeafNode(kw, grammarAccess.getCollectionIteratorAccess().getClosureKeyword_9());
		}
	)
;

// Entry rule entryRuleliteral
entryRuleliteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getLiteralRule()); }
	iv_ruleliteral=ruleliteral
	{ $current=$iv_ruleliteral.current; }
	EOF;

// Rule literal
ruleliteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getStringAction_0_0(),
						$current);
				}
			)
			(
				(
					lv_value_1_0=RULE_STRING
					{
						newLeafNode(lv_value_1_0, grammarAccess.getLiteralAccess().getValueSTRINGTerminalRuleCall_0_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getLiteralRule());
						}
						setWithLastConsumed(
							$current,
							"value",
							lv_value_1_0,
							"org.eclipse.emf.ecoretools.Ale.STRING");
					}
				)
			)
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getIntAction_1_0(),
						$current);
				}
			)
			(
				(
					lv_value_3_0=RULE_INT
					{
						newLeafNode(lv_value_3_0, grammarAccess.getLiteralAccess().getValueINTTerminalRuleCall_1_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getLiteralRule());
						}
						setWithLastConsumed(
							$current,
							"value",
							lv_value_3_0,
							"org.eclipse.xtext.common.Terminals.INT");
					}
				)
			)
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getRealAction_2_0(),
						$current);
				}
			)
			(
				(
					lv_value_5_0=RULE_REAL
					{
						newLeafNode(lv_value_5_0, grammarAccess.getLiteralAccess().getValueRealTerminalRuleCall_2_1_0());
					}
					{
						if ($current==null) {
							$current = createModelElement(grammarAccess.getLiteralRule());
						}
						setWithLastConsumed(
							$current,
							"value",
							lv_value_5_0,
							"org.eclipse.emf.ecoretools.Ale.Real");
					}
				)
			)
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getTrueAction_3_0(),
						$current);
				}
			)
			otherlv_7='true'
			{
				newLeafNode(otherlv_7, grammarAccess.getLiteralAccess().getTrueKeyword_3_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getFalseAction_4_0(),
						$current);
				}
			)
			otherlv_9='false'
			{
				newLeafNode(otherlv_9, grammarAccess.getLiteralAccess().getFalseKeyword_4_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getNullAction_5_0(),
						$current);
				}
			)
			otherlv_11='null'
			{
				newLeafNode(otherlv_11, grammarAccess.getLiteralAccess().getNullKeyword_5_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getSequenceAction_6_0(),
						$current);
				}
			)
			otherlv_13='Sequence{'
			{
				newLeafNode(otherlv_13, grammarAccess.getLiteralAccess().getSequenceKeyword_6_1());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getLiteralAccess().getParamsExpressionParserRuleCall_6_2_0_0());
						}
						lv_params_14_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLiteralRule());
							}
							add(
								$current,
								"params",
								lv_params_14_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_15=','
					{
						newLeafNode(otherlv_15, grammarAccess.getLiteralAccess().getCommaKeyword_6_2_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getLiteralAccess().getParamsExpressionParserRuleCall_6_2_1_1_0());
							}
							lv_params_16_0=ruleexpression
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getLiteralRule());
								}
								add(
									$current,
									"params",
									lv_params_16_0,
									"org.eclipse.emf.ecoretools.Ale.expression");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_17='}'
			{
				newLeafNode(otherlv_17, grammarAccess.getLiteralAccess().getRightCurlyBracketKeyword_6_3());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getOrderedSetAction_7_0(),
						$current);
				}
			)
			otherlv_19='OrderedSet{'
			{
				newLeafNode(otherlv_19, grammarAccess.getLiteralAccess().getOrderedSetKeyword_7_1());
			}
			(
				(
					(
						{
							newCompositeNode(grammarAccess.getLiteralAccess().getParamsExpressionParserRuleCall_7_2_0_0());
						}
						lv_params_20_0=ruleexpression
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getLiteralRule());
							}
							add(
								$current,
								"params",
								lv_params_20_0,
								"org.eclipse.emf.ecoretools.Ale.expression");
							afterParserOrEnumRuleCall();
						}
					)
				)
				(
					otherlv_21=','
					{
						newLeafNode(otherlv_21, grammarAccess.getLiteralAccess().getCommaKeyword_7_2_1_0());
					}
					(
						(
							{
								newCompositeNode(grammarAccess.getLiteralAccess().getParamsExpressionParserRuleCall_7_2_1_1_0());
							}
							lv_params_22_0=ruleexpression
							{
								if ($current==null) {
									$current = createModelElementForParent(grammarAccess.getLiteralRule());
								}
								add(
									$current,
									"params",
									lv_params_22_0,
									"org.eclipse.emf.ecoretools.Ale.expression");
								afterParserOrEnumRuleCall();
							}
						)
					)
				)*
			)?
			otherlv_23='}'
			{
				newLeafNode(otherlv_23, grammarAccess.getLiteralAccess().getRightCurlyBracketKeyword_7_3());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getLiteralAccess().getEnumAction_8_0(),
						$current);
				}
			)
			this_Ident_25=RULE_IDENT
			{
				newLeafNode(this_Ident_25, grammarAccess.getLiteralAccess().getIdentTerminalRuleCall_8_1());
			}
			otherlv_26='::'
			{
				newLeafNode(otherlv_26, grammarAccess.getLiteralAccess().getColonColonKeyword_8_2());
			}
			this_Ident_27=RULE_IDENT
			{
				newLeafNode(this_Ident_27, grammarAccess.getLiteralAccess().getIdentTerminalRuleCall_8_3());
			}
			otherlv_28='::'
			{
				newLeafNode(otherlv_28, grammarAccess.getLiteralAccess().getColonColonKeyword_8_4());
			}
			this_Ident_29=RULE_IDENT
			{
				newLeafNode(this_Ident_29, grammarAccess.getLiteralAccess().getIdentTerminalRuleCall_8_5());
			}
		)
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getLiteralAccess().getTypeLiteralParserRuleCall_9());
		}
		this_typeLiteral_30=ruletypeLiteral
		{
			$current = $this_typeLiteral_30.current;
			afterParserOrEnumRuleCall();
		}
	)
;

// Entry rule entryRuletypeLiteral
entryRuletypeLiteral returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getTypeLiteralRule()); }
	iv_ruletypeLiteral=ruletypeLiteral
	{ $current=$iv_ruletypeLiteral.current; }
	EOF;

// Rule typeLiteral
ruletypeLiteral returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getStringTypeAction_0_0(),
						$current);
				}
			)
			otherlv_1='String'
			{
				newLeafNode(otherlv_1, grammarAccess.getTypeLiteralAccess().getStringKeyword_0_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getIntTypeAction_1_0(),
						$current);
				}
			)
			otherlv_3='Integer'
			{
				newLeafNode(otherlv_3, grammarAccess.getTypeLiteralAccess().getIntegerKeyword_1_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getRealTypeAction_2_0(),
						$current);
				}
			)
			otherlv_5='Real'
			{
				newLeafNode(otherlv_5, grammarAccess.getTypeLiteralAccess().getRealKeyword_2_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getBoolTypeAction_3_0(),
						$current);
				}
			)
			otherlv_7='Boolean'
			{
				newLeafNode(otherlv_7, grammarAccess.getTypeLiteralAccess().getBooleanKeyword_3_1());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getSeqTypeAction_4_0(),
						$current);
				}
			)
			otherlv_9='Sequence('
			{
				newLeafNode(otherlv_9, grammarAccess.getTypeLiteralAccess().getSequenceKeyword_4_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTypeLiteralAccess().getTypeTypeLiteralParserRuleCall_4_2_0());
					}
					lv_type_10_0=ruletypeLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTypeLiteralRule());
						}
						set(
							$current,
							"type",
							lv_type_10_0,
							"org.eclipse.emf.ecoretools.Ale.typeLiteral");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_11=')'
			{
				newLeafNode(otherlv_11, grammarAccess.getTypeLiteralAccess().getRightParenthesisKeyword_4_3());
			}
		)
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getSetTypeAction_5_0(),
						$current);
				}
			)
			otherlv_13='OrderedSet('
			{
				newLeafNode(otherlv_13, grammarAccess.getTypeLiteralAccess().getOrderedSetKeyword_5_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTypeLiteralAccess().getTypeTypeLiteralParserRuleCall_5_2_0());
					}
					lv_type_14_0=ruletypeLiteral
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTypeLiteralRule());
						}
						set(
							$current,
							"type",
							lv_type_14_0,
							"org.eclipse.emf.ecoretools.Ale.typeLiteral");
						afterParserOrEnumRuleCall();
					}
				)
			)
			otherlv_15=')'
			{
				newLeafNode(otherlv_15, grammarAccess.getTypeLiteralAccess().getRightParenthesisKeyword_5_3());
			}
		)
		    |
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getTypeLiteralAccess().getClassifierTypeRuleParserRuleCall_6());
		}
		this_classifierTypeRule_16=ruleclassifierTypeRule
		{
			$current = $this_classifierTypeRule_16.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			(
				{
					/* */
				}
				{
					$current = forceCreateModelElement(
						grammarAccess.getTypeLiteralAccess().getClassifierSetTypeAction_7_0(),
						$current);
				}
			)
			otherlv_18='{'
			{
				newLeafNode(otherlv_18, grammarAccess.getTypeLiteralAccess().getLeftCurlyBracketKeyword_7_1());
			}
			(
				(
					{
						newCompositeNode(grammarAccess.getTypeLiteralAccess().getTypesClassifierTypeRuleParserRuleCall_7_2_0());
					}
					lv_types_19_0=ruleclassifierTypeRule
					{
						if ($current==null) {
							$current = createModelElementForParent(grammarAccess.getTypeLiteralRule());
						}
						add(
							$current,
							"types",
							lv_types_19_0,
							"org.eclipse.emf.ecoretools.Ale.classifierTypeRule");
						afterParserOrEnumRuleCall();
					}
				)
			)
			(
				otherlv_20='|'
				{
					newLeafNode(otherlv_20, grammarAccess.getTypeLiteralAccess().getVerticalLineKeyword_7_3_0());
				}
				(
					(
						{
							newCompositeNode(grammarAccess.getTypeLiteralAccess().getTypesClassifierTypeRuleParserRuleCall_7_3_1_0());
						}
						lv_types_21_0=ruleclassifierTypeRule
						{
							if ($current==null) {
								$current = createModelElementForParent(grammarAccess.getTypeLiteralRule());
							}
							add(
								$current,
								"types",
								lv_types_21_0,
								"org.eclipse.emf.ecoretools.Ale.classifierTypeRule");
							afterParserOrEnumRuleCall();
						}
					)
				)
			)*
			otherlv_22='}'
			{
				newLeafNode(otherlv_22, grammarAccess.getTypeLiteralAccess().getRightCurlyBracketKeyword_7_4());
			}
		)
	)
;

// Entry rule entryRuleclassifierTypeRule
entryRuleclassifierTypeRule returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getClassifierTypeRuleRule()); }
	iv_ruleclassifierTypeRule=ruleclassifierTypeRule
	{ $current=$iv_ruleclassifierTypeRule.current; }
	EOF;

// Rule classifierTypeRule
ruleclassifierTypeRule returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		(
			{
				/* */
			}
			{
				$current = forceCreateModelElement(
					grammarAccess.getClassifierTypeRuleAccess().getClassifierTypeAction_0(),
					$current);
			}
		)
		this_Ident_1=RULE_IDENT
		{
			newLeafNode(this_Ident_1, grammarAccess.getClassifierTypeRuleAccess().getIdentTerminalRuleCall_1());
		}
		otherlv_2='::'
		{
			newLeafNode(otherlv_2, grammarAccess.getClassifierTypeRuleAccess().getColonColonKeyword_2());
		}
		this_Ident_3=RULE_IDENT
		{
			newLeafNode(this_Ident_3, grammarAccess.getClassifierTypeRuleAccess().getIdentTerminalRuleCall_3());
		}
	)
;

// Entry rule entryRulerType
entryRulerType returns [EObject current=null]:
	{ newCompositeNode(grammarAccess.getRTypeRule()); }
	iv_rulerType=rulerType
	{ $current=$iv_rulerType.current; }
	EOF;

// Rule rType
rulerType returns [EObject current=null]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		{
			/* */
		}
		{
			newCompositeNode(grammarAccess.getRTypeAccess().getTypeLiteralParserRuleCall_0());
		}
		this_typeLiteral_0=ruletypeLiteral
		{
			$current = $this_typeLiteral_0.current;
			afterParserOrEnumRuleCall();
		}
		    |
		(
			(
				{
					newCompositeNode(grammarAccess.getRTypeAccess().getNameRQIdentParserRuleCall_1_0());
				}
				lv_name_1_0=rulerQIdent
				{
					if ($current==null) {
						$current = createModelElementForParent(grammarAccess.getRTypeRule());
					}
					set(
						$current,
						"name",
						lv_name_1_0,
						"org.eclipse.emf.ecoretools.Ale.rQIdent");
					afterParserOrEnumRuleCall();
				}
			)
		)
	)
;

// Entry rule entryRulerQIdent
entryRulerQIdent returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRQIdentRule()); }
	iv_rulerQIdent=rulerQIdent
	{ $current=$iv_rulerQIdent.current.getText(); }
	EOF;

// Rule rQIdent
rulerQIdent returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_Ident_0=RULE_IDENT
		{
			$current.merge(this_Ident_0);
		}
		{
			newLeafNode(this_Ident_0, grammarAccess.getRQIdentAccess().getIdentTerminalRuleCall_0());
		}
		(
			kw='::'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getRQIdentAccess().getColonColonKeyword_1_0());
			}
			this_Ident_2=RULE_IDENT
			{
				$current.merge(this_Ident_2);
			}
			{
				newLeafNode(this_Ident_2, grammarAccess.getRQIdentAccess().getIdentTerminalRuleCall_1_1());
			}
		)*
	)
;

// Entry rule entryRulerQualified
entryRulerQualified returns [String current=null]:
	{ newCompositeNode(grammarAccess.getRQualifiedRule()); }
	iv_rulerQualified=rulerQualified
	{ $current=$iv_rulerQualified.current.getText(); }
	EOF;

// Rule rQualified
rulerQualified returns [AntlrDatatypeRuleToken current=new AntlrDatatypeRuleToken()]
@init {
	enterRule();
}
@after {
	leaveRule();
}:
	(
		this_Ident_0=RULE_IDENT
		{
			$current.merge(this_Ident_0);
		}
		{
			newLeafNode(this_Ident_0, grammarAccess.getRQualifiedAccess().getIdentTerminalRuleCall_0());
		}
		(
			kw='.'
			{
				$current.merge(kw);
				newLeafNode(kw, grammarAccess.getRQualifiedAccess().getFullStopKeyword_1_0());
			}
			this_Ident_2=RULE_IDENT
			{
				$current.merge(this_Ident_2);
			}
			{
				newLeafNode(this_Ident_2, grammarAccess.getRQualifiedAccess().getIdentTerminalRuleCall_1_1());
			}
		)*
	)
;

RULE_MULTOP : ('*'|'/');

RULE_REAL : ('0'..'9')+ '.' ('0'..'9')+;

RULE_IDENT : (RULE_LETTER|'_') (RULE_LETTER|'0'..'9'|'_')*;

fragment RULE_LETTER : ('a'..'z'|'A'..'Z');

RULE_STRING : '\'' ('\\' .|~(('\\'|'\'')))* '\'';

RULE_ID : '^'? ('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'_'|'0'..'9')*;

RULE_INT : ('0'..'9')+;

RULE_ML_COMMENT : '/*' ( options {greedy=false;} : . )*'*/';

RULE_SL_COMMENT : '//' ~(('\n'|'\r'))* ('\r'? '\n')?;

RULE_WS : (' '|'\t'|'\r'|'\n')+;

RULE_ANY_OTHER : .;
