/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.registration.view;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecoretools.registration.EMFRegistryHelper;
import org.eclipse.emf.ecoretools.registration.Messages;
import org.eclipse.emf.ecoretools.registration.RegistrationPlugin;
import org.eclipse.emf.ecoretools.registration.internal.RegisteredPackageComparator;
import org.eclipse.emf.ecoretools.registration.internal.RegistrationIcons;
import org.eclipse.emf.ecoretools.registration.popup.actions.CopyNSURIAction;
import org.eclipse.emf.ecoretools.registration.popup.actions.EcoreUnregisterPackageAction;
import org.eclipse.emf.ecoretools.registration.view.ColumnSelectionListener;
import org.eclipse.emf.ecoretools.registration.view.RegisteredPackagesContentProvider;
import org.eclipse.emf.ecoretools.registration.view.RegisteredPackagesLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class RegisteredPackageView
extends ViewPart {
    private TreeViewer viewer;
    private EcoreUnregisterPackageAction unregisterPackageAction;
    private CopyNSURIAction copyNSURIAction;
    private Action refreshViewAction;
    private Action loadLazyEPackagesAction;
    Clipboard clipboard;
    public static final String ID = "org.eclipse.emf.ecoretools.registration.viewregisteredpackages";

    public RegisteredPackageView() {
        this.setContentDescription(Messages.RegisteredPackageView_RegisteredPackages);
    }

    public void createPartControl(Composite parent) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.clipboard = new Clipboard(display);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new RegisteredPackagesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new RegisteredPackagesLabelProvider());
        this.viewer.setComparator((ViewerComparator)new RegisteredPackageComparator(0, 0));
        this.createActions();
        this.createContextMenu();
        this.createColumns(this.viewer);
        this.viewer.setColumnProperties(new String[]{Messages.RegisteredPackageView_RegisteredURI, Messages.RegisteredPackageView_PackageName, Messages.RegisteredPackageView_Origin, Messages.RegisteredPackageView_Status});
        this.viewer.getTree().setHeaderVisible(true);
        this.viewer.getTree().setLinesVisible(false);
        this.viewer.setInput((Object)this.getViewSite());
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyNSURIAction);
        this.contributeToActionBars();
    }

    private void createColumns(TreeViewer treeViewer) {
        TreeColumn column1 = new TreeColumn(treeViewer.getTree(), 16384);
        column1.setText(Messages.RegisteredPackageView_RegisteredURI);
        column1.setWidth(300);
        column1.setResizable(true);
        column1.addSelectionListener((SelectionListener)new ColumnSelectionListener(treeViewer, 0));
        TreeColumn column2 = new TreeColumn(treeViewer.getTree(), 16384);
        column2.setText(Messages.RegisteredPackageView_PackageName);
        column2.setWidth(120);
        column2.setResizable(true);
        column2.addSelectionListener((SelectionListener)new ColumnSelectionListener(treeViewer, 1));
        TreeColumn column3 = new TreeColumn(treeViewer.getTree(), 16384);
        column3.setText(Messages.RegisteredPackageView_Origin);
        column3.setWidth(350);
        column3.setResizable(true);
        column3.addSelectionListener((SelectionListener)new ColumnSelectionListener(treeViewer, 2));
        TreeColumn column4 = new TreeColumn(this.viewer.getTree(), 16384);
        column4.setText(Messages.RegisteredPackageView_Status);
        column4.setWidth(350);
        column4.setResizable(true);
        column4.addSelectionListener((SelectionListener)new ColumnSelectionListener(treeViewer, 3));
    }

    private void createActions() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ISharedImages platformImages = workbench.getSharedImages();
        this.unregisterPackageAction = new EcoreUnregisterPackageAction(this, Messages.RegisteredPackageView_Unregister);
        this.unregisterPackageAction.setImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_DELETE"));
        this.unregisterPackageAction.setDisabledImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_DELETE_DISABLED"));
        this.unregisterPackageAction.setToolTipText(Messages.RegisteredPackageView_UnregisterSelectedPackages);
        this.copyNSURIAction = new CopyNSURIAction(this, this.clipboard, Messages.RegisteredPackageView_CopyNsURI);
        this.copyNSURIAction.setImageDescriptor(platformImages.getImageDescriptor("IMG_TOOL_COPY"));
        this.copyNSURIAction.setToolTipText(Messages.RegisteredPackageView_CopyNsURI_tooltip);
        this.refreshViewAction = new Action(){

            public void run() {
                RegisteredPackageView.this.refresh();
            }
        };
        this.refreshViewAction.setText(Messages.RegisteredPackageView_RefreshView);
        this.refreshViewAction.setToolTipText(Messages.RegisteredPackageView_RefreshView_tooltip);
        this.refreshViewAction.setImageDescriptor(RegistrationIcons.REFRESH_ICON_DESCRIPTOR);
        this.loadLazyEPackagesAction = new Action(){

            public void run() {
                Map map = EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)true);
                map.keySet().forEach(uriKey -> {
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    resourceSet.getPackageRegistry().getEPackage(uriKey);
                });
                RegisteredPackageView.this.refresh();
            }
        };
        this.loadLazyEPackagesAction.setText(Messages.RegisteredPackageView_LoadLazyEpackages);
        this.loadLazyEPackagesAction.setToolTipText(Messages.RegisteredPackageView_LoadLazyEpackages_tooltip);
        this.loadLazyEPackagesAction.setImageDescriptor(RegistrationIcons.LOAD_LAZY_EPACKAGES_ICON_DESCRIPTOR);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager m) {
                RegisteredPackageView.this.fillContextMenu(m);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        this.unregisterPackageAction.setEnabled(this.isSelectionDynamicallyRegistered((IStructuredSelection)this.viewer.getSelection()));
        menuMgr.add((IAction)this.unregisterPackageAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.add((IAction)this.copyNSURIAction);
        menuMgr.add((IContributionItem)new Separator("additions"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.loadLazyEPackagesAction);
        manager.add((IAction)this.refreshViewAction);
    }

    public String[] getSelectedPackages() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        String[] items = new String[selection.size()];
        Iterator iter = selection.iterator();
        int index = 0;
        while (iter.hasNext()) {
            items[index++] = (String)iter.next();
        }
        return items;
    }

    public void setFocus() {
    }

    public void refresh() {
        RegistrationPlugin.getDefault().resetCache();
        this.viewer.refresh();
    }

    private boolean isSelectionDynamicallyRegistered(IStructuredSelection selection) {
        boolean result = true;
        if (selection.isEmpty()) {
            return false;
        }
        for (String nsURI : selection) {
            if (EMFRegistryHelper.isDynamicallyRegistered(nsURI)) continue;
            return false;
        }
        return result;
    }

    public static void refreshViewIfActive() {
        RegisteredPackageView view = (RegisteredPackageView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView(ID);
        if (view != null) {
            view.refresh();
        }
    }
}

