/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare.moc.impl;

import fr.inria.aoste.timesquare.ccslkernel.explorer.CCSLConstraintState;
import fr.inria.aoste.timesquare.ccslkernel.model.TimeModel.Event;
import fr.inria.aoste.timesquare.ccslkernel.modelunfolding.exception.UnfoldingException;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.NoBooleanSolution;
import fr.inria.aoste.timesquare.ccslkernel.runtime.exceptions.SimulationException;
import fr.inria.aoste.timesquare.ccslkernel.solver.exception.SolverException;
import fr.inria.aoste.timesquare.ccslkernel.solver.launch.CCSLKernelSolverWrapper;
import fr.inria.aoste.timesquare.instantrelation.CCSLRelationModel.OccurrenceRelation;
import fr.inria.aoste.timesquare.instantrelation.listener.RelationModelListener;
import fr.inria.aoste.timesquare.simulationpolicy.SimulationPolicyBase;
import fr.inria.aoste.timesquare.simulationpolicy.maxcardpolicy.MaxCardSimulationPolicy;
import fr.inria.aoste.timesquare.trace.util.adapter.AdapterRegistry;
import fr.inria.aoste.trace.EventOccurrence;
import fr.inria.aoste.trace.LogicalStep;
import fr.inria.aoste.trace.ModelElementReference;
import fr.inria.aoste.trace.Reference;
import fr.inria.aoste.trace.relation.IDescription;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.commons.ConcurrentModelExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.concurrentmse.Concurrent_mseFactory;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.concurrentmse.FeedbackMSE;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare.Activator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare.moc.impl.GemocInstantRelationModelGenerator;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.extensions.timesquare.moc.impl.LogicalStepHelper;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.moc.ISolver;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.utils.ccsl.QvtoTransformationPerformer;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ActionModel;
import org.eclipse.gemoc.moccml.mapping.feedback.feedback.ModelSpecificEvent;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericParallelStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenericSmallStep;
import org.eclipse.gemoc.trace.commons.model.generictrace.GenerictraceFactory;
import org.eclipse.gemoc.trace.commons.model.trace.MSE;
import org.eclipse.gemoc.trace.commons.model.trace.MSEModel;
import org.eclipse.gemoc.trace.commons.model.trace.MSEOccurrence;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.trace.commons.model.trace.TraceFactory;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionContext;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionWorkspace;
import org.osgi.framework.Bundle;

public class CcslSolver
implements ISolver {
    protected CCSLKernelSolverWrapper solverWrapper = null;
    protected URI solverInputURI = null;
    protected ArrayList<Step<?>> _lastLogicalSteps = new ArrayList();
    protected ActionModel _feedbackModel;
    protected MSEModel _MSEModel;
    protected List<LogicalStep> _intermediateResult;
    protected String _alternativeExecutionModelPath = null;
    protected GemocInstantRelationModelGenerator relationModelGenerator = null;
    protected List<ModelElementReference> listofclock;
    protected List<ModelElementReference> listofconstraint;
    protected List<EObject> listReferencedObject = new ArrayList<EObject>();
    protected List<Resource> listressource = new ArrayList<Resource>();
    protected ArrayList<OccurrenceRelation> lastOccurrenceRelations = new ArrayList();
    public List<ModelElementReference> listofassert;
    public List<IDescription> listofrelation;

    public CcslSolver() {
    }

    public CcslSolver(String specificTilmeModel) {
        this._alternativeExecutionModelPath = specificTilmeModel;
    }

    public CCSLKernelSolverWrapper getSolverWrapper() {
        return this.solverWrapper;
    }

    public ArrayList<ModelElementReference> getAllDiscreteClocks() {
        return this.solverWrapper.getClockList();
    }

    public void forbidEventOccurrence(EventOccurrence eventOccurrence) {
        this.solverWrapper.forceClockAbsence(this.getModelElementReferenceFromEventOccurrence(eventOccurrence));
    }

    public void forceEventOccurrence(EventOccurrence eventOccurrence) {
        this.solverWrapper.forceClockPresence(this.getModelElementReferenceFromEventOccurrence(eventOccurrence));
    }

    private ModelElementReference getModelElementReferenceFromEventOccurrence(EventOccurrence eventOccurrence) {
        Reference reference = eventOccurrence.getReferedElement();
        if (reference instanceof ModelElementReference) {
            ModelElementReference mer = (ModelElementReference)reference;
            return mer;
        }
        throw new RuntimeException("Refered Element of eventOccurrence should be a ModelElementReference");
    }

    private Step<?> createLogicalStep(LogicalStep res) {
        GenericParallelStep parStep = GenerictraceFactory.eINSTANCE.createGenericParallelStep();
        for (Event e : LogicalStepHelper.getTickedEvents(res)) {
            MSEOccurrence mseOccurrence = TraceFactory.eINSTANCE.createMSEOccurrence();
            for (MSE mse : this._MSEModel.getOwnedMSEs()) {
                if (!mse.getName().replace("MSE_", "").equals(e.getName().replace("evt_", ""))) continue;
                mseOccurrence.setMse(mse);
                break;
            }
            GenericSmallStep smallStep = GenerictraceFactory.eINSTANCE.createGenericSmallStep();
            smallStep.setMseoccurrence(mseOccurrence);
            parStep.getSubSteps().add((Object)smallStep);
        }
        return parStep;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "@[modelOfExecutionURI=" + this.solverInputURI + "]";
    }

    private void createSolver(IExecutionContext<?, ?, ?> context) {
        this.solverInputURI = this._alternativeExecutionModelPath == null || this._alternativeExecutionModelPath.length() == 0 ? URI.createPlatformResourceURI((String)context.getWorkspace().getMoCPath().toString(), (boolean)true) : URI.createPlatformResourceURI((String)this._alternativeExecutionModelPath, (boolean)true);
        URI feedbackURI = URI.createPlatformResourceURI((String)this.getFeedbackPathFromMSEModelPath(context.getWorkspace().getMSEModelPath()).toString(), (boolean)true);
        URI priorityURI = URI.createPlatformResourceURI((String)this.getPriorityPathFromMSEModelPath(context.getWorkspace().getMSEModelPath()).toString(), (boolean)true);
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource ccslResource = resourceSet.getResource(this.solverInputURI, true);
            EcoreUtil.resolveAll((ResourceSet)resourceSet);
            this.traceResources((ResourceSet)resourceSet);
            this.traceUnresolvedProxies((ResourceSet)resourceSet, this.solverInputURI);
            ResourceSetImpl prioResourceSet = new ResourceSetImpl();
            Resource prioResource = prioResourceSet.getResource(priorityURI, true);
            EcoreUtil.resolveAll((ResourceSet)prioResourceSet);
            this.solverWrapper = new CCSLKernelSolverWrapper();
            this.solverWrapper.getSolver().loadModel(ccslResource);
            this.solverWrapper.getSolver().loadPriorityModel(prioResource);
            this.solverWrapper.getSolver().initSimulation();
            this.solverWrapper.getSolver().setPolicy((SimulationPolicyBase)new MaxCardSimulationPolicy());
            Resource feedbackResource = resourceSet.getResource(feedbackURI, true);
            this._feedbackModel = (ActionModel)feedbackResource.getContents().get(0);
            this._MSEModel = context.getMSEModel();
        }
        catch (IOException e) {
            String errorMessage = "IOException while instantiating the CcslSolver";
            Activator.getDefault().error(errorMessage);
            Activator.getDefault().error(errorMessage, e);
        }
        catch (UnfoldingException e) {
            String errorMessage = "UnfoldingException while instantiating the CcslSolver";
            Activator.getDefault().error(errorMessage);
            Activator.getDefault().error(errorMessage, e);
        }
        catch (SolverException e) {
            String errorMessage = "SolverException while instantiating the CcslSolver";
            Activator.getDefault().error(errorMessage);
            Activator.getDefault().error(errorMessage, e);
        }
        catch (SimulationException e) {
            String errorMessage = "SimulationException while instantiating the CcslSolver";
            Activator.getDefault().error(errorMessage);
            Activator.getDefault().error(errorMessage, e);
        }
        this.initRelationModel();
    }

    private void traceUnresolvedProxies(ResourceSet resourceSet, URI solverInputURI) {
        Map unresolvedProxies = EcoreUtil.UnresolvedProxyCrossReferencer.find((ResourceSet)resourceSet);
        if (unresolvedProxies.size() != 0) {
            Activator.getDefault().warn("There are unresolved proxies in " + solverInputURI + ", the first is " + unresolvedProxies.entrySet().toArray()[0]);
            Activator.getDefault().warn("Please verify that you don't have the modeling nature for your project so that the aird indexed all the resources, (it must not contain resolve warning).");
        }
    }

    private void traceResources(ResourceSet resourceSet) {
        Activator.getDefault().info("Input resources:");
        for (Resource r : resourceSet.getResources()) {
            Activator.getDefault().info(r.getURI().toString());
        }
    }

    public List<Step<?>> computeAndGetPossibleLogicalSteps() {
        try {
            this._intermediateResult = this.solverWrapper.computeAndGetPossibleLogicalSteps();
            this._lastLogicalSteps.clear();
            for (LogicalStep lsFromTimesquare : this._intermediateResult) {
                Step<?> lsFromTrace = this.createLogicalStep(lsFromTimesquare);
                this._lastLogicalSteps.add(lsFromTrace);
            }
            return new ArrayList(this._lastLogicalSteps);
        }
        catch (NoBooleanSolution e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        catch (SolverException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        catch (SimulationException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        return new ArrayList();
    }

    public List<Step<?>> updatePossibleLogicalSteps() {
        try {
            List intermediateResult = this.solverWrapper.updatePossibleLogicalSteps();
            this._lastLogicalSteps.clear();
            for (LogicalStep lsFromTimesquare : intermediateResult) {
                Step<?> lsFromTrace = this.createLogicalStep(lsFromTimesquare);
                this._lastLogicalSteps.add(lsFromTrace);
            }
            return new ArrayList(this._lastLogicalSteps);
        }
        catch (NoBooleanSolution e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        catch (SolverException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        catch (SimulationException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        return new ArrayList();
    }

    public Step<?> proposeLogicalStep() {
        int index = this.solverWrapper.proposeLogicalStepByIndex();
        Step<?> result = null;
        if (this._lastLogicalSteps.size() > index) {
            result = this._lastLogicalSteps.get(index);
        }
        return result;
    }

    public void applyLogicalStep(Step<?> logicalStep) {
        try {
            int index = this._lastLogicalSteps.indexOf(logicalStep);
            this.solverWrapper.applyLogicalStepByIndex(index);
            this.resolveOccurrenceRelations(this._intermediateResult.get(index));
        }
        catch (SolverException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
        catch (SimulationException e) {
            Activator.getDefault().error(e.getMessage(), e);
        }
    }

    public byte[] getState() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ObjectOutputStream objOut = new ObjectOutputStream(out);
            objOut.writeObject(this.solverWrapper.getSolver().getCurrentState());
            return out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setState(byte[] serializableModel) {
        ByteArrayInputStream out = new ByteArrayInputStream(serializableModel);
        try {
            ObjectInputStream objOut = new ObjectInputStream(out);
            Object o = objOut.readObject();
            this.solverWrapper.getSolver().setCurrentState((CCSLConstraintState)o);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.solverWrapper.getSolver().clearStepData();
    }

    public void revertForceClockEffect() {
        try {
            this.solverWrapper.revertForceClockEffect();
        }
        catch (SimulationException e) {
            e.printStackTrace();
        }
    }

    public void initialize(IConcurrentExecutionContext context) {
        if (context instanceof ConcurrentModelExecutionContext) {
            this._alternativeExecutionModelPath = ((ConcurrentModelExecutionContext)context).alternativeExecutionModelPath;
        }
        this.createSolver((IExecutionContext<?, ?, ?>)context);
    }

    public void prepareBeforeModelLoading(IConcurrentExecutionContext context) {
        this.generateMoC(context);
    }

    private void generateMoC(IConcurrentExecutionContext context) {
        String transformationPath;
        IFile feedbackFile;
        IExecutionWorkspace workspace = context.getWorkspace();
        boolean mustGenerate = false;
        IFile mocFile = ResourcesPlugin.getWorkspace().getRoot().getFile(workspace.getMoCPath());
        if (!mocFile.exists() || ResourcesPlugin.getWorkspace().getRoot().getFile(workspace.getModelPath()).getLocalTimeStamp() > ResourcesPlugin.getWorkspace().getRoot().getFile(workspace.getMoCPath()).getLocalTimeStamp()) {
            mustGenerate = true;
        }
        if (!(feedbackFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getFeedbackPathFromMSEModelPath(workspace.getMSEModelPath()))).exists() || ResourcesPlugin.getWorkspace().getRoot().getFile(workspace.getModelPath()).getLocalTimeStamp() > ResourcesPlugin.getWorkspace().getRoot().getFile(this.getFeedbackPathFromMSEModelPath(workspace.getMSEModelPath())).getLocalTimeStamp()) {
            mustGenerate = true;
        }
        if ((transformationPath = ((ConcurrentLanguageDefinitionExtension)context.getLanguageDefinitionExtension()).getQVTOPath()) != null && transformationPath.length() != 0) {
            int bundleNameEnd = transformationPath.indexOf(47, 1);
            String bundleName = transformationPath.substring(1, bundleNameEnd);
            Bundle bundle = Platform.getBundle((String)bundleName);
            if (bundle != null) {
                URL bundleFileURL = bundle.getEntry(transformationPath.substring(bundleNameEnd));
                try {
                    URL fileURL = FileLocator.toFileURL((URL)bundleFileURL);
                    File transformationFile = new File(fileURL.getFile());
                    if (feedbackFile.exists() && transformationFile.lastModified() > ResourcesPlugin.getWorkspace().getRoot().getFile(this.getFeedbackPathFromMSEModelPath(workspace.getMSEModelPath())).getLocalTimeStamp()) {
                        mustGenerate = true;
                    }
                }
                catch (IOException e) {
                    Activator.getDefault().error("QVTo file " + transformationPath + " not found, please verify your language specification", e);
                }
            }
        } else {
            Activator.getDefault().error("QVTo file  not correctly specified in plugin.xml, please verify your language specification");
            mustGenerate = false;
        }
        if (mustGenerate) {
            QvtoTransformationPerformer performer = new QvtoTransformationPerformer();
            performer.run((ResourceSet)new ResourceSetImpl(), "platform:/plugin" + transformationPath, ((IConcurrentRunConfiguration)context.getRunConfiguration()).getExecutedModelURI().toString(), "platform:/resource" + workspace.getMoCPath().toString(), "platform:/resource" + this.getFeedbackPathFromMSEModelPath(workspace.getMSEModelPath()).toString(), "platform:/resource" + this.getPriorityPathFromMSEModelPath(workspace.getMSEModelPath()).toString());
            this.generateMSEModel(context);
        }
    }

    private void generateMSEModel(IConcurrentExecutionContext context) {
        URI feedbackURI = URI.createPlatformResourceURI((String)this.getFeedbackPathFromMSEModelPath(context.getWorkspace().getMSEModelPath()).toString(), (boolean)true);
        URI mseModelURI = URI.createPlatformResourceURI((String)context.getWorkspace().getMSEModelPath().toString(), (boolean)true);
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource feedBackRes = rs.getResource(feedbackURI, true);
        Resource mseRes = rs.createResource(mseModelURI);
        mseRes.getContents().clear();
        MSEModel mseModel = TraceFactory.eINSTANCE.createMSEModel();
        mseRes.getContents().add((Object)mseModel);
        ActionModel feedbackModel = (ActionModel)feedBackRes.getContents().get(0);
        if (feedbackModel != null) {
            for (ModelSpecificEvent feedbackModelSpecificEvent : feedbackModel.getEvents()) {
                FeedbackMSE feedbackMSE = Concurrent_mseFactory.eINSTANCE.createFeedbackMSE();
                feedbackMSE.setFeedbackModelSpecificEvent(feedbackModelSpecificEvent);
                feedbackMSE.setName(feedbackModelSpecificEvent.getName());
                mseModel.getOwnedMSEs().add((Object)feedbackMSE);
            }
        }
        try {
            mseRes.save(null);
        }
        catch (IOException e) {
            Activator.getDefault().error("Problem creating MSEModel from feedback model", e);
        }
    }

    public void dispose() {
        this.solverWrapper = null;
    }

    public IPath getFeedbackPathFromMSEModelPath(IPath mseModelPath) {
        IPath msePath = mseModelPath.removeFileExtension().addFileExtension("feedback");
        return msePath;
    }

    public IPath getPriorityPathFromMSEModelPath(IPath mseModelPath) {
        IPath msePath = mseModelPath.removeFileExtension().addFileExtension("prioritymodel");
        return msePath;
    }

    private List<IDescription> getRelationDescription() {
        List<Object> lst = new ArrayList<IDescription>();
        try {
            EObject eo = (EObject)((Resource)this.solverWrapper.getResourceSet().getResources().get(0)).getContents().get(0);
            this.relationModelGenerator = new GemocInstantRelationModelGenerator();
            if (this.relationModelGenerator == null) {
                return lst;
            }
            this.relationModelGenerator.setListClock(this.listofclock);
            this.relationModelGenerator.setListRelation(this.listofconstraint);
            this.relationModelGenerator.extract(eo);
            lst = this.relationModelGenerator.getDescription();
        }
        catch (Throwable e) {
            System.err.println(e);
        }
        return lst;
    }

    public void initRelationModel() {
        this.relationModelGenerator = null;
        CCSLKernelSolverWrapper isolver = this.solverWrapper;
        if (isolver == null) {
            throw new RuntimeException("in CCSLSolver::resolveOccurrenceRelations, the solver has not been instantiated yet");
        }
        this.listofclock = Collections.unmodifiableList(isolver.getClockList());
        this.listofassert = Collections.unmodifiableList(isolver.getAssertList());
        this.listofconstraint = Collections.unmodifiableList(isolver.getConstraint());
        this.listofrelation = Collections.unmodifiableList(this.getRelationDescription());
        this.listReferencedObject = new ArrayList<EObject>();
        for (ModelElementReference r : this.listofclock) {
            AdapterRegistry.getAdapter((EObject)r).fillWithReferencedElements((EObject)r, this.listReferencedObject);
        }
        this.listReferencedObject = Collections.unmodifiableList(this.listReferencedObject);
        this.listressource = new ArrayList<Resource>();
        for (EObject el : this.listReferencedObject) {
            Resource rs = el.eResource();
            if (rs == null || this.listressource.contains(rs)) continue;
            this.listressource.add(rs);
        }
        this.listressource = Collections.unmodifiableList(this.listressource);
    }

    public List<OccurrenceRelation> resolveOccurrenceRelations(LogicalStep step) {
        if (((RelationModelListener)this.relationModelGenerator.irml).lrelation.size() == 0) {
            this.relationModelGenerator.addClockConstraint(step);
        }
        this.relationModelGenerator.resolve(step);
        this.lastOccurrenceRelations.addAll(this.relationModelGenerator.getLastOccurrenceRelations());
        return null;
    }

    public List<OccurrenceRelation> getLastOccurrenceRelations() {
        return this.lastOccurrenceRelations;
    }

    public void setExecutableModelResource(Resource execModelResource) {
        Class<?> clazz = ((EObject)execModelResource.getContents().get(0)).getClass();
        for (Resource r : this._MSEModel.eResource().getResourceSet().getResources()) {
            if (((EObject)r.getContents().get(0)).getClass() != clazz) continue;
            this._MSEModel.eResource().getResourceSet().getResources().remove((Object)r);
            this.doChangeExecModel(execModelResource);
            return;
        }
        this.doChangeExecModel(execModelResource);
    }

    private void doChangeExecModel(Resource execModelResource) {
        final Resource r = execModelResource;
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Factory.INSTANCE.getEditingDomain(this._MSEModel.eResource().getResourceSet());
        CommandStack commandStack = editingDomain.getCommandStack();
        commandStack.execute((Command)new RecordingCommand(editingDomain){

            protected void doExecute() {
                CcslSolver.this._MSEModel.eResource().getResourceSet().getResources().add((Object)r);
            }
        });
    }
}

