/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse;

import java.util.function.Consumer;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.dse.OperationExecution;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionContext;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionEngine;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentExecutionPlatform;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.core.IConcurrentRunConfiguration;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.dsa.executors.CodeExecutionException;
import org.eclipse.gemoc.executionframework.engine.Activator;
import org.eclipse.gemoc.trace.commons.model.trace.SmallStep;
import org.eclipse.gemoc.trace.commons.model.trace.Step;

public class SynchroneExecution
extends OperationExecution {
    public SynchroneExecution(SmallStep<?> smallStep, IConcurrentExecutionEngine engine, Consumer<Step<?>> beforeStep, Runnable afterStep) {
        super(smallStep, engine, beforeStep, afterStep);
    }

    @Override
    public void run() {
        this.beforeStepCallback((Step<?>)this.getSmallStep());
        Object res = this.callExecutor();
        this.setResult(res);
        try {
            this.applyAnimationTime();
        }
        catch (InterruptedException e) {
            Activator.getDefault().error("Exception received " + e.getMessage(), (Throwable)e);
        }
        this.afterStepCallback();
    }

    private Object callExecutor() {
        Object res = null;
        try {
            res = ((IConcurrentExecutionPlatform)this.getExecutionContext().getExecutionPlatform()).getCodeExecutor().execute(this.getSmallStep().getMseoccurrence());
        }
        catch (CodeExecutionException e) {
            Activator.getDefault().error("Exception received " + e.getMessage(), (Throwable)e);
        }
        return res;
    }

    private void applyAnimationTime() throws InterruptedException {
        int animationDelay = ((IConcurrentRunConfiguration)((IConcurrentExecutionContext)this.getEngine().getExecutionContext()).getRunConfiguration()).getAnimationDelay();
        if (animationDelay != 0) {
            Thread.sleep(animationDelay);
        }
    }
}

