/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.moccml.mapping.xtext.attributes;

import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.internal.compatibility.EMF_2_9;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.internal.scoping.AbstractAttribution;
import org.eclipse.ocl.pivot.internal.scoping.EnvironmentView;
import org.eclipse.ocl.pivot.internal.scoping.ScopeView;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.xtext.base.cs2as.ValidationDiagnostic;
import org.eclipse.ocl.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.xtext.basecs.BaseCSPackage;
import org.eclipse.ocl.xtext.basecs.ImportCS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

public class ImportStatementAttribution
extends AbstractAttribution {
    public static final ImportStatementAttribution INSTANCE = new ImportStatementAttribution();

    public ScopeView computeLookup(EObject target, EnvironmentView environmentView, ScopeView scopeView) {
        ImportCS targetElement = (ImportCS)target;
        ImportAdapter adapter = (ImportAdapter)((Object)ClassUtil.getAdapter(ImportAdapter.class, (Notifier)targetElement));
        if (adapter == null) {
            adapter = new ImportAdapter();
            targetElement.eAdapters().add((Object)adapter);
        }
        return adapter.computeLookup(targetElement, environmentView, scopeView);
    }

    public EReference getEReference() {
        EReference importCsNamespace = BaseCSPackage.Literals.IMPORT_CS__REFERRED_NAMESPACE;
        return importCsNamespace;
    }

    public String getMessage(EObject context, String linkText) {
        ImportAdapter adapter = (ImportAdapter)((Object)ClassUtil.getAdapter(ImportAdapter.class, (Notifier)context));
        if (adapter != null) {
            String message = adapter.getMessage();
            return NLS.bind((String)PivotMessagesInternal.UnresolvedImport_ERROR_, (Object)linkText, (Object)message);
        }
        return null;
    }

    private static class ImportAdapter
    extends AdapterImpl {
        private URI uri = null;
        private Element importedElement = null;
        private Throwable throwable = null;

        private ImportAdapter() {
        }

        public ScopeView computeLookup(ImportCS targetElement, EnvironmentView environmentView, ScopeView scopeView) {
            String name = environmentView.getName();
            if (name != null) {
                Resource importedResource;
                EList errors;
                this.importModel(targetElement, environmentView);
                Element importedElement2 = this.importedElement;
                if (importedElement2 != null && (errors = (importedResource = importedElement2.eResource()).getErrors()).size() == 0) {
                    environmentView.addElement(name, importedElement2);
                }
            } else {
                Map ePackageNsURIToGenModelLocationMap = EMF_2_9.EcorePlugin.getEPackageNsURIToGenModelLocationMap((boolean)false);
                for (String key : ePackageNsURIToGenModelLocationMap.keySet()) {
                    environmentView.addElement(key, (Element)environmentView.getEnvironmentFactory().getMetamodelManager().getOclType("void"));
                }
            }
            return null;
        }

        public String getMessage() {
            return this.throwable != null ? this.throwable.getMessage() : null;
        }

        protected void importModel(ImportCS target, EnvironmentView environmentView) {
            URI uri2;
            String name = environmentView.getName();
            if (name == null) {
                return;
            }
            BaseCSResource csResource = (BaseCSResource)target.eResource();
            try {
                URI newURI = URI.createURI((String)name);
                newURI = csResource.resolve(newURI);
                if (newURI.equals(this.uri)) {
                    return;
                }
                uri2 = this.uri = newURI;
                this.importedElement = null;
                this.throwable = null;
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
                return;
            }
            catch (Exception e) {
                this.throwable = e;
                return;
            }
            try {
                EList errors;
                PivotMetamodelManager metaModelManager = environmentView.getEnvironmentFactory().getMetamodelManager();
                this.importedElement = metaModelManager.loadResource(uri2, target.getName(), null);
                Resource importedResource = this.importedElement.eResource();
                EList warnings = importedResource.getWarnings();
                if (warnings.size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)(String.valueOf(PivotMessagesInternal.WarningsInURI) + this.uri), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getWarnings().add((Object)resourceDiagnostic);
                }
                if ((errors = importedResource.getErrors()).size() > 0) {
                    ICompositeNode node = NodeModelUtils.getNode((EObject)target);
                    String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)(String.valueOf(PivotMessagesInternal.ErrorsInURI) + this.uri), (String)"\n\t");
                    ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                    csResource.getErrors().add((Object)resourceDiagnostic);
                }
            }
            catch (WrappedException e) {
                this.throwable = e.exception();
            }
            catch (Exception e) {
                this.throwable = e;
            }
        }

        public boolean isAdapterForType(Object type) {
            return type == ImportAdapter.class;
        }
    }
}

