/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.Activator;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.command.AddDebugLayerHandler;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.AddDebugRepresentationPage;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.DebugRepresentationSelectionPage;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.NewViewPointProjectPage;
import org.eclipse.gemoc.xdsmlframework.extensions.sirius.wizards.pages.SelectDiagramDefinitionPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.sirius.business.api.query.ViewpointQuery;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramExtensionDescription;
import org.eclipse.sirius.ui.tools.api.project.ViewpointSpecificationProject;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class NewGemocDebugRepresentationWizard
extends Wizard
implements IWorkbenchWizard {
    private String initialLanguageName = "myLanguage";
    private String initialProjectName = this.initialLanguageName.toLowerCase();
    private DebugRepresentationSelectionPage debugRepresentationSelectionPage = new DebugRepresentationSelectionPage(this);
    private SelectDiagramDefinitionPage selectDiagramDefinitionPage = new SelectDiagramDefinitionPage(this);
    private NewViewPointProjectPage newViewPointProjectPage = new NewViewPointProjectPage(this);
    private AddDebugRepresentationPage addDebugRepresentationPage = new AddDebugRepresentationPage(this);

    public NewGemocDebugRepresentationWizard() {
        this.setWindowTitle("Create GEMOC debug representation");
    }

    public void addPages() {
        this.addPage((IWizardPage)this.debugRepresentationSelectionPage);
        this.addPage((IWizardPage)this.selectDiagramDefinitionPage);
        this.addPage((IWizardPage)this.newViewPointProjectPage);
        this.addPage((IWizardPage)this.addDebugRepresentationPage);
    }

    public boolean canFinish() {
        boolean newLayer;
        boolean newViewpoint = this.debugRepresentationSelectionPage.getSelected() == 0 && this.newViewPointProjectPage.isPageComplete() && this.addDebugRepresentationPage.isPageComplete();
        boolean newViewpointExtension = this.debugRepresentationSelectionPage.getSelected() == 1 && this.selectDiagramDefinitionPage.isPageComplete() && this.newViewPointProjectPage.isPageComplete() && this.addDebugRepresentationPage.isPageComplete();
        boolean bl = newLayer = this.debugRepresentationSelectionPage.getSelected() == 2 && this.selectDiagramDefinitionPage.isPageComplete() && this.addDebugRepresentationPage.isPageComplete();
        return newViewpoint || newViewpointExtension || newLayer;
    }

    public boolean performFinish() {
        FinishRunnable finisher = new FinishRunnable();
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)finisher);
        }
        catch (InvocationTargetException e) {
            Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
        }
        catch (InterruptedException e) {
            Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
        }
        return finisher.getResult();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public DebugRepresentationSelectionPage getDebugRepresentationSelectionPage() {
        return this.debugRepresentationSelectionPage;
    }

    public SelectDiagramDefinitionPage getSelectDiagramDefinitionPage() {
        return this.selectDiagramDefinitionPage;
    }

    public NewViewPointProjectPage getNewViewPointProjectPage() {
        return this.newViewPointProjectPage;
    }

    public AddDebugRepresentationPage getAddDebugRepresentationPage() {
        return this.addDebugRepresentationPage;
    }

    public void setInitialProjectName(String value) {
        this.initialProjectName = value;
    }

    public void setInitialLanguageName(String value) {
        this.initialLanguageName = value;
    }

    public String getInitialProjectName() {
        return this.initialProjectName;
    }

    public String getInitialLanguageName() {
        return this.initialLanguageName;
    }

    private class FinishRunnable
    implements IRunnableWithProgress {
        boolean result = true;

        private FinishRunnable() {
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            if (NewGemocDebugRepresentationWizard.this.getDebugRepresentationSelectionPage().getSelected() == 0) {
                try {
                    String layerName = NewGemocDebugRepresentationWizard.this.getAddDebugRepresentationPage().getLayerName();
                    IProject project = ViewpointSpecificationProject.createNewViewpointSpecificationProject((String)NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getProjectName(), (String)NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getViewpointSpecificationModelName());
                    Group group = this.getGroup();
                    DiagramDescription diagramDescription = this.createDiagramDescription(group, NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getViewpointName(), NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getDiagramName());
                    String projectName = project.getName();
                    IFolder serviceFolder = project.getFolder((IPath)new Path("src/" + projectName.replaceAll("\\.", "/") + "/services"));
                    String languageName = diagramDescription.getName();
                    String qualifiedServiceClassName = AddDebugLayerHandler.getOrCreateServiceClass(serviceFolder, projectName, languageName, layerName, monitor);
                    AddDebugLayerHandler.emfModifications(monitor, layerName, diagramDescription, languageName, qualifiedServiceClassName);
                    AddDebugLayerHandler.updateManifest(project);
                }
                catch (CoreException e) {
                    Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
                    this.result = false;
                }
                catch (IOException e) {
                    Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
                    this.result = false;
                }
            } else if (NewGemocDebugRepresentationWizard.this.getDebugRepresentationSelectionPage().getSelected() == 1) {
                try {
                    String layerName = NewGemocDebugRepresentationWizard.this.getAddDebugRepresentationPage().getLayerName();
                    IProject project = ViewpointSpecificationProject.createNewViewpointSpecificationProject((String)NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getProjectName(), (String)NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getViewpointSpecificationModelName());
                    Group group = this.getGroup();
                    DiagramExtensionDescription diagramExtensionDescription = this.createDiagramExtensionDescription(group, NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getViewpointName(), NewGemocDebugRepresentationWizard.this.getNewViewPointProjectPage().getDiagramName(), NewGemocDebugRepresentationWizard.this.getSelectDiagramDefinitionPage().getSelectedDiagram());
                    String projectName = project.getName();
                    IFolder serviceFolder = project.getFolder((IPath)new Path("src/" + projectName.replaceAll("\\.", "/").toLowerCase() + "/services"));
                    String languageName = diagramExtensionDescription.getName();
                    String qualifiedServiceClassName = AddDebugLayerHandler.getOrCreateServiceClass(serviceFolder, projectName, languageName, layerName, monitor);
                    AddDebugLayerHandler.emfModifications(monitor, layerName, diagramExtensionDescription, languageName, qualifiedServiceClassName);
                    AddDebugLayerHandler.updateManifest(project);
                }
                catch (CoreException e) {
                    Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
                    this.result = false;
                }
                catch (IOException e) {
                    Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
                    this.result = false;
                }
            } else if (NewGemocDebugRepresentationWizard.this.getDebugRepresentationSelectionPage().getSelected() == 2) {
                try {
                    String layerName = NewGemocDebugRepresentationWizard.this.getAddDebugRepresentationPage().getLayerName();
                    DiagramDescription diagramDescription = NewGemocDebugRepresentationWizard.this.getSelectDiagramDefinitionPage().getSelectedDiagram();
                    String languageName = diagramDescription.getName();
                    IFile file = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(diagramDescription.eResource().getURI().toPlatformString(true));
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)new FileEditorInput(file), PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(file.getName()).getId());
                    Group group = this.getGroup();
                    block9: for (Viewpoint viewpoint : group.getOwnedViewpoints()) {
                        for (RepresentationDescription representation : viewpoint.getOwnedRepresentations()) {
                            if (!diagramDescription.getName().equals(representation.getName())) continue;
                            diagramDescription = (DiagramDescription)representation;
                            continue block9;
                        }
                    }
                    IProject project = file.getProject();
                    String projectName = project.getName();
                    IFolder serviceFolder = project.getFolder((IPath)new Path("src/" + projectName.replaceAll("\\.", "/").toLowerCase() + "/services"));
                    String qualifiedServiceClassName = AddDebugLayerHandler.getOrCreateServiceClass(serviceFolder, projectName, languageName, layerName, monitor);
                    AddDebugLayerHandler.emfModifications(monitor, layerName, diagramDescription, languageName, qualifiedServiceClassName);
                    AddDebugLayerHandler.updateManifest(project);
                }
                catch (IOException e) {
                    Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
                    this.result = false;
                }
                catch (CoreException e) {
                    Activator.getMessagingSystem().error(e.getMessage(), "org.eclipse.gemoc.xdsmlframework.extensions.sirius", (Throwable)e);
                    this.result = false;
                }
            }
        }

        private DiagramExtensionDescription createDiagramExtensionDescription(final Group group, final String viewpointName, final String diagramName, final DiagramDescription diagramDescription) {
            EditingDomain editingDomain = ((IEditingDomainProvider)group.eResource().getResourceSet()).getEditingDomain();
            ChangeCommand recordingCommand = new ChangeCommand((Notifier)group.eResource()){
                private DiagramExtensionDescription diagramExtensionDesctiption;

                protected void doExecute() {
                    Viewpoint viewpoint = DescriptionPackage.eINSTANCE.getDescriptionFactory().createViewpoint();
                    viewpoint.setName(viewpointName);
                    group.getOwnedViewpoints().add((Object)viewpoint);
                    this.diagramExtensionDesctiption = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createDiagramExtensionDescription();
                    this.diagramExtensionDesctiption.setName(diagramName);
                    this.diagramExtensionDesctiption.setViewpointURI(((URI)new ViewpointQuery((Viewpoint)diagramDescription.eContainer()).getViewpointURI().get()).toString());
                    this.diagramExtensionDesctiption.setRepresentationName(diagramDescription.getName());
                    viewpoint.getOwnedRepresentationExtensions().add((Object)this.diagramExtensionDesctiption);
                }

                public Collection<?> getResult() {
                    ArrayList<DiagramExtensionDescription> res = new ArrayList<DiagramExtensionDescription>();
                    res.add(this.diagramExtensionDesctiption);
                    return res;
                }
            };
            editingDomain.getCommandStack().execute((Command)recordingCommand);
            return (DiagramExtensionDescription)recordingCommand.getResult().iterator().next();
        }

        private Group getGroup() {
            Group res;
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof IEditingDomainProvider) {
                EditingDomain editingDomain = ((IEditingDomainProvider)editor).getEditingDomain();
                ResourceSet resourceSet = editingDomain.getResourceSet();
                Group group = null;
                block0: for (Resource resource : resourceSet.getResources()) {
                    for (EObject eObj : resource.getContents()) {
                        if (!(eObj instanceof Group)) continue;
                        group = (Group)eObj;
                        continue block0;
                    }
                }
                res = group;
            } else {
                res = null;
            }
            return res;
        }

        private DiagramDescription createDiagramDescription(final Group group, final String viewpointName, final String diagramName) {
            EditingDomain editingDomain = ((IEditingDomainProvider)group.eResource().getResourceSet()).getEditingDomain();
            ChangeCommand recordingCommand = new ChangeCommand((Notifier)group.eResource()){
                private DiagramDescription diagramDesctiption;

                protected void doExecute() {
                    Viewpoint viewpoint = DescriptionPackage.eINSTANCE.getDescriptionFactory().createViewpoint();
                    viewpoint.setName(viewpointName);
                    group.getOwnedViewpoints().add((Object)viewpoint);
                    this.diagramDesctiption = org.eclipse.sirius.diagram.description.DescriptionPackage.eINSTANCE.getDescriptionFactory().createDiagramDescription();
                    this.diagramDesctiption.setName(diagramName);
                    viewpoint.getOwnedRepresentations().add((Object)this.diagramDesctiption);
                }

                public Collection<?> getResult() {
                    ArrayList<DiagramDescription> res = new ArrayList<DiagramDescription>();
                    res.add(this.diagramDesctiption);
                    return res;
                }
            };
            editingDomain.getCommandStack().execute((Command)recordingCommand);
            return (DiagramDescription)recordingCommand.getResult().iterator().next();
        }

        public boolean getResult() {
            return this.result;
        }
    }
}

