/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.ui.edit.api.part;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IClippingStrategy;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.editpolicies.ResizableEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.DropRequest;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.util.Proxy;
import org.eclipse.gmf.runtime.diagram.core.listener.NotificationListener;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.BorderedBorderItemEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.figures.IBorderItemLocator;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DiagramPackage;
import org.eclipse.sirius.diagram.LabelPosition;
import org.eclipse.sirius.diagram.NodeStyle;
import org.eclipse.sirius.diagram.ui.business.api.query.ViewQuery;
import org.eclipse.sirius.diagram.ui.business.api.view.SiriusLayoutDataManager;
import org.eclipse.sirius.diagram.ui.business.internal.query.RequestQuery;
import org.eclipse.sirius.diagram.ui.business.internal.view.ShowingViewUtil;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramBorderNodeEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IDiagramNameEditPart;
import org.eclipse.sirius.diagram.ui.edit.api.part.IStyleEditPart;
import org.eclipse.sirius.diagram.ui.edit.internal.part.AbstractDiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.CommonEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DefaultDirectEditOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramBorderNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramElementEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.DiagramNodeEditPartOperation;
import org.eclipse.sirius.diagram.ui.edit.internal.part.EditStatusUpdater;
import org.eclipse.sirius.diagram.ui.edit.internal.part.PortLayoutHelper;
import org.eclipse.sirius.diagram.ui.edit.internal.validators.ResizeValidator;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SiriusDecoratorEditPolicy;
import org.eclipse.sirius.diagram.ui.graphical.edit.policies.SpecificBorderItemSelectionEditPolicy;
import org.eclipse.sirius.diagram.ui.internal.view.factories.ViewLocationHint;
import org.eclipse.sirius.diagram.ui.provider.Messages;
import org.eclipse.sirius.diagram.ui.tools.api.figure.DBorderedNodeFigure;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleAwareClippingStrategy;
import org.eclipse.sirius.diagram.ui.tools.api.figure.FoldingToggleImageFigure;
import org.eclipse.sirius.diagram.ui.tools.api.layout.LayoutUtils;
import org.eclipse.sirius.diagram.ui.tools.api.permission.EditPartAuthorityListener;
import org.eclipse.sirius.diagram.ui.tools.internal.ruler.SiriusSnapToHelperUtil;
import org.eclipse.sirius.diagram.ui.tools.internal.ui.SiriusDragEditPartsTrackerEx;
import org.eclipse.sirius.ecore.extender.business.api.permission.IAuthorityListener;
import org.eclipse.sirius.ecore.extender.business.api.permission.IPermissionAuthority;
import org.eclipse.sirius.ecore.extender.business.api.permission.PermissionAuthorityRegistry;
import org.eclipse.sirius.ext.gmf.runtime.editpolicies.SiriusSnapFeedbackPolicy;
import org.eclipse.swt.graphics.Image;

public abstract class AbstractDiagramBorderNodeEditPart
extends BorderedBorderItemEditPart
implements IDiagramBorderNodeEditPart {
    protected EditPartAuthorityListener authListener = new EditPartAuthorityListener(this);
    private NotificationListener adapterDiagramElement;
    private NotificationListener editModeListener = new EditStatusUpdater(this);

    public AbstractDiagramBorderNodeEditPart(View view) {
        super(view);
    }

    protected NodeFigure createNodeFigure() {
        DBorderedNodeFigure nodeFigure = new DBorderedNodeFigure((IFigure)this.createMainFigure());
        DiagramBorderNodeEditPartOperation.updateAuthorizedSide(nodeFigure, this);
        nodeFigure.getBorderItemContainer().add((IFigure)new FoldingToggleImageFigure(this));
        nodeFigure.getBorderItemContainer().setClippingStrategy((IClippingStrategy)new FoldingToggleAwareClippingStrategy());
        return nodeFigure;
    }

    protected void registerModel() {
        super.registerModel();
        DiagramElementEditPartOperation.registerModel(this);
    }

    protected void unregisterModel() {
        super.unregisterModel();
        DiagramElementEditPartOperation.unregisterModel(this);
    }

    protected void handleNotificationEvent(Notification notification) {
        DiagramElementEditPartOperation.handleNotificationEvent(this, notification);
        super.handleNotificationEvent(notification);
        AbstractDiagramNodeEditPartOperation.handleNotificationEvent(this, notification);
        DiagramBorderNodeEditPartOperation.handleNotificationEvent(this, notification);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        AbstractDiagramNodeEditPartOperation.createDefaultEditPolicies(this);
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SiriusSnapFeedbackPolicy());
        this.removeEditPolicy("DecorationPolicy");
        this.installEditPolicy("DecorationPolicy", (EditPolicy)new SiriusDecoratorEditPolicy());
    }

    @Override
    public NotificationListener getEAdapterDiagramElement() {
        if (this.adapterDiagramElement == null) {
            this.adapterDiagramElement = DiagramElementEditPartOperation.createEApdaterDiagramElement(this);
        }
        return this.adapterDiagramElement;
    }

    @Override
    public NotificationListener getEditModeListener() {
        return this.editModeListener;
    }

    @Override
    public IStyleEditPart getStyleEditPart() {
        return DiagramElementEditPartOperation.getStyleEditPart(this);
    }

    @Override
    public List<EObject> resolveAllSemanticElements() {
        return DiagramElementEditPartOperation.resolveAllSemanticElements(this);
    }

    @Override
    public DDiagramElement resolveDiagramElement() {
        return DiagramElementEditPartOperation.resolveDiagramElement(this);
    }

    @Override
    public EObject resolveTargetSemanticElement() {
        return DiagramElementEditPartOperation.resolveTargetSemanticElement(this);
    }

    @Override
    public EditPartAuthorityListener getEditPartAuthorityListener() {
        return this.authListener;
    }

    public void activate() {
        if (!this.isActive()) {
            IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
            auth.addAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
            super.activate();
            DiagramElementEditPartOperation.activate(this);
        }
        this.getEditPartAuthorityListener().refreshEditMode();
    }

    public void enableEditMode() {
        if (!this.getEditPartAuthorityListener().isLocked()) {
            super.enableEditMode();
        }
    }

    public void deactivate() {
        DiagramElementEditPartOperation.deactivate(this);
        IPermissionAuthority auth = PermissionAuthorityRegistry.getDefault().getPermissionAuthority(this.getEditingDomain().getResourceSet());
        auth.removeAuthorityListener((IAuthorityListener)this.getEditPartAuthorityListener());
        if (this.isActive()) {
            super.deactivate();
        }
    }

    public void refresh() {
        super.refresh();
        List children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            EditPart editPart = (EditPart)children.get(i);
            editPart.refresh();
            ++i;
        }
    }

    protected void refreshChildren() {
        super.refreshChildren();
        this.refreshVisuals();
    }

    protected List getModelChildren() {
        DNode node;
        DDiagramElement diagramElement;
        List<View> modelChildren = ShowingViewUtil.getModelChildren(this.getModel());
        if (!modelChildren.isEmpty() && (diagramElement = this.resolveDiagramElement()) instanceof DNode && (((NodeStyle)(node = (DNode)diagramElement).getStyle()).getLabelPosition() == LabelPosition.NODE_LITERAL || StringUtil.isEmpty((String)node.getName()))) {
            DiagramNodeEditPartOperation.removeLabel(this, modelChildren);
        }
        return modelChildren;
    }

    protected void addNotationalListeners() {
        ViewQuery viewQuery;
        Optional<DDiagram> diagram;
        super.addNotationalListeners();
        if (this.hasNotationView() && (diagram = (viewQuery = new ViewQuery((View)this.getModel())).getDDiagram()).isPresent()) {
            this.addListenerFilter("ShowingMode", (NotificationListener)this, (EObject)diagram.get(), (EStructuralFeature)DiagramPackage.eINSTANCE.getDDiagram_IsInShowingMode());
        }
    }

    protected void removeNotationalListeners() {
        super.removeNotationalListeners();
        this.removeListenerFilter("ShowingMode");
    }

    protected void setVisibility(boolean vis) {
        ShowingViewUtil.setVisibility((AbstractGraphicalEditPart)this, vis, 0, this.getFlag(8));
    }

    protected List getModelSourceConnections() {
        return ShowingViewUtil.getSourceConnectionsConnectingVisibleViews((View)this.getModel());
    }

    protected void setConnectionsVisibility(boolean visibility) {
        ShowingViewUtil.setConnectionsVisibility((AbstractGraphicalEditPart)this, (View)this.getModel(), 0, visibility);
    }

    protected List getModelTargetConnections() {
        return ShowingViewUtil.getTargetConnectionsConnectingVisibleViews((View)this.getModel());
    }

    @Override
    public IBorderItemLocator createBorderItemLocator(IFigure figure, DDiagramElement vpElementBorderItem) {
        return AbstractDiagramNodeEditPartOperation.createBorderItemLocator(this, figure, vpElementBorderItem);
    }

    protected Command getPortCreationCommand(Command originalCommand, CreateViewRequest request) {
        CompositeCommand compositeCommand = new CompositeCommand(Messages.IAbstractDiagramNodeEditPart_createViewCommandLabel);
        compositeCommand.compose((IUndoableOperation)new CommandProxy(originalCommand));
        LayoutUtils.prepareFigureForDummyAdds(this.getBorderedFigure().getBorderItemContainer());
        for (CreateViewRequest.ViewDescriptor viewDescriptor : Iterables.filter((Iterable)request.getViewDescriptors(), CreateViewRequest.ViewDescriptor.class)) {
            EObject containerSemanticElement;
            Object createdElement;
            IAdaptable adapt = viewDescriptor.getElementAdapter();
            if (!(adapt instanceof Proxy) || !((createdElement = ((Proxy)adapt).getRealObject()) instanceof DNode) || !((DNode)(containerSemanticElement = this.resolveSemanticElement())).getActualMapping().getAllBorderedNodeMappings().contains((Object)((DNode)createdElement).getActualMapping())) continue;
            Rectangle bounds = PortLayoutHelper.getBounds(this, (DNode)createdElement, viewDescriptor, (DDiagramElement)containerSemanticElement);
            viewDescriptor.setPersisted(true);
            compositeCommand.compose((IUndoableOperation)new SetBoundsCommand(this.getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, bounds));
            compositeCommand.compose((IUndoableOperation)SiriusLayoutDataManager.INSTANCE.getAddAdapterMakerCommand(this.getEditingDomain(), (IAdaptable)viewDescriptor));
        }
        LayoutUtils.releaseDummys(this.getBorderedFigure().getBorderItemContainer());
        return new ICommandProxy(compositeCommand.reduce());
    }

    public Command getResizeBorderItemCommand(ChangeBoundsRequest request) {
        UnexecutableCommand cmd = UnexecutableCommand.INSTANCE;
        boolean valid = true;
        ResizeValidator resizeValidator = new ResizeValidator(request);
        valid = resizeValidator.validate();
        if (valid) {
            for (Object next : request.getEditParts()) {
                if (!(next instanceof IGraphicalEditPart)) break;
                IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)next;
                Command result = DiagramBorderNodeEditPartOperation.getResizeBorderItemCommand(graphicalEditPart, request);
                if (result == null) continue;
                cmd = result;
                break;
            }
        }
        return cmd;
    }

    @Override
    public Image getLabelIcon() {
        return DiagramElementEditPartOperation.getLabelIcon(this);
    }

    @Override
    public void refreshFigure() {
        IStyleEditPart styleEditPart = this.getStyleEditPart();
        if (styleEditPart != null) {
            DiagramNodeEditPartOperation.refreshFigure(styleEditPart);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        DiagramBorderNodeEditPartOperation.refreshVisuals(this);
    }

    protected void refreshFont() {
        super.refreshFont();
        DiagramBorderNodeEditPartOperation.refreshFont(this);
    }

    public EditPolicy getPrimaryDragEditPolicy() {
        SpecificBorderItemSelectionEditPolicy result = new SpecificBorderItemSelectionEditPolicy();
        DDiagramElement dde = this.resolveDiagramElement();
        if (dde instanceof DNode) {
            DNode node = (DNode)dde;
            DiagramBorderNodeEditPartOperation.updateResizeKind((ResizableEditPolicy)result, node);
        }
        return result;
    }

    @Override
    public void setTooltipText(String text) {
        AbstractDiagramNodeEditPartOperation.setTooltipText(this, text);
    }

    public Command getCommand(Request request) {
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        RequestQuery requestQuery = new RequestQuery(request);
        if (!(requestQuery.isNoteCreationRequest() || requestQuery.isTextCreationRequest() || requestQuery.isNoteDropRequest() || requestQuery.isTextDropRequest())) {
            Command cmd = super.getCommand(request);
            result = CommonEditPartOperation.handleAutoPinOnInteractiveMove(this, request, cmd);
        }
        return result;
    }

    @Override
    public ZoomManager getZoomManager() {
        return AbstractDiagramNodeEditPartOperation.getZoomManager(this);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("sourceConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("sourceConnectionAnchorLocation");
                return this.getNodeFigure().getSourceConnectionAnchorAt(realLocation);
            }
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (request instanceof DropRequest) {
            DropRequest dr = (DropRequest)request;
            if (dr.getLocation() != null) {
                ViewLocationHint.getInstance().putData("targetConnectionAnchorLocation", dr.getLocation());
            } else {
                Point realLocation = (Point)ViewLocationHint.getInstance().getData("targetConnectionAnchorLocation");
                return this.getNodeFigure().getTargetConnectionAnchorAt(realLocation);
            }
        }
        return super.getTargetConnectionAnchor(request);
    }

    public DragTracker getDragTracker(Request request) {
        SiriusDragEditPartsTrackerEx result = request instanceof SelectionRequest && ((SelectionRequest)request).getLastButtonPressed() == 3 ? null : new SiriusDragEditPartsTrackerEx((EditPart)this);
        return result;
    }

    protected void performDirectEditRequest(Request request) {
        if (this.getChildren().isEmpty() || !(this.getChildren().get(0) instanceof IDiagramNameEditPart) || this.getNodeLabel() == null) {
            DefaultDirectEditOperation.performDirectEditRequest(this, request, this.getNodeLabel());
        } else {
            super.performDirectEditRequest(request);
        }
    }

    public Object getAdapter(Class key) {
        if (key == SnapToHelper.class) {
            return SiriusSnapToHelperUtil.getSnapHelper((GraphicalEditPart)this);
        }
        return super.getAdapter(key);
    }
}

