/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.metamodel.helper;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionKey;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.BestStyleDescriptionRegistry;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.GetDefaultStyle;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.StyleHelper;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.EdgeMappingImport;
import org.eclipse.sirius.diagram.description.IEdgeMapping;
import org.eclipse.sirius.viewpoint.Style;
import org.eclipse.sirius.viewpoint.description.style.StyleDescription;

public final class MappingHelper {
    private BestStyleDescriptionRegistry bestStyleDescriptionRegistry;
    private StyleHelper styleHelper;

    public MappingHelper(IInterpreter interpreter) {
        this.bestStyleDescriptionRegistry = new BestStyleDescriptionRegistry(interpreter);
        this.styleHelper = new StyleHelper(interpreter);
    }

    public void affectAndRefreshStyle(DiagramElementMapping mapping, DDiagramElement diagramElement, EObject semanticElement, EObject containerVariable, DDiagram parentDiagram) {
        Style currentStyle = diagramElement.getStyle();
        Style bestStyle = this.getBestStyle(mapping, semanticElement, (EObject)diagramElement, containerVariable, parentDiagram);
        this.styleHelper.setAndRefreshStyle(diagramElement, currentStyle, bestStyle);
    }

    public Style getBestStyle(DiagramElementMapping mapping, EObject modelElement, EObject viewVariable, EObject containerVariable, DDiagram parentDiagram) {
        StyleDescription description = this.getBestStyleDescription(mapping, modelElement, viewVariable, containerVariable, parentDiagram);
        Style result = null;
        if (description != null) {
            result = this.styleHelper.createStyle(description);
        }
        return result;
    }

    public StyleDescription getBestStyleDescription(DiagramElementMapping mapping, EObject modelElement, EObject viewVariable, EObject containerVariable, DDiagram parentDiagram) {
        BestStyleDescriptionKey bestStyleDescriptionKey = new BestStyleDescriptionKey(mapping, modelElement, viewVariable, containerVariable, parentDiagram);
        StyleDescription result = this.bestStyleDescriptionRegistry.get(bestStyleDescriptionKey);
        return result;
    }

    public static StyleDescription getDefaultStyleDescription(DiagramElementMapping mapping) {
        return (StyleDescription)new GetDefaultStyle().doSwitch((EObject)mapping);
    }

    public static EdgeMapping getEdgeMapping(EdgeMappingImport edgeMappingImport) {
        EdgeMapping result = null;
        IEdgeMapping iEdgeMapping = edgeMappingImport.getImportedMapping();
        if (iEdgeMapping instanceof EdgeMapping) {
            result = (EdgeMapping)iEdgeMapping;
        } else if (iEdgeMapping instanceof EdgeMappingImport) {
            result = MappingHelper.getEdgeMapping((EdgeMappingImport)iEdgeMapping);
        }
        return result;
    }
}

