/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.ui.tools.internal.views.modelexplorer.extension.tab.ModelExplorerTabDescriptor;

public final class ModelExplorerTabRegistry {
    private static final Collection<ModelExplorerTabDescriptor> EXTENSIONS = new ArrayList<ModelExplorerTabDescriptor>();

    private ModelExplorerTabRegistry() {
    }

    public static void addExtension(ModelExplorerTabDescriptor extension) {
        EXTENSIONS.add(extension);
    }

    public static void clearRegistry() {
        EXTENSIONS.clear();
    }

    public static Collection<ModelExplorerTabDescriptor> getRegisteredExtensions() {
        return Lists.newArrayList(EXTENSIONS);
    }

    public static void removeExtension(String extensionClassName) {
        for (ModelExplorerTabDescriptor extension : ModelExplorerTabRegistry.getRegisteredExtensions()) {
            if (!extension.getExtensionClassName().equals(extensionClassName)) continue;
            EXTENSIONS.remove(extension);
        }
    }

    public static ModelExplorerTabDescriptor getRegisteredExtension(String id) {
        for (ModelExplorerTabDescriptor desc : EXTENSIONS) {
            if (StringUtil.isEmpty((String)desc.getId()) || !desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }
}

