/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.editor;

import java.util.ArrayList;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.internal.editor.SelectionConvertor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.NamedNodeMap;

public class DOMSelectionConvertorFactory
implements IAdapterFactory {
    private static final Class[] ADAPTER_LIST = new Class[]{SelectionConvertor.class};
    private static final Object selectionConvertor = new XMLSelectionConvertor();

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (adaptableObject instanceof IDOMModel && SelectionConvertor.class.equals((Object)adapterType)) {
            return selectionConvertor;
        }
        return null;
    }

    public Class[] getAdapterList() {
        return ADAPTER_LIST;
    }

    private static class XMLSelectionConvertor
    extends SelectionConvertor {
        private XMLSelectionConvertor() {
        }

        public Object[] getElements(IStructuredModel model, int start, int end) {
            IDOMNode node;
            NamedNodeMap attributes;
            Object[] objects;
            IDOMNode region;
            Object[] localSelectedStructures = null;
            if (model != null && (region = (IDOMNode)model.getIndexedRegion(start)) != null) {
                if (end <= region.getEndOffset()) {
                    localSelectedStructures = new Object[]{region};
                } else {
                    ArrayList<IDOMNode> structures = new ArrayList<IDOMNode>(2);
                    IDOMNode node2 = region;
                    while (node2 != null) {
                        structures.add(node2);
                        IDOMNode next = (IDOMNode)node2.getNextSibling();
                        if (next == null) {
                            next = (IDOMNode)node2.getParentNode();
                        }
                        if (next != null && next.getEndOffset() > end) break;
                        node2 = next;
                    }
                    localSelectedStructures = structures.toArray();
                }
            }
            if (localSelectedStructures == null) {
                localSelectedStructures = new Object[]{};
            }
            if ((objects = localSelectedStructures).length == 1 && objects[0] instanceof IDOMNode && (attributes = (node = (IDOMNode)objects[0]).getAttributes()) != null) {
                int i = 0;
                while (i < attributes.getLength()) {
                    IDOMAttr attribute = (IDOMAttr)attributes.item(i);
                    if (attribute.contains(start) && attribute.contains(end)) {
                        objects[0] = attribute;
                        break;
                    }
                    ++i;
                }
            }
            return objects;
        }
    }
}

