/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.internal.json;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.glsp.graph.gson.PropertyBasedTypeAdapter;
import org.eclipse.glsp.server.actions.Action;

public class ActionTypeAdapter
extends PropertyBasedTypeAdapter<Action> {
    private final Map<String, Class<? extends Action>> actions;

    public ActionTypeAdapter(Gson gson, Map<String, Class<? extends Action>> actions) {
        super(gson, "kind");
        this.actions = actions;
    }

    protected Action createInstance(String kind) {
        Class<? extends Action> clazz = this.actions.get(kind);
        if (clazz == null) {
            throw new IllegalArgumentException("Unknown action kind: " + kind);
        }
        try {
            Constructor<? extends Action> constructor = clazz.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("Action class does not have a default constructor.", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to invoke action constructor", e);
        }
    }

    public static class Factory
    implements TypeAdapterFactory {
        private final Map<String, Class<? extends Action>> actions = new HashMap<String, Class<? extends Action>>();

        public Factory(Set<Action> registeredActions) {
            registeredActions.forEach(action -> {
                Class<?> clazz = this.actions.put(action.getKind(), action.getClass());
            });
        }

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            if (!Action.class.isAssignableFrom(typeToken.getRawType())) {
                return null;
            }
            return new ActionTypeAdapter(gson, this.actions);
        }
    }
}

