/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.log4j.Logger;
import org.eclipse.glsp.server.actions.ServerMessageAction;
import org.eclipse.glsp.server.types.Severity;

public final class ServerMessageUtil {
    private static Logger LOGGER = Logger.getLogger(ServerMessageUtil.class);

    private ServerMessageUtil() {
    }

    public static ServerMessageAction message(Severity severity, String message) {
        return new ServerMessageAction(severity, message);
    }

    public static ServerMessageAction info(String message) {
        return new ServerMessageAction(Severity.INFO, message);
    }

    public static ServerMessageAction warn(String message) {
        return new ServerMessageAction(Severity.WARNING, message);
    }

    public static ServerMessageAction error(String message) {
        return new ServerMessageAction(Severity.ERROR, message);
    }

    public static ServerMessageAction error(String message, String details) {
        return new ServerMessageAction(Severity.ERROR, message, details);
    }

    public static ServerMessageAction error(String message, Throwable cause) {
        return new ServerMessageAction(Severity.ERROR, message, ServerMessageUtil.getDetails(cause));
    }

    public static ServerMessageAction error(Exception e) {
        return ServerMessageUtil.error(ServerMessageUtil.getMessage(e), ServerMessageUtil.getDetails(e));
    }

    public static ServerMessageAction message(Severity severity, String message, int timeout) {
        return new ServerMessageAction(severity, message, timeout);
    }

    public static ServerMessageAction info(String message, int timeout) {
        return new ServerMessageAction(Severity.INFO, message, timeout);
    }

    public static ServerMessageAction warn(String message, int timeout) {
        return new ServerMessageAction(Severity.WARNING, message, timeout);
    }

    public static ServerMessageAction error(String message, int timeout) {
        return new ServerMessageAction(Severity.ERROR, message, timeout);
    }

    public static ServerMessageAction error(String message, String details, int timeout) {
        return new ServerMessageAction(Severity.ERROR, message, details, timeout);
    }

    public static ServerMessageAction error(String message, Throwable cause, int timeout) {
        return new ServerMessageAction(Severity.ERROR, message, ServerMessageUtil.getDetails(cause), timeout);
    }

    public static ServerMessageAction error(Exception exception, int timeout) {
        return ServerMessageUtil.error(ServerMessageUtil.getMessage(exception), ServerMessageUtil.getDetails(exception), timeout);
    }

    public static ServerMessageAction clear() {
        return new ServerMessageAction(Severity.NONE, "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getDetails(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (throwable.getMessage() != null) {
            result.append(String.valueOf(throwable.getMessage()) + "\n");
        }
        try {
            Throwable throwable2 = null;
            Object var3_5 = null;
            try {
                StringWriter stackTraceWriter = new StringWriter();
                try {
                    try (PrintWriter printWriter = new PrintWriter(stackTraceWriter);){
                        throwable.printStackTrace(printWriter);
                        result.append(stackTraceWriter.toString());
                    }
                    if (stackTraceWriter == null) return result.toString();
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    if (stackTraceWriter == null) throw throwable2;
                    stackTraceWriter.close();
                    throw throwable2;
                }
                stackTraceWriter.close();
                return result.toString();
            }
            catch (Throwable throwable4) {
                if (throwable2 == null) {
                    throwable2 = throwable4;
                    throw throwable2;
                } else {
                    if (throwable2 == throwable4) throw throwable2;
                    throwable2.addSuppressed(throwable4);
                }
                throw throwable2;
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)"Could not write stacktrace.", (Throwable)ex);
            return null;
        }
    }

    private static String getMessage(Exception e) {
        if (e == null) {
            return "<no-message>";
        }
        if (e.getMessage() != null) {
            return e.getMessage();
        }
        return e.getClass().toString();
    }
}

