/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.operations.gmodel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.glsp.graph.GBoundsAware;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelRoot;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.impl.GPointImpl;
import org.eclipse.glsp.server.gson.GraphGsonConfigurationFactory;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.AbstractOperationHandler;
import org.eclipse.glsp.server.operations.PasteOperation;
import org.eclipse.glsp.server.utils.GModelUtil;
import org.eclipse.glsp.server.utils.GeometryUtil;

public class PasteOperationHandler
extends AbstractOperationHandler<PasteOperation> {
    private static final int DEFAULT_OFFSET = 20;
    @Inject
    protected GModelState modelState;
    protected final Gson gson;

    @Inject
    public PasteOperationHandler(GraphGsonConfigurationFactory gsonConfigurator) {
        GsonBuilder builder = gsonConfigurator.configureGson();
        this.gson = builder.create();
    }

    @Override
    public void executeOperation(PasteOperation operation) {
        ArrayList<GModelElement> elements = this.getCopiedElements(operation.getClipboardData().get("application/json"));
        GeometryUtil.shift(elements, this.computeOffset(elements, operation.getEditorContext().getLastMousePosition()));
        Map<String, String> idMap = this.reassignIds(elements);
        this.filterElements(elements, idMap);
        this.rewireEdges(elements, idMap);
        ((GModelRoot)this.modelState.getRoot()).getChildren().addAll(elements);
    }

    protected ArrayList<GModelElement> getCopiedElements(String jsonString) {
        return new ArrayList<GModelElement>(Arrays.asList((GModelElement[])this.gson.fromJson(jsonString, GModelElement[].class)));
    }

    protected GPoint computeOffset(List<GModelElement> elements, Optional<GPoint> lastMousePosition) {
        Optional<GBoundsAware> referenceElement;
        GPointImpl offset = new GPointImpl();
        offset.setX(20.0);
        offset.setY(20.0);
        if (lastMousePosition.isPresent() && (referenceElement = this.getReferenceElementForPasteOffset(elements)).isPresent()) {
            offset.setX(lastMousePosition.get().getX() - referenceElement.get().getPosition().getX());
            offset.setY(lastMousePosition.get().getY() - referenceElement.get().getPosition().getY());
        }
        return offset;
    }

    protected Optional<GBoundsAware> getReferenceElementForPasteOffset(List<GModelElement> elements) {
        double minY = Double.MAX_VALUE;
        for (GModelElement element : elements) {
            GBoundsAware boundsAware;
            if (!(element instanceof GBoundsAware) || !(minY > (boundsAware = (GBoundsAware)element).getPosition().getY())) continue;
            minY = boundsAware.getPosition().getY();
            return Optional.of(boundsAware);
        }
        return Optional.empty();
    }

    protected Map<String, String> reassignIds(List<GModelElement> elements) {
        HashMap<String, String> idMap = new HashMap<String, String>();
        for (GModelElement element : elements) {
            String newId = UUID.randomUUID().toString();
            idMap.put(element.getId(), newId);
            element.setId(newId);
            idMap.putAll(this.reassignIds((List<GModelElement>)element.getChildren()));
        }
        return idMap;
    }

    protected void filterElements(List<GModelElement> elements, Map<String, String> idMap) {
        List toFilter = elements.stream().filter(e -> this.shouldExcludeElement((GModelElement)e, idMap)).collect(Collectors.toList());
        elements.removeAll(toFilter);
    }

    protected boolean shouldExcludeElement(GModelElement element, Map<String, String> idMap) {
        return false;
    }

    protected void rewireEdges(List<GModelElement> elements, Map<String, String> idMap) {
        GModelUtil.filterByType(elements, GEdge.class).forEach(edge -> {
            if (idMap.containsKey(edge.getSourceId())) {
                edge.setSourceId((String)idMap.get(edge.getSourceId()));
            }
            if (idMap.containsKey(edge.getTargetId())) {
                edge.setTargetId((String)idMap.get(edge.getTargetId()));
            }
        });
    }
}

