/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.gmodel;

import com.google.inject.Inject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GModelIndex;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.server.model.GModelState;
import org.eclipse.glsp.server.operations.AbstractOperationHandler;
import org.eclipse.glsp.server.operations.DeleteOperation;

public class GModelDeleteOperationHandler
extends AbstractOperationHandler<DeleteOperation> {
    private static Logger LOGGER = LogManager.getLogger(GModelDeleteOperationHandler.class);
    protected Set<String> allDependantsIds;
    @Inject
    protected GModelState modelState;

    @Override
    public void executeOperation(DeleteOperation operation) {
        List<String> elementIds = operation.getElementIds();
        if (elementIds == null || elementIds.size() == 0) {
            LOGGER.warn("Elements to delete are not specified");
            return;
        }
        GModelIndex index = this.modelState.getIndex();
        this.allDependantsIds = new HashSet<String>();
        boolean success = elementIds.stream().allMatch(eId -> this.delete((String)eId, index));
        if (!success) {
            LOGGER.warn("Could not delete all elements as requested (see messages above to find out why)");
        }
    }

    protected boolean delete(String elementId, GModelIndex index) {
        if (this.allDependantsIds.contains(elementId)) {
            return true;
        }
        Optional element = index.get(elementId);
        if (!element.isPresent()) {
            LOGGER.warn("Element not found: " + elementId);
            return false;
        }
        GModelElement nodeToDelete = this.findTopLevelElement((GModelElement)element.get());
        if (nodeToDelete.getParent() == null) {
            LOGGER.warn("The requested node doesn't have a parent; it can't be deleted");
            return false;
        }
        LinkedHashSet<GModelElement> dependents = new LinkedHashSet<GModelElement>();
        this.collectDependents(dependents, nodeToDelete, this.modelState);
        dependents.forEach(EcoreUtil::delete);
        this.allDependantsIds.addAll(dependents.stream().map(GModelElement::getId).collect(Collectors.toSet()));
        return true;
    }

    protected void collectDependents(Set<GModelElement> dependents, GModelElement nodeToDelete, GModelState modelState) {
        if (dependents.contains(nodeToDelete)) {
            return;
        }
        if (nodeToDelete.getChildren() != null) {
            for (GModelElement child : nodeToDelete.getChildren()) {
                this.collectDependents(dependents, child, modelState);
            }
        }
        if (nodeToDelete instanceof GNode) {
            GModelIndex index = modelState.getIndex();
            for (GModelElement incoming : index.getIncomingEdges(nodeToDelete)) {
                this.collectDependents(dependents, incoming, modelState);
            }
            for (GModelElement outgoing : index.getOutgoingEdges(nodeToDelete)) {
                this.collectDependents(dependents, outgoing, modelState);
            }
        }
        dependents.add(nodeToDelete);
    }

    protected GModelElement findTopLevelElement(GModelElement element) {
        if (element instanceof GNode || element instanceof GEdge) {
            return element;
        }
        GModelElement parent = element.getParent();
        if (parent == null) {
            return element;
        }
        return this.findTopLevelElement(parent);
    }
}

