/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.layout;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.elk.core.LayoutConfigurator;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.properties.IPropertyHolder;
import org.eclipse.elk.graph.properties.MapPropertyHolder;
import org.eclipse.glsp.layout.ElkLayoutEngine;

public class GLSPLayoutConfigurator
extends LayoutConfigurator {
    public static final Pattern ID_REPLACE_PATTERN = Pattern.compile("\\W|^\\d");
    protected final Map<String, MapPropertyHolder> idOptionMap = new HashMap<String, MapPropertyHolder>();
    protected final Map<String, MapPropertyHolder> typeOptionMap = new HashMap<String, MapPropertyHolder>();

    public static String toElkId(String gmodelId) {
        if (gmodelId == null || gmodelId.isEmpty()) {
            return null;
        }
        return ID_REPLACE_PATTERN.matcher(gmodelId).replaceAll("_");
    }

    public IPropertyHolder configureById(String id) {
        String replacedId = GLSPLayoutConfigurator.toElkId(id);
        MapPropertyHolder result = this.idOptionMap.get(replacedId);
        if (result == null) {
            result = new MapPropertyHolder();
            this.idOptionMap.put(replacedId, result);
        }
        return result;
    }

    public final IPropertyHolder getPropertiesById(String id) {
        return (IPropertyHolder)this.idOptionMap.get(GLSPLayoutConfigurator.toElkId(id));
    }

    public IPropertyHolder configureByType(String type) {
        MapPropertyHolder result = this.typeOptionMap.get(type);
        if (result == null) {
            result = new MapPropertyHolder();
            this.typeOptionMap.put(type, result);
        }
        return result;
    }

    public final IPropertyHolder getPropertiesByType(String type) {
        return (IPropertyHolder)this.typeOptionMap.get(type);
    }

    public void visit(ElkGraphElement element) {
        super.visit(element);
        IPropertyHolder typeProperties = this.getPropertiesByType((String)element.getProperty(ElkLayoutEngine.P_TYPE));
        this.applyProperties(element, typeProperties);
        IPropertyHolder idProperties = this.getPropertiesById(element.getIdentifier());
        this.applyProperties(element, idProperties);
    }

    public LayoutConfigurator overrideWith(LayoutConfigurator other) {
        if (other instanceof GLSPLayoutConfigurator) {
            return this.overrideWith((GLSPLayoutConfigurator)other);
        }
        return super.overrideWith(other);
    }

    public GLSPLayoutConfigurator overrideWith(GLSPLayoutConfigurator other) {
        MapPropertyHolder thisHolder;
        super.overrideWith((LayoutConfigurator)other);
        for (Map.Entry<String, MapPropertyHolder> entry : other.idOptionMap.entrySet()) {
            thisHolder = this.idOptionMap.get(entry.getKey());
            if (thisHolder == null) {
                thisHolder = new MapPropertyHolder();
                this.idOptionMap.put(entry.getKey(), thisHolder);
            }
            thisHolder.copyProperties((IPropertyHolder)entry.getValue());
        }
        for (Map.Entry<String, MapPropertyHolder> entry : other.typeOptionMap.entrySet()) {
            thisHolder = this.typeOptionMap.get(entry.getKey());
            if (thisHolder == null) {
                thisHolder = new MapPropertyHolder();
                this.typeOptionMap.put(entry.getKey(), thisHolder);
            }
            thisHolder.copyProperties((IPropertyHolder)entry.getValue());
        }
        return this;
    }
}

