/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.server.features.validation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.server.features.validation.Marker;

public interface ModelValidator {
    default public List<Marker> validate(List<GModelElement> elements, String reason) {
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (GModelElement element : elements) {
            if ("live".equals(reason)) {
                markers.addAll(this.doLiveValidation(element));
            } else if ("batch".equals(reason)) {
                markers.addAll(this.doBatchValidation(element));
            } else {
                markers.addAll(this.doValidationForCustomReason(element, reason));
            }
            if (element.getChildren().isEmpty()) continue;
            markers.addAll(this.validate((List<GModelElement>)element.getChildren(), reason));
        }
        return markers;
    }

    default public List<Marker> validate(GModelElement ... elements) {
        return this.validate(List.of(elements), "batch");
    }

    default public List<Marker> doLiveValidation(GModelElement element) {
        return Collections.emptyList();
    }

    default public List<Marker> doBatchValidation(GModelElement element) {
        return Collections.emptyList();
    }

    default public List<Marker> doValidationForCustomReason(GModelElement element, String reason) {
        return Collections.emptyList();
    }
}

