/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.ui.text.reconciler;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.handly.model.Elements;
import org.eclipse.handly.model.ISourceFile;
import org.eclipse.handly.ui.IWorkingCopyManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;

public class WorkingCopyReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private final IWorkingCopyManager workingCopyManager;
    private volatile ISourceFile workingCopy;
    private volatile IProgressMonitor monitor;

    public WorkingCopyReconcilingStrategy(IWorkingCopyManager workingCopyManager) {
        if (workingCopyManager == null) {
            throw new IllegalArgumentException();
        }
        this.workingCopyManager = workingCopyManager;
    }

    public void setDocument(IDocument document) {
        this.setWorkingCopy(this.workingCopyManager.getWorkingCopy(document));
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public final void initialReconcile() {
        this.reconcile(true);
    }

    public final void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(false);
    }

    public final void reconcile(IRegion partition) {
        this.reconcile(false);
    }

    protected void reconcile(ISourceFile workingCopy, boolean initialReconcile, IProgressMonitor monitor) throws CoreException {
        Elements.reconcile((ISourceFile)workingCopy, (IProgressMonitor)monitor);
    }

    private void reconcile(final boolean initialReconcile) {
        final ISourceFile workingCopy = this.getWorkingCopy();
        if (workingCopy == null) {
            return;
        }
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void run() throws Exception {
                WorkingCopyReconcilingStrategy.this.reconcile(workingCopy, initialReconcile, WorkingCopyReconcilingStrategy.this.monitor);
            }

            public void handleException(Throwable exception) {
            }
        });
    }

    private void setWorkingCopy(ISourceFile workingCopy) {
        this.workingCopy = workingCopy;
    }

    private ISourceFile getWorkingCopy() {
        return this.workingCopy;
    }
}

