/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.handly.text;

import junit.framework.TestCase;
import org.eclipse.handly.snapshot.DocumentSnapshot;
import org.eclipse.handly.snapshot.ISnapshot;
import org.eclipse.handly.snapshot.StaleSnapshotException;
import org.eclipse.handly.text.DocumentChange;
import org.eclipse.handly.text.DocumentChangeOperation;
import org.eclipse.handly.text.IDocumentChange;
import org.eclipse.handly.text.UiDocumentChangeRunner;
import org.eclipse.handly.util.SimpleSynchronizer;
import org.eclipse.handly.util.UiSynchronizer;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.TextEdit;

public class UiDocumentChangeRunnerTest
extends TestCase {
    private IDocument document;
    private SimpleSynchronizer synchronizer;

    protected void setUp() throws Exception {
        super.setUp();
        this.document = new Document();
        this.synchronizer = new SimpleSynchronizer();
    }

    protected void tearDown() throws Exception {
        if (this.synchronizer != null) {
            this.synchronizer.dispose();
        }
        super.tearDown();
    }

    public void test1() throws Exception {
        DocumentChange change = new DocumentChange((TextEdit)new InsertEdit(0, "foo"));
        DocumentChangeOperation operation = new DocumentChangeOperation(this.document, (IDocumentChange)change){

            public IDocumentChange execute() throws BadLocationException {
                UiDocumentChangeRunnerTest.assertSame((Object)UiDocumentChangeRunnerTest.this.synchronizer.getThread(), (Object)Thread.currentThread());
                return super.execute();
            }
        };
        new UiDocumentChangeRunner((UiSynchronizer)this.synchronizer, operation).run();
        UiDocumentChangeRunnerTest.assertEquals((String)"foo", (String)this.document.get());
    }

    public void test2() throws Exception {
        this.synchronizer.syncExec(() -> {
            try {
                this.test1();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void test3() throws Exception {
        DocumentChange change = new DocumentChange((TextEdit)new InsertEdit(0, "foo"));
        change.setBase((ISnapshot)new DocumentSnapshot(this.document));
        this.document.set("bar");
        try {
            new UiDocumentChangeRunner((UiSynchronizer)this.synchronizer, new DocumentChangeOperation(this.document, (IDocumentChange)change)).run();
            UiDocumentChangeRunnerTest.fail();
        }
        catch (StaleSnapshotException staleSnapshotException) {
            // empty catch block
        }
    }
}

